/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.oauth;

import com.dropbox.core.DbxException;
import com.dropbox.core.DbxHost;
import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.DbxRequestUtil;
import com.dropbox.core.http.HttpRequestor;
import com.dropbox.core.json.JsonReadException;
import com.dropbox.core.json.JsonReader;
import com.dropbox.core.json.JsonWriter;
import com.dropbox.core.oauth.DbxOAuthError;
import com.dropbox.core.oauth.DbxOAuthException;
import com.dropbox.core.oauth.DbxRefreshResult;
import com.dropbox.core.util.StringUtil;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class DbxCredential {
    public static final long EXPIRE_MARGIN = 300000L;
    private String accessToken;
    private Long expiresAt;
    private final String refreshToken;
    private final String appKey;
    private final String appSecret;
    public static final JsonReader<DbxCredential> Reader = new JsonReader<DbxCredential>(){

        @Override
        public final DbxCredential read(JsonParser parser) throws IOException, JsonReadException {
            JsonLocation top = JsonReader.expectObjectStart(parser);
            String accessToken = null;
            Long expiresAt = null;
            String refreshToken = null;
            String appKey = null;
            String appSecret = null;
            while (parser.getCurrentToken() == JsonToken.FIELD_NAME) {
                String fieldName = parser.getCurrentName();
                parser.nextToken();
                try {
                    if (fieldName.equals("access_token")) {
                        accessToken = StringReader.readField(parser, fieldName, accessToken);
                        continue;
                    }
                    if (fieldName.equals("expires_at")) {
                        expiresAt = Int64Reader.readField(parser, fieldName, expiresAt);
                        continue;
                    }
                    if (fieldName.equals("refresh_token")) {
                        refreshToken = StringReader.readField(parser, fieldName, refreshToken);
                        continue;
                    }
                    if (fieldName.equals("app_key")) {
                        appKey = StringReader.readField(parser, fieldName, appKey);
                        continue;
                    }
                    if (fieldName.equals("app_secret")) {
                        appSecret = StringReader.readField(parser, fieldName, appSecret);
                        continue;
                    }
                    JsonReader.skipValue(parser);
                }
                catch (JsonReadException ex) {
                    throw ex.addFieldContext(fieldName);
                }
            }
            JsonReader.expectObjectEnd(parser);
            if (accessToken == null) {
                throw new JsonReadException("missing field \"access_token\"", top);
            }
            return new DbxCredential(accessToken, expiresAt, refreshToken, appKey, appSecret);
        }
    };
    public static final JsonWriter<DbxCredential> Writer = new JsonWriter<DbxCredential>(){

        @Override
        public void write(DbxCredential credential, JsonGenerator g) throws IOException {
            g.writeStartObject();
            g.writeStringField("access_token", credential.accessToken);
            if (credential.expiresAt != null) {
                g.writeNumberField("expires_at", credential.expiresAt.longValue());
            }
            if (credential.refreshToken != null) {
                g.writeStringField("refresh_token", credential.refreshToken);
            }
            if (credential.appKey != null) {
                g.writeStringField("app_key", credential.appKey);
            }
            if (credential.appSecret != null) {
                g.writeStringField("app_secret", credential.appSecret);
            }
            g.writeEndObject();
        }
    };

    public DbxCredential(String accessToken) {
        this(accessToken, null, null, null, null);
    }

    public DbxCredential(String accessToken, Long expiresAt, String refreshToken, String appKey) {
        this(accessToken, expiresAt, refreshToken, appKey, null);
    }

    public DbxCredential(String accessToken, Long expiresAt, String refreshToken, String appKey, String appSecret) {
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing access token.");
        }
        if (refreshToken != null && appKey == null) {
            throw new IllegalArgumentException("Can't refresh without app Key.");
        }
        if (refreshToken != null && expiresAt == null) {
            throw new IllegalArgumentException("Missing expireAt.");
        }
        this.accessToken = accessToken;
        this.expiresAt = expiresAt;
        this.refreshToken = refreshToken;
        this.appKey = appKey;
        this.appSecret = appSecret;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public Long getExpiresAt() {
        return this.expiresAt;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public boolean aboutToExpire() {
        if (this.getExpiresAt() == null) {
            return false;
        }
        return System.currentTimeMillis() + 300000L > this.getExpiresAt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbxRefreshResult refresh(DbxRequestConfig requestConfig, DbxHost host, Collection<String> scope) throws DbxException {
        if (this.refreshToken == null) {
            throw new DbxOAuthException(null, new DbxOAuthError("invalid_request", "Cannot refresh becasue there is no refresh token"));
        }
        if (this.appKey == null) {
            throw new IllegalStateException("DbxCredential's constructor should always guarantee appKey is not null if refreshToken is not null.");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("grant_type", "refresh_token");
        params.put("refresh_token", this.refreshToken);
        params.put("locale", requestConfig.getUserLocale());
        ArrayList<HttpRequestor.Header> headers = new ArrayList<HttpRequestor.Header>();
        if (this.appSecret == null) {
            params.put("client_id", this.appKey);
        } else {
            DbxRequestUtil.addBasicAuthHeader(headers, this.appKey, this.appSecret);
        }
        if (scope != null) {
            String scopeString = StringUtil.join(scope, " ");
            params.put("scope", scopeString);
        }
        DbxRefreshResult dbxRefreshResult = DbxRequestUtil.doPostNoAuth(requestConfig, "OfficialDropboxJavaSDKv2", host.getApi(), "oauth2/token", DbxRequestUtil.toParamsArray(params), headers, new DbxRequestUtil.ResponseHandler<DbxRefreshResult>(){

            @Override
            public DbxRefreshResult handle(HttpRequestor.Response response) throws DbxException {
                if (response.getStatusCode() != 200) {
                    String requestId = DbxRequestUtil.getRequestId(response);
                    DbxOAuthError dbxOAuthError = DbxRequestUtil.readJsonFromResponse(DbxOAuthError.Reader, response);
                    throw new DbxOAuthException(requestId, dbxOAuthError);
                }
                return DbxRequestUtil.readJsonFromResponse(DbxRefreshResult.Reader, response);
            }
        });
        DbxCredential dbxCredential = this;
        synchronized (dbxCredential) {
            this.accessToken = dbxRefreshResult.getAccessToken();
            this.expiresAt = dbxRefreshResult.getExpiresAt();
        }
        return dbxRefreshResult;
    }

    public DbxRefreshResult refresh(DbxRequestConfig requestConfig) throws DbxException {
        return this.refresh(requestConfig, DbxHost.DEFAULT, null);
    }

    public DbxRefreshResult refresh(DbxRequestConfig requestConfig, Collection<String> scope) throws DbxException {
        return this.refresh(requestConfig, DbxHost.DEFAULT, scope);
    }

    public String toString() {
        return Writer.writeToString(this);
    }
}

