/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2;

import com.dropbox.core.DbxHost;
import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.DbxRequestUtil;
import com.dropbox.core.http.HttpRequestor;
import com.dropbox.core.oauth.DbxRefreshResult;
import com.dropbox.core.v2.DbxAppClientV2Base;
import com.dropbox.core.v2.DbxRawClientV2;
import com.dropbox.core.v2.common.PathRoot;
import java.util.List;

public class DbxAppClientV2
extends DbxAppClientV2Base {
    public DbxAppClientV2(DbxRequestConfig requestConfig, String key, String secret) {
        this(requestConfig, key, secret, DbxHost.DEFAULT);
    }

    public DbxAppClientV2(DbxRequestConfig requestConfig, String key, String secret, DbxHost host) {
        super(new DbxAppRawClientV2(requestConfig, key, secret, host, null));
    }

    public DbxAppClientV2(DbxRequestConfig requestConfig, String key, String secret, DbxHost host, String userId) {
        super(new DbxAppRawClientV2(requestConfig, key, secret, host, userId));
    }

    private static final class DbxAppRawClientV2
    extends DbxRawClientV2 {
        private final String key;
        private final String secret;

        private DbxAppRawClientV2(DbxRequestConfig requestConfig, String key, String secret, DbxHost host, String userId) {
            super(requestConfig, host, userId, null);
            this.key = key;
            this.secret = secret;
        }

        @Override
        public DbxRefreshResult refreshAccessToken() {
            return null;
        }

        @Override
        boolean canRefreshAccessToken() {
            return false;
        }

        @Override
        boolean needsRefreshAccessToken() {
            return false;
        }

        @Override
        protected void addAuthHeaders(List<HttpRequestor.Header> headers) {
            DbxRequestUtil.removeAuthHeader(headers);
            DbxRequestUtil.addBasicAuthHeader(headers, this.key, this.secret);
        }

        @Override
        protected DbxRawClientV2 withPathRoot(PathRoot pathRoot) {
            throw new UnsupportedOperationException("App endpoints don't support Dropbox-API-Path-Root header.");
        }
    }
}

