/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.clouddocs;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

class RenameArg {
    protected final String fileId;
    protected final String title;

    public RenameArg(String fileId, String title) {
        if (fileId == null) {
            throw new IllegalArgumentException("Required value for 'fileId' is null");
        }
        this.fileId = fileId;
        if (title == null) {
            throw new IllegalArgumentException("Required value for 'title' is null");
        }
        this.title = title;
    }

    public RenameArg() {
        this("\"\"", "\"\"");
    }

    public String getFileId() {
        return this.fileId;
    }

    public String getTitle() {
        return this.title;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.fileId, this.title});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            RenameArg other = (RenameArg)obj;
            return !(this.fileId != other.fileId && !this.fileId.equals(other.fileId) || this.title != other.title && !this.title.equals(other.title));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<RenameArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(RenameArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("file_id");
            StoneSerializers.string().serialize(value.fileId, g);
            g.writeFieldName("title");
            StoneSerializers.string().serialize(value.title, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public RenameArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_title;
            String f_fileId;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_fileId = "\"\"";
                f_title = "\"\"";
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("file_id".equals(field)) {
                        f_fileId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("title".equals(field)) {
                        f_title = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            RenameArg value = new RenameArg(f_fileId, f_title);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected String fileId = "\"\"";
        protected String title = "\"\"";

        protected Builder() {
        }

        public Builder withFileId(String fileId) {
            this.fileId = fileId != null ? fileId : "\"\"";
            return this;
        }

        public Builder withTitle(String title) {
            this.title = title != null ? title : "\"\"";
            return this;
        }

        public RenameArg build() {
            return new RenameArg(this.fileId, this.title);
        }
    }
}

