/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sftp;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.sftp.SFTPExceptionMappingService;
import ch.cyberduck.core.sftp.SFTPSession;
import ch.cyberduck.core.shared.DefaultHomeFinderService;
import java.io.IOException;
import java.util.EnumSet;

public class SFTPHomeDirectoryService
extends DefaultHomeFinderService {
    private final SFTPSession session;

    public SFTPHomeDirectoryService(SFTPSession session) {
        super(session.getHost());
        this.session = session;
    }

    public Path find() throws BackgroundException {
        Path home = super.find();
        if (home == this.DEFAULT_HOME) {
            try {
                String directory = this.session.sftp().canonicalize(".");
                return new Path(PathNormalizer.normalize((String)directory), directory.equals(String.valueOf('/')) ? EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory) : EnumSet.of(AbstractPath.Type.directory));
            }
            catch (IOException e) {
                throw new SFTPExceptionMappingService().map(e);
            }
        }
        return home;
    }
}

