/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sftp;

import ch.cyberduck.core.AbstractProtocol;
import ch.cyberduck.core.CredentialsConfigurator;
import ch.cyberduck.core.HostnameConfigurator;
import ch.cyberduck.core.JumphostConfigurator;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.sftp.openssh.OpenSSHCredentialsConfigurator;
import ch.cyberduck.core.sftp.openssh.OpenSSHHostnameConfigurator;
import ch.cyberduck.core.sftp.openssh.OpenSSHJumpHostConfigurator;
import org.apache.commons.lang3.StringUtils;

public class SFTPProtocol
extends AbstractProtocol {
    private final CredentialsConfigurator credentials = new OpenSSHCredentialsConfigurator();
    private final HostnameConfigurator hostnmame = new OpenSSHHostnameConfigurator();
    private final JumphostConfigurator jumphost = new OpenSSHJumpHostConfigurator();

    public Protocol.Type getType() {
        return Protocol.Type.sftp;
    }

    public String getIdentifier() {
        return this.getScheme().name();
    }

    public String getPrefix() {
        return String.format("%s.%s", SFTPProtocol.class.getPackage().getName(), StringUtils.upperCase((String)this.getType().name()));
    }

    public String getDescription() {
        return LocaleFactory.localizedString((String)"SFTP (SSH File Transfer Protocol)");
    }

    public Scheme getScheme() {
        return Scheme.sftp;
    }

    public String disk() {
        return String.format("%s.tiff", "ftp");
    }

    public boolean isPrivateKeyConfigurable() {
        return true;
    }

    public boolean isEncodingConfigurable() {
        return true;
    }

    public CredentialsConfigurator getCredentialsFinder() {
        return this.credentials;
    }

    public HostnameConfigurator getHostnameFinder() {
        return this.hostnmame;
    }

    public JumphostConfigurator getJumpHostFinder() {
        return this.jumphost;
    }
}

