/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.openstack;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpUploadFeature;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.iterate.openstack.swift.model.StorageObject;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.log4j.Logger;

public class SwiftSmallObjectUploadFeature
extends HttpUploadFeature<StorageObject, MessageDigest> {
    private static final Logger log = Logger.getLogger(SwiftSmallObjectUploadFeature.class);

    public SwiftSmallObjectUploadFeature(Write<StorageObject> writer) {
        super(writer);
    }

    protected InputStream decorate(InputStream in, MessageDigest digest) throws IOException {
        if (null == digest) {
            log.warn((Object)"MD5 calculation disabled");
            return super.decorate(in, null);
        }
        return new DigestInputStream(super.decorate(in, (Object)digest), digest);
    }

    protected MessageDigest digest() throws IOException {
        MessageDigest digest = null;
        if (PreferencesFactory.get().getBoolean("queue.upload.checksum.calculate")) {
            try {
                digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        return digest;
    }

    protected void post(Path file, MessageDigest digest, StorageObject response) throws BackgroundException {
        this.verify(file, digest, Checksum.parse((String)response.getMd5sum()));
    }
}

