/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client.crypto;

import com.joyent.manta.client.crypto.AesCbcCipherDetails;
import com.joyent.manta.client.crypto.AesCtrCipherDetails;
import com.joyent.manta.client.crypto.AesGcmCipherDetails;
import com.joyent.manta.client.crypto.LocallyIllegalAesCipherDetails;
import com.joyent.manta.client.crypto.SupportedCipherDetails;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;

public final class AesCipherDetailsFactory {
    static final int MAX_KEY_LENGTH_FALLBACK = 128;
    static final int MAX_KEY_LENGTH_ALLOWED;

    private AesCipherDetailsFactory() {
    }

    static SupportedCipherDetails buildWith(CipherMode mode, int requestedKeyLengthBits) {
        if (!AesCipherDetailsFactory.keyStrengthAllowedByRuntime(requestedKeyLengthBits)) {
            return new LocallyIllegalAesCipherDetails(requestedKeyLengthBits);
        }
        switch (mode) {
            case CBC: {
                return new AesCbcCipherDetails(requestedKeyLengthBits);
            }
            case CTR: {
                return new AesCtrCipherDetails(requestedKeyLengthBits);
            }
            case GCM: {
                return new AesGcmCipherDetails(requestedKeyLengthBits);
            }
        }
        throw new Error("Invalid CipherMode provided when building AesCipherDetails: " + mode.toString());
    }

    private static boolean keyStrengthAllowedByRuntime(int requestedKeyLengthBits) {
        return requestedKeyLengthBits <= MAX_KEY_LENGTH_ALLOWED;
    }

    static {
        int maxKeyLength;
        try {
            maxKeyLength = Cipher.getMaxAllowedKeyLength("AES");
        }
        catch (NoSuchAlgorithmException nsae) {
            maxKeyLength = 128;
        }
        MAX_KEY_LENGTH_ALLOWED = maxKeyLength;
    }

    public static enum CipherMode {
        CBC,
        CTR,
        GCM;

    }
}

