/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.http;

import com.joyent.manta.http.HttpRange;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.Header;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.methods.HttpGet;

final class ApacheHttpHeaderUtils {
    private ApacheHttpHeaderUtils() {
    }

    static String extractSingleHeaderValue(HttpMessage message, String headerName, boolean required) throws ProtocolException {
        Header[] headers = message.getHeaders(headerName);
        if (0 == headers.length) {
            if (required) {
                throw new ProtocolException(String.format("Required [%s] header for resumable downloads missing", headerName));
            }
            return null;
        }
        if (1 < headers.length) {
            throw new ProtocolException(String.format("Resumable download not compatible with multi-valued [%s] header", headerName));
        }
        Header header = headers[0];
        if (header == null || StringUtils.isBlank((CharSequence)header.getValue())) {
            throw new ProtocolException(String.format("Invalid %s header (blank or missing)", headerName));
        }
        return header.getValue();
    }

    static Pair<String, HttpRange.Request> extractDownloadRequestFingerprint(HttpGet request) throws ProtocolException {
        String ifMatch = null;
        HttpRange.Request range = null;
        ProtocolException ifMatchEx = null;
        ProtocolException rangeEx = null;
        try {
            ifMatch = ApacheHttpHeaderUtils.extractSingleHeaderValue((HttpMessage)request, "If-Match", false);
        }
        catch (ProtocolException e) {
            ifMatchEx = e;
        }
        try {
            String rawRequestRange = ApacheHttpHeaderUtils.extractSingleHeaderValue((HttpMessage)request, "Range", false);
            if (rawRequestRange != null) {
                range = HttpRange.parseRequestRange(rawRequestRange);
            }
        }
        catch (ProtocolException e) {
            rangeEx = e;
        }
        if (ifMatchEx != null && rangeEx != null) {
            throw new ProtocolException(String.format("Incompatible Range and If-Match request headers for resuming download:%n%s%n%s", rangeEx.getMessage(), ifMatchEx.getMessage()));
        }
        if (ifMatchEx != null) {
            throw ifMatchEx;
        }
        if (rangeEx != null) {
            throw rangeEx;
        }
        return ImmutablePair.of((Object)ifMatch, (Object)range);
    }

    static Pair<String, HttpRange.Response> extractDownloadResponseFingerprint(HttpResponse response, boolean allowContentRangeInference) throws ProtocolException {
        long contentLength;
        String etag = ApacheHttpHeaderUtils.extractSingleHeaderValue((HttpMessage)response, "ETag", true);
        try {
            String rawContentLength = ApacheHttpHeaderUtils.extractSingleHeaderValue((HttpMessage)response, "Content-Length", true);
            contentLength = Long.parseUnsignedLong(rawContentLength);
        }
        catch (NumberFormatException e) {
            throw new ProtocolException(String.format("Failed to parse Content-Length response, matching headers: %s", Arrays.deepToString(response.getHeaders("Content-Length"))));
        }
        String rawContentRange = ApacheHttpHeaderUtils.extractSingleHeaderValue((HttpMessage)response, "Content-Range", false);
        if (StringUtils.isBlank((CharSequence)rawContentRange)) {
            if (!allowContentRangeInference) {
                throw new ProtocolException("Content-Range header required but missing.");
            }
            return new ImmutablePair((Object)etag, (Object)new HttpRange.Response(0L, contentLength - 1L, contentLength));
        }
        HttpRange.Response contentRange = HttpRange.parseContentRange(rawContentRange);
        if (contentRange.contentLength() != contentLength) {
            throw new ProtocolException(String.format("Content-Range start-to-end size and Content-Length mismatch: expected [%d], got [%d]", contentRange.contentLength(), contentLength));
        }
        return new ImmutablePair((Object)etag, (Object)contentRange);
    }
}

