/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.http;

import com.joyent.manta.http.MantaHttpHeaders;
import java.io.File;
import java.io.IOException;
import java.net.URLConnection;
import java.nio.file.Files;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.http.entity.ContentType;

public final class ContentTypeLookup {
    private ContentTypeLookup() {
    }

    public static ContentType findOrDefaultContentType(MantaHttpHeaders headers, ContentType defaultContentType) {
        if (headers == null || headers.getContentType() == null) {
            return defaultContentType;
        }
        return ContentType.parse((String)headers.getContentType());
    }

    public static ContentType findOrDefaultContentType(MantaHttpHeaders headers, String filename, File file, ContentType defaultContentType) throws IOException {
        String headerContentType = headers != null ? headers.getContentType() : null;
        String type = (String)ObjectUtils.firstNonNull((Object[])new String[]{headerContentType, URLConnection.guessContentTypeFromName(filename), URLConnection.guessContentTypeFromName(file.getName()), Files.probeContentType(file.toPath())});
        if (type == null) {
            return defaultContentType;
        }
        return ContentType.parse((String)type);
    }

    public static ContentType findOrDefaultContentType(MantaHttpHeaders headers, String filename, ContentType defaultContentType) {
        String headerContentType = headers != null ? headers.getContentType() : null;
        String type = (String)ObjectUtils.firstNonNull((Object[])new String[]{headerContentType, URLConnection.guessContentTypeFromName(filename)});
        if (type == null) {
            return defaultContentType;
        }
        return ContentType.parse((String)type);
    }
}

