/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.connection;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.channels.ClosedChannelException;
import java.util.Arrays;
import org.irods.jargon.core.connection.ClientServerNegotationPolicyFromPropertiesBuilder;
import org.irods.jargon.core.connection.ClientServerNegotiationPolicy;
import org.irods.jargon.core.connection.ConnectionProgressStatus;
import org.irods.jargon.core.connection.ConnectionProgressStatusListener;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSProtocolManager;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.connection.PipelineConfiguration;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.utils.Host;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnection {
    static final Logger log = LoggerFactory.getLogger(AbstractConnection.class);
    protected IRODSProtocolManager irodsProtocolManager;
    private String connectionInternalIdentifier;
    protected volatile boolean connected = false;
    protected Socket connection;
    protected InputStream irodsInputStream;
    protected OutputStream irodsOutputStream;
    protected IRODSSession irodsSession = null;
    protected final IRODSAccount irodsAccount;
    protected final PipelineConfiguration pipelineConfiguration;
    private final long connectTimeInMillis = System.currentTimeMillis();
    private EncryptionType encryptionType = EncryptionType.NONE;
    public static final int HEADER_INT_LENGTH = 4;
    protected byte[] outputBuffer = null;
    private int outputOffset = 0;
    private final ClientServerNegotiationPolicy operativeClientServerNegotiationPolicy;

    ClientServerNegotiationPolicy getOperativeClientServerNegotiationPolicy() {
        return this.operativeClientServerNegotiationPolicy;
    }

    AbstractConnection(IRODSAccount irodsAccount, PipelineConfiguration pipelineConfiguration, IRODSProtocolManager irodsProtocolManager, Socket socket, IRODSSession irodsSession) throws JargonException {
        if (irodsAccount == null) {
            throw new IllegalArgumentException("null irodsAccount");
        }
        if (pipelineConfiguration == null) {
            throw new IllegalArgumentException("null pipelineConfiguration");
        }
        if (irodsProtocolManager == null) {
            throw new IllegalArgumentException("null irodsProtocolManager");
        }
        if (socket == null) {
            throw new IllegalArgumentException("null socket");
        }
        if (irodsSession == null) {
            throw new IllegalArgumentException("null irodsSession");
        }
        this.irodsAccount = irodsAccount;
        this.pipelineConfiguration = pipelineConfiguration;
        this.irodsProtocolManager = irodsProtocolManager;
        this.connection = socket;
        this.irodsSession = irodsSession;
        this.connected = true;
        this.connection = socket;
        this.operativeClientServerNegotiationPolicy = null;
        this.initializeIdentifier(irodsAccount);
        this.initInternalBufferIfNeeded(pipelineConfiguration);
    }

    protected AbstractConnection(IRODSAccount irodsAccount, PipelineConfiguration pipelineConfiguration, IRODSProtocolManager irodsProtocolManager, IRODSSession irodsSession) throws JargonException {
        log.info("AbstractConnection()");
        if (irodsAccount == null) {
            throw new IllegalArgumentException("null irodsAccount");
        }
        if (pipelineConfiguration == null) {
            throw new IllegalArgumentException("null pipelineConfiguration");
        }
        if (irodsProtocolManager == null) {
            throw new IllegalArgumentException("null irodsProtocolManager");
        }
        this.irodsAccount = irodsAccount;
        this.pipelineConfiguration = pipelineConfiguration;
        this.irodsProtocolManager = irodsProtocolManager;
        this.irodsSession = irodsSession;
        if (irodsAccount.getClientServerNegotiationPolicy() != null) {
            log.info("using override negotiation policy from IRODSAccount:{}", (Object)irodsAccount.getClientServerNegotiationPolicy());
            this.operativeClientServerNegotiationPolicy = irodsAccount.getClientServerNegotiationPolicy();
        } else {
            ClientServerNegotationPolicyFromPropertiesBuilder builder = new ClientServerNegotationPolicyFromPropertiesBuilder(irodsSession);
            this.operativeClientServerNegotiationPolicy = builder.buildClientServerNegotiationPolicyFromJargonProperties();
            log.info("using default negotiation policy:{}", (Object)this.operativeClientServerNegotiationPolicy);
        }
        this.initInternalBufferIfNeeded(pipelineConfiguration);
        this.initializeConnection(irodsAccount);
        this.initializeIdentifier(irodsAccount);
    }

    private void initInternalBufferIfNeeded(PipelineConfiguration pipelineConfiguration) {
        if (pipelineConfiguration.getInternalCacheBufferSize() > 0) {
            log.info("using internal cache buffer of size:{}", (Object)pipelineConfiguration.getInternalCacheBufferSize());
            this.outputBuffer = new byte[pipelineConfiguration.getInternalCacheBufferSize()];
        }
    }

    protected void initializeConnection(IRODSAccount irodsAccount) throws JargonException {
        log.debug("initializing connection with account:{}", (Object)irodsAccount);
        if (irodsAccount == null) {
            log.error("no irods account");
            throw new JargonException("no irods account specified, cannot connect");
        }
        if (this.irodsProtocolManager == null) {
            log.error("null irods connection manager");
            throw new JargonException("null irods connection manager");
        }
        log.info("opening irods socket");
        this.connect(irodsAccount);
        this.setConnected(true);
        this.initializeIdentifier(irodsAccount);
    }

    private void initializeIdentifier(IRODSAccount irodsAccount) throws JargonException {
        StringBuilder connectionInternalIdentifierBuilder = new StringBuilder();
        connectionInternalIdentifierBuilder.append(irodsAccount.toURI(false).toASCIIString());
        connectionInternalIdentifierBuilder.append('/');
        connectionInternalIdentifierBuilder.append(Thread.currentThread().getName());
        connectionInternalIdentifierBuilder.append('/');
        connectionInternalIdentifierBuilder.append(System.currentTimeMillis());
        this.connectionInternalIdentifier = connectionInternalIdentifierBuilder.toString();
    }

    protected abstract void connect(IRODSAccount var1) throws JargonException;

    public boolean isConnected() {
        return this.connected;
    }

    public IRODSProtocolManager getIRODSProtocolManager() {
        return this.irodsProtocolManager;
    }

    public String toString() {
        return this.connectionInternalIdentifier;
    }

    public void send(byte[] value) throws IOException {
        try {
            if (value == null) {
                log.info("no value, so do not do the send, this may be ok depending on the operation");
                return;
            }
            if (value.length == 0) {
                return;
            }
            if (this.pipelineConfiguration.getInternalCacheBufferSize() <= 0) {
                this.irodsOutputStream.write(value);
            } else if (value.length + this.outputOffset >= this.pipelineConfiguration.getInternalCacheBufferSize()) {
                this.irodsOutputStream.write(this.outputBuffer, 0, this.outputOffset);
                this.irodsOutputStream.write(value);
                this.outputOffset = 0;
            } else {
                System.arraycopy(value, 0, this.outputBuffer, this.outputOffset, value.length);
                this.outputOffset += value.length;
            }
        }
        catch (IOException ioe) {
            this.getIrodsSession().discardSessionForErrors(this.getIrodsAccount());
            log.error("ioException in send", (Throwable)ioe);
            throw ioe;
        }
    }

    public void send(byte[] value, int offset, int length) throws IOException {
        if (value == null) {
            log.error("value cannot be null");
            throw new IllegalArgumentException("value cannot be null");
        }
        if (value.length == 0) {
            log.warn("nothing to send, ignoring...");
            return;
        }
        if (offset > value.length) {
            String err = "trying to send a byte buffer from an offset that is out of range";
            log.error(err);
            throw new IllegalArgumentException(err);
        }
        if (length <= 0) {
            String err = "send length is zero";
            log.error(err);
            throw new IllegalArgumentException(err);
        }
        byte[] temp = new byte[length];
        System.arraycopy(value, offset, temp, 0, length);
        this.send(temp);
    }

    public void send(String value) throws IOException {
        if (value == null) {
            log.debug("null input packing instruction, do not send");
            return;
        }
        this.send(value.getBytes(this.pipelineConfiguration.getDefaultEncoding()));
    }

    protected void sendInNetworkOrder(int value) throws IOException {
        byte[] bytes = new byte[4];
        Host.copyInt(value, bytes);
        this.send(bytes);
    }

    protected long send(InputStream source, long length, ConnectionProgressStatusListener connectionProgressStatusListener) throws IOException {
        if (source == null) {
            String err = "value is null";
            log.error(err);
            throw new IllegalArgumentException(err);
        }
        int lenThisRead = 0;
        long lenOfTemp = Math.min((long)this.pipelineConfiguration.getInputToOutputCopyBufferByteSize(), length);
        long dataSent = 0L;
        byte[] temp = new byte[(int)lenOfTemp];
        while (length > 0L) {
            if (Thread.interrupted()) {
                throw new IOException("interrupted, consider connection corrupted and return IOException to clear");
            }
            if ((long)temp.length > length) {
                temp = new byte[(int)length];
            }
            if ((lenThisRead = source.read(temp)) == -1) {
                log.info("done with stream");
                break;
            }
            length -= (long)lenThisRead;
            dataSent += (long)lenThisRead;
            this.send(temp, 0, lenThisRead);
            if (connectionProgressStatusListener == null) continue;
            connectionProgressStatusListener.connectionProgressStatusCallback(ConnectionProgressStatus.instanceForSend(lenThisRead));
        }
        log.debug("final flush of data sent");
        this.flush();
        log.info("total sent:{}", (Object)dataSent);
        return dataSent;
    }

    public void flush() throws IOException {
        if (this.connection.isClosed()) {
            throw new ClosedChannelException();
        }
        if (this.pipelineConfiguration.getInternalCacheBufferSize() > 0) {
            this.irodsOutputStream.write(this.outputBuffer, 0, this.outputOffset);
            this.irodsOutputStream.flush();
            byte zerByte = 0;
            Arrays.fill(this.outputBuffer, zerByte);
            this.outputOffset = 0;
        } else {
            this.irodsOutputStream.flush();
        }
    }

    protected byte read() throws IOException {
        return (byte)this.irodsInputStream.read();
    }

    protected int read(byte[] value) throws IOException {
        return this.read(value, 0, value.length);
    }

    void read(OutputStream destination, long length) throws IOException {
        this.read(destination, length, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(OutputStream destination, long length, ConnectionProgressStatusListener intraFileStatusListener) throws IOException {
        if (destination == null) {
            String err = "destination is null";
            log.error(err);
            throw new IllegalArgumentException(err);
        }
        if (length == 0L) {
            String err = "read length is set to zero";
            log.error(err);
            throw new IllegalArgumentException(err);
        }
        BufferedOutputStream bos = new BufferedOutputStream(destination);
        try {
            byte[] temp = new byte[Math.min(this.pipelineConfiguration.getInputToOutputCopyBufferByteSize(), (int)length)];
            int n = 0;
            while (length > 0L) {
                if (Thread.interrupted()) {
                    bos.close();
                    throw new IOException("interrupted, consider connection corrupted and return IOException to clear");
                }
                n = this.read(temp, 0, Math.min(this.pipelineConfiguration.getInputToOutputCopyBufferByteSize(), (int)length));
                if (n > 0) {
                    length -= (long)n;
                    bos.write(temp, 0, n);
                    if (intraFileStatusListener == null) continue;
                    intraFileStatusListener.connectionProgressStatusCallback(ConnectionProgressStatus.instanceForSend(n));
                    continue;
                }
                length = n;
            }
            bos.flush();
        }
        finally {
            try {
                bos.close();
            }
            catch (Exception exception) {}
        }
    }

    protected int read(byte[] value, int offset, int length) throws ClosedChannelException, InterruptedIOException, IOException {
        if (value == null) {
            String err = "no data sent";
            log.error(err);
            throw new IllegalArgumentException(err);
        }
        if (log.isDebugEnabled()) {
            log.debug("IRODSConnection.read, byte array size =  {}", (Object)value.length);
            log.debug("offset = {}", (Object)offset);
            log.debug("length = {}", (Object)length);
        }
        if (length == 0) {
            String err = "read length is set to zero";
            log.error(err);
            throw new IOException(err);
        }
        int result = 0;
        if (length + offset > value.length) {
            log.error("index out of bounds exception, length + offset larger then byte array");
            throw new IllegalArgumentException("length + offset larger than byte array");
        }
        try {
            int bytesRead;
            int read;
            for (bytesRead = 0; bytesRead < length; bytesRead += read) {
                if (Thread.interrupted()) {
                    throw new IOException("interrupted, consider connection corrupted and return IOException to clear");
                }
                read = this.irodsInputStream.read(value, offset + bytesRead, length - bytesRead);
                if (read == -1) break;
            }
            result = bytesRead;
            return result;
        }
        catch (ClosedChannelException e) {
            log.error("exception reading from socket", (Throwable)e);
            throw e;
        }
        catch (InterruptedIOException e) {
            log.error("exception reading from socket", (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            log.error("exception reading from socket", (Throwable)e);
            throw e;
        }
    }

    protected IRODSSession getIrodsSession() {
        return this.irodsSession;
    }

    protected void setIrodsSession(IRODSSession irodsSession) {
        this.irodsSession = irodsSession;
    }

    public IRODSAccount getIrodsAccount() {
        return this.irodsAccount;
    }

    protected void finalize() throws Throwable {
        if (this.connected) {
            log.error("**************************************************************************************");
            log.error("********  WARNING: POTENTIAL CONNECTION LEAK  ******************");
            log.error("********  finalizer has run and found a connection left opened, please check your code to ensure that all connections are closed");
            log.error("********  connection is:{}, will attempt to disconnect", (Object)this.connectionInternalIdentifier);
            log.error("**************************************************************************************");
            this.shutdown();
        }
        super.finalize();
    }

    public void setIrodsProtocolManager(IRODSProtocolManager irodsProtocolManager) {
        this.irodsProtocolManager = irodsProtocolManager;
    }

    protected InputStream getIrodsInputStream() {
        return this.irodsInputStream;
    }

    protected OutputStream getIrodsOutputStream() {
        return this.irodsOutputStream;
    }

    protected PipelineConfiguration getPipelineConfiguration() {
        return this.pipelineConfiguration;
    }

    protected Socket getConnection() {
        return this.connection;
    }

    protected void setConnected(boolean connected) {
        this.connected = connected;
    }

    protected abstract void shutdown() throws JargonException;

    protected abstract void obliterateConnectionAndDiscardErrors();

    public String getConnectionInternalIdentifier() {
        return this.connectionInternalIdentifier;
    }

    protected EncryptionType getEncryptionType() {
        return this.encryptionType;
    }

    protected void setEncryptionType(EncryptionType encryptionType) {
        this.encryptionType = encryptionType;
    }

    public long getConnectTimeInMillis() {
        return this.connectTimeInMillis;
    }

    public static enum EncryptionType {
        NONE,
        SSL_WRAPPED;

    }
}

