/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.connection;

public class IrodsVersion
implements Comparable<IrodsVersion> {
    public static final String RODS_PREFIX = "rods";
    private final String origVersion;
    private final String majorAsString;
    private final String minorAsString;
    private final String patchAsString;
    private final int major;
    private final int minor;
    private final int patch;

    public IrodsVersion(String reportedVersion) {
        if (reportedVersion == null || reportedVersion.isEmpty()) {
            throw new IllegalArgumentException("null or empty reportedVersion");
        }
        int i = reportedVersion.indexOf(RODS_PREFIX);
        if (i == -1) {
            throw new IllegalArgumentException("reported version is not a valid version string");
        }
        this.origVersion = reportedVersion.substring(RODS_PREFIX.length());
        String[] tokens = this.origVersion.split("\\.");
        if (tokens.length != 3 && tokens.length != 2) {
            throw new IllegalArgumentException("version is not major.minor.patch");
        }
        this.majorAsString = tokens[0];
        this.minorAsString = tokens[1];
        this.patchAsString = tokens.length == 2 ? "0" : tokens[2];
        this.major = Integer.parseInt(this.majorAsString);
        this.minor = Integer.parseInt(this.minorAsString);
        this.patch = Integer.parseInt(this.patchAsString);
    }

    public String getPatchAsString() {
        return this.patchAsString;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("IrodsVersion [");
        if (this.origVersion != null) {
            builder.append("origVersion=").append(this.origVersion).append(", ");
        }
        if (this.majorAsString != null) {
            builder.append("majorAsString=").append(this.majorAsString).append(", ");
        }
        if (this.minorAsString != null) {
            builder.append("minorAsString=").append(this.minorAsString).append(", ");
        }
        if (this.patchAsString != null) {
            builder.append("patchAsString=").append(this.patchAsString).append(", ");
        }
        builder.append("major=").append(this.major).append(", minor=").append(this.minor).append(", patch=").append(this.patch).append("]");
        return builder.toString();
    }

    public String getOrigVersion() {
        return this.origVersion;
    }

    public String getMajorAsString() {
        return this.majorAsString;
    }

    public String getMinorAsString() {
        return this.minorAsString;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public boolean hasVersionOfAtLeast(String versionString) {
        return this.compareTo(new IrodsVersion(versionString)) >= 0;
    }

    @Override
    public int compareTo(IrodsVersion otherVersion) {
        if (this.major < otherVersion.major) {
            return -1;
        }
        if (this.major > otherVersion.major) {
            return 1;
        }
        if (this.minor < otherVersion.minor) {
            return -1;
        }
        if (this.minor > otherVersion.minor) {
            return 1;
        }
        if (this.patch < otherVersion.patch) {
            return -1;
        }
        if (this.patch > otherVersion.patch) {
            return 1;
        }
        return 0;
    }
}

