/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.connection;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import org.irods.jargon.core.connection.AbstractIRODSMidLevelProtocol;
import org.irods.jargon.core.connection.AuthMechanism;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.PasswordObfuscator;
import org.irods.jargon.core.connection.StartupResponseData;
import org.irods.jargon.core.connection.auth.AuthResponse;
import org.irods.jargon.core.exception.AuthenticationException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.AuthResponseInp;
import org.irods.jargon.core.utils.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardIRODSAuth
extends AuthMechanism {
    public static final Logger log = LoggerFactory.getLogger(StandardIRODSAuth.class);

    private String sendStandardPassword(IRODSAccount irodsAccount, AbstractIRODSMidLevelProtocol irodsCommands) throws JargonException {
        log.info("sending standard irods password");
        this.cachedChallenge = this.sendAuthRequestAndGetChallenge(irodsCommands);
        String response = this.challengeResponse(this.cachedChallenge, irodsAccount.getPassword(), irodsCommands);
        AuthResponseInp authResponse_PI = new AuthResponseInp(irodsAccount.getProxyName(), response);
        irodsCommands.irodsFunction("RODS_API_REQ", authResponse_PI.getParsedTags(), 704);
        return this.cachedChallenge;
    }

    private String challengeResponse(String challenge, String password, AbstractIRODSMidLevelProtocol irodsCommands) throws JargonException {
        byte[] chal = null;
        byte[] temp = Base64.fromString(challenge);
        if (IRODSAccount.isDefaultObfuscate()) {
            try {
                password = new PasswordObfuscator(new File(password)).encodePassword();
            }
            catch (Throwable e) {
                log.error("error during account obfuscation", e);
            }
        }
        if (password.length() >= 50) {
            log.error("password is too long");
            throw new IllegalArgumentException("Password is too long");
        }
        chal = new byte[114];
        System.arraycopy(temp, 0, chal, 0, temp.length);
        try {
            temp = password.getBytes(irodsCommands.getPipelineConfiguration().getDefaultEncoding());
        }
        catch (UnsupportedEncodingException e1) {
            log.error("unsupported encoding of:{}", (Object)irodsCommands.getPipelineConfiguration().getDefaultEncoding(), (Object)e1);
            throw new JargonException("unsupported encoding:" + irodsCommands.getPipelineConfiguration().getDefaultEncoding());
        }
        System.arraycopy(temp, 0, chal, 64, temp.length);
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            chal = digest.digest(chal);
        }
        catch (GeneralSecurityException e) {
            SecurityException se = new SecurityException();
            se.initCause(e);
            log.error("general security exception, initCause is:" + e.getMessage(), (Throwable)e);
            throw se;
        }
        for (int i = 0; i < chal.length; ++i) {
            if (chal[i] != 0) continue;
            chal[i] = 1;
        }
        return Base64.toString(chal);
    }

    @Override
    protected AbstractIRODSMidLevelProtocol processAuthenticationAfterStartup(IRODSAccount irodsAccount, AbstractIRODSMidLevelProtocol irodsCommands, StartupResponseData startupResponseData) throws AuthenticationException, JargonException {
        log.info("authenticate");
        String challengeValue = this.sendStandardPassword(irodsAccount, irodsCommands);
        log.info("auth was successful");
        AuthResponse authResponse = new AuthResponse();
        authResponse.setAuthenticatedIRODSAccount(irodsAccount);
        authResponse.setAuthenticatingIRODSAccount(irodsAccount);
        authResponse.setChallengeValue(challengeValue);
        authResponse.setStartupResponse(startupResponseData);
        authResponse.setSuccessful(true);
        log.info("auth response was:{}", (Object)authResponse);
        irodsCommands.setAuthResponse(authResponse);
        irodsCommands.setIrodsAccount(irodsAccount);
        return irodsCommands;
    }
}

