/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.packinstr;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.irods.jargon.core.exception.JargonRuntimeException;

public class Tag
implements Cloneable {
    public static final char OPEN_START_TAG = '<';
    public static final char CLOSE_START_TAG = '>';
    public static final String OPEN_END_TAG = "</";
    public static final char CLOSE_END_TAG = '>';
    public static final String CLOSE_END_TAG_STR = ">";
    public static final String CLOSE_END_TAG_WITH_CR = ">\n";
    public static final String AMP = "&amp;";
    public static final String LT = "&lt;";
    public static final String GT = "&gt;";
    public static final String QUOTE = "&quot;";
    public static final String APOS = "&apos;";
    String tagName;
    public List<Tag> tags;
    String value;

    public Tag(String tagName) {
        this.tagName = tagName;
    }

    public Tag(String tagName, int value) {
        this.tagName = tagName;
        this.value = String.valueOf(value);
    }

    public Tag(String tagName, long value) {
        this.tagName = tagName;
        this.value = String.valueOf(value);
    }

    public Tag(String tagName, String value) {
        this.tagName = tagName;
        this.value = value;
    }

    public Tag(String tagName, Tag tag) {
        this.tags = new ArrayList<Tag>();
        this.tagName = tagName;
        this.tags = new ArrayList<Tag>();
        this.tags.add(tag);
    }

    public Tag(String tagName, Tag[] inTags) {
        this.tagName = tagName;
        this.tags = new ArrayList<Tag>();
        for (Tag inTag : inTags) {
            this.tags.add(inTag);
        }
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public void setValue(int value) {
        this.value = String.valueOf(value);
    }

    public void setValue(long value) {
        this.value = String.valueOf(value);
    }

    public void setValue(String value, boolean decode) {
        if (value == null) {
            this.value = null;
            return;
        }
        if (decode) {
            StringBuilder sb = new StringBuilder();
            StringBuilder cache = new StringBuilder();
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (c == '&') {
                    if (cache.length() > 0) {
                        this.evaluateCache(sb, cache);
                    }
                    cache.append(c);
                    continue;
                }
                if (c == ';') {
                    if (cache.length() > 0) {
                        cache.append(c);
                        this.evaluateCache(sb, cache);
                        continue;
                    }
                    sb.append(c);
                    continue;
                }
                if (cache.length() > 0) {
                    cache.append(c);
                    continue;
                }
                sb.append(c);
            }
            if (cache.length() > 0) {
                this.evaluateCache(sb, cache);
            }
            this.value = sb.toString();
            return;
        }
        this.value = value;
    }

    private void evaluateCache(StringBuilder sb, StringBuilder cache) {
        if (cache.length() != 0) {
            if (cache.length() < 4) {
                sb.append((CharSequence)cache);
            } else if (cache.length() > 6) {
                sb.append((CharSequence)cache);
            } else {
                String cacheString = cache.toString();
                if (cacheString.equals(AMP)) {
                    sb.append('&');
                } else if (cacheString.equals(LT)) {
                    sb.append('<');
                } else if (cacheString.equals(GT)) {
                    sb.append('>');
                } else if (cacheString.equals(QUOTE)) {
                    sb.append('\"');
                } else if (cacheString.equals(APOS)) {
                    sb.append('`');
                } else {
                    sb.append((CharSequence)cache);
                }
            }
        }
        cache.delete(0, cache.length());
    }

    public Object getValue() {
        if (this.tags != null) {
            Tag[] outTags = new Tag[this.tags.size()];
            int i = 0;
            for (Tag tag : this.tags) {
                outTags[i++] = tag;
            }
            return outTags;
        }
        return this.value;
    }

    public int getIntValue() {
        return Integer.parseInt(this.value);
    }

    public long getLongValue() {
        return Long.parseLong(this.value);
    }

    public String getStringValue() {
        return this.value;
    }

    public String getName() {
        return this.tagName;
    }

    public int getLength() {
        return this.tags.size();
    }

    public Tag getTag(String tagName) {
        if (this.tags == null) {
            return null;
        }
        for (Tag tag : this.tags) {
            if (!tag.getName().equals(tagName)) continue;
            return tag;
        }
        return null;
    }

    public Tag getTag(String tagName, int index) {
        if (this.tags == null) {
            return null;
        }
        int j = 0;
        for (int i = 0; i < this.tags.size(); ++i) {
            if (!this.tags.get(i).getName().equals(tagName)) continue;
            if (index == j) {
                return this.tags.get(i);
            }
            ++j;
        }
        return null;
    }

    public Tag[] getTags() {
        if (this.tags != null) {
            Tag[] outTags = new Tag[this.tags.size()];
            int i = 0;
            for (Tag tag : this.tags) {
                outTags[i++] = tag;
            }
            return outTags;
        }
        return null;
    }

    public Object[] getTagValues() {
        if (this.tags == null) {
            return null;
        }
        Object[] val = new Object[this.tags.size()];
        for (int i = 0; i < this.tags.size(); ++i) {
            val[i] = this.tags.get(i).getValue();
        }
        return val;
    }

    public void addTag(String name, String val) {
        this.addTag(new Tag(name, val));
    }

    public void addTag(String name, int val) {
        this.addTag(new Tag(name, val));
    }

    public void addTag(Tag add) {
        if (this.tags == null) {
            this.tags = new ArrayList<Tag>();
        }
        this.tags.add(add);
    }

    public void addTags(Tag[] add) {
        if (this.tags == null) {
            this.tags = new ArrayList<Tag>();
        }
        for (Tag addTag : add) {
            this.tags.add(addTag);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object obj) {
        Tag newTag;
        return obj instanceof Tag && (newTag = (Tag)obj).getName().equals(this.tagName) && newTag.getValue().equals(this.value);
    }

    public int hashCode() {
        return this.getName().hashCode() + this.getValue().hashCode();
    }

    public String toString() {
        return this.tagName;
    }

    public String parseTag() {
        StringBuffer parsed = new StringBuffer();
        parsed.append('<');
        parsed.append(this.tagName);
        parsed.append('>');
        if (this.tags != null) {
            for (Tag tag : this.tags) {
                parsed.append(tag.parseTag());
            }
        } else {
            parsed.append(this.escapeChars(this.value));
        }
        parsed.append(OPEN_END_TAG);
        parsed.append(this.tagName);
        parsed.append('>');
        parsed.append("\n");
        return parsed.toString();
    }

    String escapeChars(String out) {
        if (out == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < out.length(); ++i) {
            char c = out.charAt(i);
            if (c == '&') {
                sb.append(AMP);
                continue;
            }
            if (c == '<') {
                sb.append(LT);
                continue;
            }
            if (c == '>') {
                sb.append(GT);
                continue;
            }
            if (c == '\"') {
                sb.append(QUOTE);
                continue;
            }
            if (c == '`') {
                sb.append(APOS);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static void status(Tag message) throws IOException {
        Tag s = message.getTag("status");
        if (s != null && s.getIntValue() < 0) {
            throw new JargonRuntimeException("" + s.getIntValue());
        }
    }

    public static Tag readNextTag(byte[] data, String encoding) throws UnsupportedEncodingException {
        return Tag.readNextTag(data, true, encoding);
    }

    public static Tag readNextTag(byte[] data, boolean decode, String encoding) throws UnsupportedEncodingException {
        if (data == null) {
            return null;
        }
        String d = new String(data, encoding);
        d = d.replaceAll(CLOSE_END_TAG_WITH_CR, CLOSE_END_TAG_STR);
        int start = d.indexOf(60);
        int end = d.indexOf(62, start);
        int offset = 0;
        if (start < 0) {
            return null;
        }
        String tagName = d.substring(start + 1, end);
        StringBuilder sb = new StringBuilder();
        sb.append(OPEN_END_TAG);
        sb.append(tagName);
        sb.append('>');
        end = d.lastIndexOf(sb.toString());
        Tag tag = new Tag(tagName);
        offset = start + tagName.length() + 2;
        while (d.indexOf(60, offset) >= 0 && offset >= 0 && offset < end) {
            offset = Tag.readSubTag(tag, d, offset, decode);
        }
        return tag;
    }

    private static int readSubTag(Tag tag, String data, int offset, boolean decode) throws UnsupportedEncodingException {
        int start = data.indexOf(60, offset);
        if (start < 0) {
            return 1;
        }
        int closeStart = data.indexOf(62, start);
        String tagName = data.substring(start + 1, closeStart);
        StringBuilder sb = new StringBuilder();
        sb.append(OPEN_END_TAG);
        sb.append(tagName);
        sb.append('>');
        int end = data.indexOf(sb.toString(), closeStart);
        int subTagStart = data.indexOf(60, closeStart);
        Tag subTag = new Tag(tagName);
        tag.addTag(subTag);
        offset = start + tagName.length() + 2;
        if (subTagStart == end) {
            subTag.setValue(data.substring(offset, end), decode);
            return end + tagName.length() + 3;
        }
        while (data.indexOf(60, offset) >= 0 && offset >= 0 && offset < end) {
            offset = Tag.readSubTag(subTag, data, offset, decode);
        }
        return offset + tagName.length() + 3;
    }

    public static Tag createKeyValueTag(String keyword, String value) {
        return Tag.createKeyValueTag(new String[][]{{keyword, value}});
    }

    public static Tag createKeyValueTag(String[][] keyValue) {
        int i;
        Tag pair = new Tag("KeyValPair_PI", new Tag("ssLen", 0));
        int ssLength = 0;
        if (keyValue == null) {
            return pair;
        }
        for (i = 0; i < keyValue.length; ++i) {
            if (keyValue[i] == null || keyValue[i][0] == null) continue;
            pair.addTag("keyWord", keyValue[i][0]);
            ++ssLength;
        }
        pair.tags.get(0).setValue(ssLength);
        if (i == 0) {
            return pair;
        }
        for (i = 0; i < keyValue.length; ++i) {
            if (keyValue[i] == null || keyValue[i][0] == null) continue;
            pair.addTag("svalue", keyValue[i][1]);
        }
        return pair;
    }
}

