/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.StructFileExtAndRegInp;
import org.irods.jargon.core.pub.BulkFileOperationsAO;
import org.irods.jargon.core.pub.IRODSGenericAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkFileOperationsAOImpl
extends IRODSGenericAO
implements BulkFileOperationsAO {
    public static final Logger log = LoggerFactory.getLogger(BulkFileOperationsAOImpl.class);

    BulkFileOperationsAOImpl(IRODSSession irodsSession, IRODSAccount irodsAccount) throws JargonException {
        super(irodsSession, irodsAccount);
    }

    @Override
    public void createABundleFromIrodsFilesAndStoreInIrods(String absolutePathToBundleFileToBeCreatedOnIrods, String absolutePathToIrodsCollectionToBeBundled, String resourceNameWhereBundleWillBeStored) throws JargonException {
        if (absolutePathToBundleFileToBeCreatedOnIrods == null || absolutePathToBundleFileToBeCreatedOnIrods.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolutePathToBundleFileToBeCreatedOnIrods");
        }
        if (absolutePathToIrodsCollectionToBeBundled == null || absolutePathToIrodsCollectionToBeBundled.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolutePathToIrodsCollectionToBeBundled");
        }
        if (resourceNameWhereBundleWillBeStored == null) {
            throw new IllegalArgumentException("null resourceNameWhereBundleWillBeStored. set to blank if not used");
        }
        log.info("createABundleFromIrodsFilesAndStoreInIrods, tar file:{}", (Object)absolutePathToBundleFileToBeCreatedOnIrods);
        log.info("source collection for tar:{}", (Object)absolutePathToIrodsCollectionToBeBundled);
        log.info("resource:{}", (Object)resourceNameWhereBundleWillBeStored);
        StructFileExtAndRegInp structFileExtAndRegInp = StructFileExtAndRegInp.instanceForCreateBundle(absolutePathToBundleFileToBeCreatedOnIrods, absolutePathToIrodsCollectionToBeBundled, resourceNameWhereBundleWillBeStored);
        this.getIRODSProtocol().irodsFunction(structFileExtAndRegInp);
    }

    @Override
    public void createABundleFromIrodsFilesAndStoreInIrodsWithForceOption(String absolutePathToBundleFileToBeCreatedOnIrods, String absolutePathToIrodsCollectionToBeBundled, String resourceNameWhereBundleWillBeStored) throws JargonException {
        if (absolutePathToBundleFileToBeCreatedOnIrods == null || absolutePathToBundleFileToBeCreatedOnIrods.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolutePathToBundleFileToBeCreatedOnIrods");
        }
        if (absolutePathToIrodsCollectionToBeBundled == null || absolutePathToIrodsCollectionToBeBundled.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolutePathToIrodsCollectionToBeBundled");
        }
        if (resourceNameWhereBundleWillBeStored == null) {
            throw new IllegalArgumentException("null resourceNameWhereBundleWillBeStored. set to blank if not used");
        }
        log.info("createABundleFromIrodsFilesAndStoreInIrods, tar file:{}", (Object)absolutePathToBundleFileToBeCreatedOnIrods);
        log.info("source collection for tar:{}", (Object)absolutePathToIrodsCollectionToBeBundled);
        log.info("resource:{}", (Object)resourceNameWhereBundleWillBeStored);
        StructFileExtAndRegInp structFileExtAndRegInp = StructFileExtAndRegInp.instanceForCreateBundleWithForceOption(absolutePathToBundleFileToBeCreatedOnIrods, absolutePathToIrodsCollectionToBeBundled, resourceNameWhereBundleWillBeStored);
        this.getIRODSProtocol().irodsFunction(structFileExtAndRegInp);
    }

    @Override
    public void extractABundleIntoAnIrodsCollection(String absolutePathToBundleFileInIrodsToBeExtracted, String absolutePathToIrodsCollectionToHoldExtractedFiles, String resourceNameWhereBundleWillBeExtracted) throws JargonException {
        this.extractABundleIntoAnIrodsCollection(absolutePathToBundleFileInIrodsToBeExtracted, absolutePathToIrodsCollectionToHoldExtractedFiles, resourceNameWhereBundleWillBeExtracted, false, false);
    }

    @Override
    public void extractABundleIntoAnIrodsCollectionWithBulkOperationOptimization(String absolutePathToBundleFileInIrodsToBeExtracted, String absolutePathToIrodsCollectionToHoldExtractedFiles, String resourceNameWhereBundleWillBeExtracted) throws JargonException {
        this.extractABundleIntoAnIrodsCollection(absolutePathToBundleFileInIrodsToBeExtracted, absolutePathToIrodsCollectionToHoldExtractedFiles, resourceNameWhereBundleWillBeExtracted, false, true);
    }

    @Override
    public void extractABundleIntoAnIrodsCollectionWithForceOption(String absolutePathToBundleFileInIrodsToBeExtracted, String absolutePathToIrodsCollectionToHoldExtractedFiles, String resourceNameWhereBundleWillBeExtracted) throws JargonException {
        this.extractABundleIntoAnIrodsCollection(absolutePathToBundleFileInIrodsToBeExtracted, absolutePathToIrodsCollectionToHoldExtractedFiles, resourceNameWhereBundleWillBeExtracted, true, false);
    }

    protected void extractABundleIntoAnIrodsCollection(String absolutePathToBundleFileInIrodsToBeExtracted, String absolutePathToIrodsCollectionToHoldExtractedFiles, String resourceNameWhereBundleWillBeExtracted, boolean force, boolean bulkOperation) throws JargonException {
        StructFileExtAndRegInp structFileExtAndRegInp;
        if (absolutePathToBundleFileInIrodsToBeExtracted == null || absolutePathToBundleFileInIrodsToBeExtracted.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolutePathToBundleFileInIrodsToBeExtracted");
        }
        if (absolutePathToIrodsCollectionToHoldExtractedFiles == null || absolutePathToIrodsCollectionToHoldExtractedFiles.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolutePathToIrodsCollectionToHoldExtractedFiles");
        }
        if (resourceNameWhereBundleWillBeExtracted == null) {
            throw new IllegalArgumentException("null or empty resourceNameWhereBundleWillBeExtracted, set to blank if not used");
        }
        log.info("extractABundleIntoAnIrodsCollection, tar file:{}", (Object)absolutePathToBundleFileInIrodsToBeExtracted);
        log.info("target collection for tar expansio:{}", (Object)absolutePathToIrodsCollectionToHoldExtractedFiles);
        log.info("resource:{}", (Object)resourceNameWhereBundleWillBeExtracted);
        if (force) {
            if (bulkOperation) {
                log.info("force, bulk optimization");
                structFileExtAndRegInp = StructFileExtAndRegInp.instanceForExtractBundleWithForceOptionAndBulkOperation(absolutePathToBundleFileInIrodsToBeExtracted, absolutePathToIrodsCollectionToHoldExtractedFiles, resourceNameWhereBundleWillBeExtracted);
            } else {
                log.info("force, no bulk optimization");
                structFileExtAndRegInp = StructFileExtAndRegInp.instanceForExtractBundleWithForceOption(absolutePathToBundleFileInIrodsToBeExtracted, absolutePathToIrodsCollectionToHoldExtractedFiles, resourceNameWhereBundleWillBeExtracted);
            }
        } else if (bulkOperation) {
            log.info("no force, bulk optimization");
            structFileExtAndRegInp = StructFileExtAndRegInp.instanceForExtractBundleNoForceWithBulkOperation(absolutePathToBundleFileInIrodsToBeExtracted, absolutePathToIrodsCollectionToHoldExtractedFiles, resourceNameWhereBundleWillBeExtracted);
        } else {
            log.info("no force, no bulk optimization");
            structFileExtAndRegInp = StructFileExtAndRegInp.instanceForExtractBundleNoForce(absolutePathToBundleFileInIrodsToBeExtracted, absolutePathToIrodsCollectionToHoldExtractedFiles, resourceNameWhereBundleWillBeExtracted);
        }
        this.getIRODSProtocol().irodsFunction(structFileExtAndRegInp);
    }
}

