/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.irods.jargon.core.checksum.AbstractChecksumComputeStrategy;
import org.irods.jargon.core.checksum.ChecksumManager;
import org.irods.jargon.core.checksum.ChecksumManagerImpl;
import org.irods.jargon.core.checksum.ChecksumValue;
import org.irods.jargon.core.connection.AbstractIRODSMidLevelProtocol;
import org.irods.jargon.core.connection.ConnectionProgressStatusListener;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.DataObjInp;
import org.irods.jargon.core.packinstr.OpenedDataObjInp;
import org.irods.jargon.core.packinstr.TransferOptions;
import org.irods.jargon.core.protovalues.ChecksumEncodingEnum;
import org.irods.jargon.core.pub.DefaultIntraFileProgressCallbackListener;
import org.irods.jargon.core.pub.IRODSAccessObjectFactory;
import org.irods.jargon.core.pub.Stream2StreamAO;
import org.irods.jargon.core.pub.aohelper.AOHelper;
import org.irods.jargon.core.pub.domain.DataObject;
import org.irods.jargon.core.pub.io.ByteCountingCallbackInputStreamWrapper;
import org.irods.jargon.core.pub.io.IRODSFile;
import org.irods.jargon.core.pub.io.IRODSFileFactory;
import org.irods.jargon.core.pub.io.IRODSFileInputStream;
import org.irods.jargon.core.query.AVUQueryElement;
import org.irods.jargon.core.query.BuilderQueryUtils;
import org.irods.jargon.core.query.CollectionAndDataObjectListingEntry;
import org.irods.jargon.core.query.GenQueryBuilderException;
import org.irods.jargon.core.query.IRODSGenQueryBuilder;
import org.irods.jargon.core.query.IRODSQueryResultRow;
import org.irods.jargon.core.query.IRODSQueryResultSetInterface;
import org.irods.jargon.core.query.JargonQueryException;
import org.irods.jargon.core.query.MetaDataAndDomainData;
import org.irods.jargon.core.query.QueryConditionOperators;
import org.irods.jargon.core.query.RodsGenQueryEnum;
import org.irods.jargon.core.transfer.TransferControlBlock;
import org.irods.jargon.core.transfer.TransferStatus;
import org.irods.jargon.core.transfer.TransferStatusCallbackListener;
import org.irods.jargon.core.utils.IRODSDataConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataAOHelper
extends AOHelper {
    public static final Logger log = LoggerFactory.getLogger(DataAOHelper.class);
    private final IRODSAccessObjectFactory irodsAccessObjectFactory;
    private final IRODSAccount irodsAccount;
    private final ChecksumManager checksumManager;
    private int putBufferSize = 0;

    DataAOHelper(IRODSAccessObjectFactory irodsAccessObjectFactory, IRODSAccount irodsAccount) throws JargonException {
        if (irodsAccessObjectFactory == null) {
            throw new IllegalArgumentException("null irodsAccessObjectFactory");
        }
        if (irodsAccount == null) {
            throw new IllegalArgumentException("null irodsAccount");
        }
        this.irodsAccessObjectFactory = irodsAccessObjectFactory;
        this.irodsAccount = irodsAccount;
        this.irodsAccessObjectFactory.getJargonProperties().getSendInputStreamBufferSize();
        this.putBufferSize = this.irodsAccessObjectFactory.getJargonProperties().getPutBufferSize();
        this.checksumManager = new ChecksumManagerImpl(irodsAccount, irodsAccessObjectFactory);
    }

    void buildSelects(IRODSGenQueryBuilder builder) throws JargonException {
        if (builder == null) {
            throw new IllegalArgumentException("null builder");
        }
        try {
            builder.addSelectAsGenQueryValue(RodsGenQueryEnum.COL_D_DATA_ID).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_D_COLL_ID).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_COLL_NAME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_DATA_NAME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_DATA_REPL_NUM).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_DATA_VERSION).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_DATA_TYPE_NAME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_DATA_SIZE).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_D_RESC_NAME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_D_DATA_PATH).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_D_OWNER_NAME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_D_OWNER_ZONE).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_D_REPL_STATUS).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_D_DATA_STATUS).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_D_DATA_CHECKSUM).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_D_EXPIRY).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_D_MAP_ID).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_D_COMMENTS).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_D_CREATE_TIME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_D_MODIFY_TIME);
        }
        catch (GenQueryBuilderException e) {
            throw new JargonException(e);
        }
    }

    public static DataObject buildDomainFromResultSetRow(IRODSQueryResultRow row) throws JargonException {
        DataObject dataObject = new DataObject();
        dataObject.setId(Integer.parseInt(row.getColumn(0)));
        dataObject.setCollectionId(Integer.parseInt(row.getColumn(1)));
        dataObject.setCollectionName(row.getColumn(2));
        dataObject.setDataName(row.getColumn(3));
        dataObject.setDataReplicationNumber(Integer.parseInt(row.getColumn(4)));
        dataObject.setDataVersion(IRODSDataConversionUtil.getIntOrZeroFromIRODSValue(row.getColumn(5)));
        dataObject.setDataTypeName(row.getColumn(6));
        dataObject.setDataSize(Long.parseLong(row.getColumn(7)));
        dataObject.setResourceName(row.getColumn(8));
        dataObject.setDataPath(row.getColumn(9));
        dataObject.setDataOwnerName(row.getColumn(10));
        dataObject.setDataOwnerZone(row.getColumn(11));
        dataObject.setReplicationStatus(row.getColumn(12));
        dataObject.setDataStatus(row.getColumn(13));
        dataObject.setChecksum(row.getColumn(14));
        dataObject.setExpiry(row.getColumn(15));
        dataObject.setDataMapId(Integer.parseInt(row.getColumn(16)));
        dataObject.setComments(row.getColumn(17));
        dataObject.setCreatedAt(IRODSDataConversionUtil.getDateFromIRODSValue(row.getColumn(18)));
        dataObject.setUpdatedAt(IRODSDataConversionUtil.getDateFromIRODSValue(row.getColumn(19)));
        dataObject.setLastResult(row.isLastResult());
        dataObject.setCount(row.getRecordCount());
        if (log.isInfoEnabled()) {
            log.info("data object built \n");
            log.info(dataObject.toString());
        }
        return dataObject;
    }

    public static List<DataObject> buildListFromResultSet(IRODSQueryResultSetInterface resultSet) throws JargonException {
        ArrayList<DataObject> data = new ArrayList<DataObject>();
        for (IRODSQueryResultRow row : resultSet.getResults()) {
            data.add(DataAOHelper.buildDomainFromResultSetRow(row));
        }
        return data;
    }

    static List<MetaDataAndDomainData> buildMetaDataAndDomainDataListFromResultSet(IRODSQueryResultSetInterface irodsQueryResultSet) throws JargonException {
        if (irodsQueryResultSet == null) {
            throw new JargonException("null irodsQueryResultSet");
        }
        ArrayList<MetaDataAndDomainData> metaDataResults = new ArrayList<MetaDataAndDomainData>();
        for (IRODSQueryResultRow row : irodsQueryResultSet.getResults()) {
            metaDataResults.add(DataAOHelper.buildMetaDataAndDomainDataFromResultSetRowForDataObject(row, irodsQueryResultSet.getTotalRecords()));
        }
        return metaDataResults;
    }

    static MetaDataAndDomainData buildMetaDataAndDomainDataFromResultSetRowForDataObject(IRODSQueryResultRow row, int totalRecordCount) throws JargonException {
        String domainId = row.getColumn(0);
        StringBuilder sb = new StringBuilder();
        sb.append(row.getColumn(1));
        sb.append('/');
        sb.append(row.getColumn(2));
        String domainUniqueName = sb.toString();
        int attributeId = Integer.parseInt(row.getColumn(3));
        String attributeName = row.getColumn(4);
        String attributeValue = row.getColumn(5);
        String attributeUnits = row.getColumn(6);
        MetaDataAndDomainData data = MetaDataAndDomainData.instance(MetaDataAndDomainData.MetadataDomain.DATA, domainId, domainUniqueName, 0L, null, null, attributeId, attributeName, attributeValue, attributeUnits);
        data.setCount(row.getRecordCount());
        data.setLastResult(row.isLastResult());
        data.setTotalRecords(totalRecordCount);
        log.debug("metadataAndDomainData: {}", (Object)data);
        return data;
    }

    void processNormalGetTransfer(File localFileToHoldData, long length, AbstractIRODSMidLevelProtocol irodsProtocol, TransferOptions transferOptions, TransferControlBlock transferControlBlock, TransferStatusCallbackListener transferStatusCallbackListener) throws JargonException {
        BufferedOutputStream localFileOutputStream;
        log.info("normal file transfer started, get output stream for local destination file");
        if (irodsProtocol == null) {
            throw new IllegalArgumentException("null irodsProtocol");
        }
        if (transferOptions == null) {
            throw new IllegalArgumentException("null transferOptions");
        }
        if (transferControlBlock == null) {
            throw new IllegalArgumentException("null transferControlBlock");
        }
        try {
            localFileOutputStream = irodsProtocol.getPipelineConfiguration().getLocalFileOutputStreamBufferSize() <= 0 ? new BufferedOutputStream(new FileOutputStream(localFileToHoldData)) : new BufferedOutputStream(new FileOutputStream(localFileToHoldData), irodsProtocol.getPipelineConfiguration().getLocalFileOutputStreamBufferSize());
        }
        catch (FileNotFoundException e) {
            log.error("FileNotFoundException when trying to create a new file for the local output stream for {}", (Object)localFileToHoldData.getAbsolutePath(), (Object)e);
            throw new JargonException("FileNotFoundException for local file when trying to get to: " + localFileToHoldData.getAbsolutePath(), e);
        }
        ConnectionProgressStatusListener intraFileStatusListener = null;
        if (transferStatusCallbackListener != null && transferControlBlock.getTransferOptions().isIntraFileStatusCallbacks()) {
            intraFileStatusListener = DefaultIntraFileProgressCallbackListener.instance(TransferStatus.TransferType.GET, length, transferControlBlock, transferStatusCallbackListener);
        }
        irodsProtocol.read(localFileOutputStream, length, intraFileStatusListener);
        log.info("transfer is complete");
        try {
            localFileOutputStream.flush();
            localFileOutputStream.close();
        }
        catch (IOException e) {
            log.error("IOException when trying to create a new file for the local output stream for {}", (Object)localFileToHoldData.getAbsolutePath(), (Object)e);
            throw new JargonException("IOException for local file when trying to get to: " + localFileToHoldData.getAbsolutePath(), e);
        }
    }

    void processNormalPutTransfer(File localFile, boolean overwrite, IRODSFile targetFile, AbstractIRODSMidLevelProtocol irodsProtocol, TransferControlBlock transferControlBlock, TransferStatusCallbackListener transferStatusCallbackListener) throws JargonException, FileNotFoundException {
        if (localFile == null) {
            throw new IllegalArgumentException("null localFile");
        }
        if (targetFile == null) {
            throw new IllegalArgumentException("null targetFile");
        }
        if (irodsProtocol == null) {
            throw new IllegalArgumentException("null irodsProtocol");
        }
        if (transferControlBlock == null) {
            throw new IllegalArgumentException("null transferControlBlock");
        }
        log.info("processNormalPutTransfer");
        TransferOptions myTransferOptions = new TransferOptions(transferControlBlock.getTransferOptions());
        myTransferOptions.setMaxThreads(0);
        boolean execFlag = false;
        if (localFile.canExecute()) {
            log.info("file is executable");
            execFlag = true;
        }
        DataObjInp dataObjInp = DataObjInp.instanceForNormalPutStrategy(targetFile.getAbsolutePath(), localFile.length(), targetFile.getResource(), overwrite, myTransferOptions, execFlag);
        if (myTransferOptions != null && (myTransferOptions.isComputeAndVerifyChecksumAfterTransfer() || myTransferOptions.isComputeChecksumAfterTransfer())) {
            log.info("computing a checksum on the file at:{}", (Object)localFile.getAbsolutePath());
            ChecksumValue localFileChecksum = this.computeLocalFileChecksum(localFile, null);
            log.info("local file checksum is:{}", (Object)localFileChecksum);
            dataObjInp.setFileChecksumValue(localFileChecksum);
        }
        ConnectionProgressStatusListener intraFileStatusListener = null;
        if (transferStatusCallbackListener != null && myTransferOptions.isIntraFileStatusCallbacks()) {
            intraFileStatusListener = DefaultIntraFileProgressCallbackListener.instance(TransferStatus.TransferType.PUT, localFile.length(), transferControlBlock, transferStatusCallbackListener);
        }
        InputStream fileInputStream = new FileInputStream(localFile);
        int inputStreamBuffSize = this.irodsAccessObjectFactory.getJargonProperties().getLocalFileInputStreamBufferSize();
        if (inputStreamBuffSize == 0) {
            log.debug("local file input stream will use default buffering");
            fileInputStream = new BufferedInputStream(fileInputStream);
        } else if (inputStreamBuffSize > 0) {
            log.debug("local file input stream will use specified buffering:{}", (Object)inputStreamBuffSize);
            fileInputStream = new BufferedInputStream(fileInputStream, inputStreamBuffSize);
        }
        irodsProtocol.irodsFunctionIncludingAllDataInStream(dataObjInp, localFile.length(), fileInputStream, intraFileStatusListener);
    }

    ChecksumValue computeLocalFileChecksum(File localFile, ChecksumEncodingEnum overrideChecksumEncoding) throws JargonException {
        log.info("computeLocalFileChecksum()");
        if (localFile == null) {
            throw new IllegalArgumentException("null localFile");
        }
        log.info("localFile:{}", (Object)localFile);
        if (!localFile.exists()) {
            throw new JargonException("file does not exist");
        }
        if (!localFile.isFile()) {
            throw new JargonException("path is not a file");
        }
        ChecksumEncodingEnum checksumEncoding = overrideChecksumEncoding == null ? this.checksumManager.determineChecksumEncodingForTargetServer() : overrideChecksumEncoding;
        log.info("using checksum algorithm:{}", (Object)checksumEncoding);
        AbstractChecksumComputeStrategy strategy = this.irodsAccessObjectFactory.getIrodsSession().getLocalChecksumComputerFactory().instance(checksumEncoding);
        try {
            return strategy.computeChecksumValueForLocalFile(localFile.getAbsolutePath());
        }
        catch (FileNotFoundException e) {
            log.error("cannot find file for computing local checksum", (Throwable)e);
            throw new JargonException("cannot find local file to do the checksum", e);
        }
    }

    @Deprecated
    ChecksumValue computeChecksumValueFromIrodsData(String irodsValue) throws JargonException {
        return this.checksumManager.determineChecksumEncodingFromIrodsData(irodsValue.trim());
    }

    void putReadWriteLoop(File localFile, boolean overwrite, IRODSFile targetFile, int fd, AbstractIRODSMidLevelProtocol irodsProtocol, TransferControlBlock transferControlBlock, ConnectionProgressStatusListener intraFileStatusListener) throws JargonException, FileNotFoundException {
        log.info("put read/write loop");
        if (localFile == null) {
            throw new IllegalArgumentException("null localFile");
        }
        if (targetFile == null) {
            throw new IllegalArgumentException("null targetFile");
        }
        if (irodsProtocol == null) {
            throw new IllegalArgumentException("null irodsProtocol");
        }
        if (transferControlBlock == null) {
            throw new IllegalArgumentException("null transferControlBlock");
        }
        long lengthLeftToSend = localFile.length();
        InputStream fileInputStream = new FileInputStream(localFile);
        int inputStreamBuffSize = this.irodsAccessObjectFactory.getJargonProperties().getLocalFileInputStreamBufferSize();
        if (inputStreamBuffSize == 0) {
            log.debug("local file input stream will use default buffering");
            fileInputStream = new BufferedInputStream(fileInputStream);
        } else if (inputStreamBuffSize > 0) {
            log.debug("local file input stream will use specified buffering:{}", (Object)inputStreamBuffSize);
            fileInputStream = new BufferedInputStream(fileInputStream, inputStreamBuffSize);
        }
        try {
            log.info("starting read/write loop to send data to iRODS");
            OpenedDataObjInp openedDataObjInp = null;
            long lengthThisSend = 0L;
            while (lengthLeftToSend > 0L) {
                if (Thread.interrupted()) {
                    log.info("cancellation detected, set cancelled in tcb");
                    transferControlBlock.setCancelled(true);
                }
                if (transferControlBlock.isCancelled() || transferControlBlock.isPaused()) {
                    log.info("cancelling");
                    break;
                }
                lengthThisSend = Math.min((long)this.putBufferSize, lengthLeftToSend);
                openedDataObjInp = OpenedDataObjInp.instanceForFilePut(fd, lengthThisSend);
                log.debug("length left:{}", (Object)(lengthLeftToSend -= irodsProtocol.irodsFunctionForStreamingToIRODSInFrames(openedDataObjInp, (int)lengthThisSend, fileInputStream, intraFileStatusListener)));
            }
            if (lengthLeftToSend != 0L) {
                log.error("did not send all data");
                this.irodsAccessObjectFactory.getIrodsSession().discardSessionForErrors(this.irodsAccount);
                throw new JargonException("did not send all data");
            }
            log.info("send operation done, send opr complete");
            irodsProtocol.operationComplete(fd);
        }
        catch (Exception e) {
            log.error("error encountered in read/write loop, will rethrow");
            throw new JargonException(e);
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    IRODSFile checkTargetFileForPutOperation(File localFile, IRODSFile irodsFileDestination, boolean ignoreChecks, IRODSFileFactory irodsFileFactory) throws JargonException {
        IRODSFile targetFile;
        if (localFile == null) {
            throw new IllegalArgumentException("null localFile");
        }
        if (irodsFileDestination == null) {
            throw new IllegalArgumentException("null irodsFileDestination");
        }
        if (irodsFileFactory == null) {
            throw new IllegalArgumentException("null irodsFileFactory");
        }
        if (ignoreChecks) {
            log.debug("ignoring iRODS checks, assume this is a data object");
            targetFile = irodsFileDestination;
        } else if (irodsFileDestination.isDirectory()) {
            log.info("put specifying an irods collection, will use the local file name as the iRODS file name:{}", (Object)localFile.getName());
            targetFile = irodsFileFactory.instanceIRODSFile(irodsFileDestination.getAbsolutePath(), localFile.getName());
            targetFile.setResource(irodsFileDestination.getResource());
        } else {
            targetFile = irodsFileDestination;
        }
        return targetFile;
    }

    static void buildACLQueryForCollectionPathAndDataName(String irodsCollectionAbsolutePath, String dataName, IRODSGenQueryBuilder builder) throws JargonException {
        try {
            builder.addSelectAsGenQueryValue(RodsGenQueryEnum.COL_USER_NAME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_DATA_ACCESS_USER_ID).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_DATA_ACCESS_TYPE).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_USER_TYPE).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_USER_ZONE).addConditionAsGenQueryField(RodsGenQueryEnum.COL_COLL_NAME, QueryConditionOperators.EQUAL, irodsCollectionAbsolutePath).addConditionAsGenQueryField(RodsGenQueryEnum.COL_DATA_NAME, QueryConditionOperators.EQUAL, dataName);
        }
        catch (GenQueryBuilderException e) {
            throw new JargonException(e);
        }
    }

    void processGetTransferViaRead(IRODSFile irodsFile, File localFileToHoldData, long irodsFileLength, TransferOptions transferOptions, int fd, TransferControlBlock transferControlBlock, TransferStatusCallbackListener transferStatusCallbackListener) throws JargonException {
        log.info("processGetTransferViaRead()");
        if (localFileToHoldData == null) {
            throw new IllegalArgumentException("null localFileToHoldData");
        }
        if (irodsFileLength < 0L) {
            throw new IllegalArgumentException("irodsFileLength < 0");
        }
        if (fd <= 0) {
            throw new IllegalArgumentException("fd is <= 0");
        }
        log.info("streaming file transfer started, get output stream for local destination file");
        try {
            IRODSFileInputStream ifis = this.irodsAccessObjectFactory.getIRODSFileFactory(this.irodsAccount).instanceIRODSFileInputStreamGivingFD(irodsFile, fd);
            Stream2StreamAO stream2StreamAO = this.irodsAccessObjectFactory.getStream2StreamAO(this.irodsAccount);
            if (transferControlBlock.getTransferOptions().isIntraFileStatusCallbacks() && transferStatusCallbackListener != null) {
                log.info("wrapping stream with callback stream wrapper");
                ConnectionProgressStatusListener connectionProgressStatusListener = DefaultIntraFileProgressCallbackListener.instanceSettingTransferOptions(TransferStatus.TransferType.GET, irodsFileLength, transferControlBlock, transferStatusCallbackListener, transferControlBlock.getTransferOptions());
                ByteCountingCallbackInputStreamWrapper wrapper = new ByteCountingCallbackInputStreamWrapper(connectionProgressStatusListener, ifis);
                stream2StreamAO.transferStreamToFileUsingIOStreams(wrapper, localFileToHoldData, irodsFileLength, this.irodsAccessObjectFactory.getJargonProperties().getGetBufferSize());
            } else {
                stream2StreamAO.transferStreamToFileUsingIOStreams(ifis, localFileToHoldData, irodsFileLength, 0x400000);
            }
        }
        catch (JargonException e) {
            log.error("Exception streaming data to local file from iRODS: {}", (Object)localFileToHoldData.getAbsolutePath(), (Object)e);
            throw e;
        }
        finally {
            irodsFile.closeGivenDescriptor(fd);
        }
    }

    public static void appendConditionPartToBuilderQuery(AVUQueryElement queryElement, IRODSGenQueryBuilder builder) throws JargonQueryException {
        if (queryElement.getAvuQueryPart() == AVUQueryElement.AVUQueryPart.ATTRIBUTE) {
            builder.addConditionAsGenQueryField(RodsGenQueryEnum.COL_META_DATA_ATTR_NAME, BuilderQueryUtils.translateAVUQueryElementOperatorToBuilderQueryCondition(queryElement), queryElement.getValue());
        } else if (queryElement.getAvuQueryPart() == AVUQueryElement.AVUQueryPart.VALUE) {
            builder.addConditionAsGenQueryField(RodsGenQueryEnum.COL_META_DATA_ATTR_VALUE, BuilderQueryUtils.translateAVUQueryElementOperatorToBuilderQueryCondition(queryElement), queryElement.getValue());
        } else if (queryElement.getAvuQueryPart() == AVUQueryElement.AVUQueryPart.UNITS) {
            builder.addConditionAsGenQueryField(RodsGenQueryEnum.COL_META_DATA_ATTR_UNITS, BuilderQueryUtils.translateAVUQueryElementOperatorToBuilderQueryCondition(queryElement), queryElement.getValue());
        } else {
            throw new JargonQueryException("unable to resolve AVU Query part");
        }
    }

    public static void translateAVUQueryElementOperatorToBuilderQueryCondition(AVUQueryElement avuQueryElement) {
    }

    public static void addDataObjectSelectsToBuilder(IRODSGenQueryBuilder builder) throws GenQueryBuilderException {
        if (builder == null) {
            throw new IllegalArgumentException("null builder");
        }
        builder.addSelectAsGenQueryValue(RodsGenQueryEnum.COL_D_DATA_ID).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_D_COLL_ID).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_COLL_NAME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_DATA_NAME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_DATA_REPL_NUM).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_DATA_VERSION).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_DATA_TYPE_NAME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_DATA_SIZE).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_D_RESC_GROUP_NAME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_D_RESC_NAME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_D_DATA_PATH).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_D_OWNER_NAME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_D_OWNER_ZONE).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_D_REPL_STATUS).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_D_DATA_STATUS).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_D_DATA_CHECKSUM).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_D_EXPIRY).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_D_MAP_ID).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_D_COMMENTS).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_D_CREATE_TIME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_D_MODIFY_TIME);
    }

    public static void buildDataObjectQuerySelectsNoReplicationInfo(IRODSGenQueryBuilder builder) throws GenQueryBuilderException {
        if (builder == null) {
            throw new IllegalArgumentException("null builder");
        }
        builder.addSelectAsGenQueryValue(RodsGenQueryEnum.COL_COLL_NAME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_DATA_NAME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_D_DATA_ID).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_DATA_SIZE).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_D_OWNER_NAME);
    }

    public static CollectionAndDataObjectListingEntry buildCollectionListEntryFromResultSetRowForDataObjectQueryNoReplicationInfo(IRODSQueryResultRow row, int totalRecords) throws JargonException {
        CollectionAndDataObjectListingEntry entry = new CollectionAndDataObjectListingEntry();
        entry.setParentPath(row.getColumn(0));
        entry.setObjectType(CollectionAndDataObjectListingEntry.ObjectType.DATA_OBJECT);
        entry.setPathOrName(row.getColumn(1));
        entry.setId(IRODSDataConversionUtil.getIntOrZeroFromIRODSValue(row.getColumn(2)));
        entry.setDataSize(IRODSDataConversionUtil.getLongOrZeroFromIRODSValue(row.getColumn(3)));
        entry.setOwnerName(row.getColumn(4));
        entry.setCount(row.getRecordCount());
        entry.setLastResult(row.isLastResult());
        entry.setTotalRecords(totalRecords);
        log.debug("listing entry built {}", (Object)entry.toString());
        return entry;
    }
}

