/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import java.io.File;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.exception.DataNotFoundException;
import org.irods.jargon.core.exception.FileNotFoundException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.exception.OverwriteException;
import org.irods.jargon.core.pub.CollectionAO;
import org.irods.jargon.core.pub.CollectionAOImpl;
import org.irods.jargon.core.pub.DataObjectAOImpl;
import org.irods.jargon.core.pub.io.IRODSFile;
import org.irods.jargon.core.transfer.TransferControlBlock;
import org.irods.jargon.core.transfer.TransferStatus;
import org.irods.jargon.core.transfer.TransferStatusCallbackListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TransferOperationsHelper {
    static Logger log = LoggerFactory.getLogger(TransferOperationsHelper.class);
    private final DataObjectAOImpl dataObjectAO;
    private final CollectionAO collectionAO;

    static final TransferOperationsHelper instance(IRODSSession irodsSession, IRODSAccount irodsAccount) throws JargonException {
        return new TransferOperationsHelper(irodsSession, irodsAccount);
    }

    private TransferOperationsHelper(IRODSSession irodsSession, IRODSAccount irodsAccount) throws JargonException {
        if (irodsSession == null || irodsAccount == null) {
            throw new JargonException("null irodsSession or irodsAccount");
        }
        this.dataObjectAO = new DataObjectAOImpl(irodsSession, irodsAccount);
        this.collectionAO = new CollectionAOImpl(irodsSession, irodsAccount);
    }

    void recursivelyGet(IRODSFile irodsSourceFile, File targetLocalFile, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock) throws OverwriteException, FileNotFoundException, JargonException {
        log.info("recursively getting source file: {}", (Object)irodsSourceFile.getAbsolutePath());
        log.info("    into iRODS file: {}", (Object)targetLocalFile.getAbsolutePath());
        for (File fileInSourceCollection : irodsSourceFile.listFiles()) {
            if (Thread.interrupted()) {
                log.info("cancellation detected, set cancelled in tcb");
                transferControlBlock.setCancelled(true);
            }
            if (this.collectionAO.getIRODSProtocol().getPipelineConfiguration().getSocketRenewalIntervalInSeconds() > 0) {
                this.collectionAO.getIRODSSession().currentConnectionCheckRenewalOfSocket(this.collectionAO.getIRODSAccount());
            }
            ((IRODSFile)((Object)fileInSourceCollection)).setResource(irodsSourceFile.getResource());
            if (transferControlBlock.isCancelled() || transferControlBlock.isPaused()) {
                log.info("transfer cancelled or paused");
                if (transferStatusCallbackListener != null) {
                    TransferStatus.TransferState interruptStatus = transferControlBlock.shouldTransferBeAbandonedDueToNumberOfErrors() ? TransferStatus.TransferState.FAILURE : (transferControlBlock.isCancelled() ? TransferStatus.TransferState.CANCELLED : TransferStatus.TransferState.PAUSED);
                    TransferStatus status = TransferStatus.instance(TransferStatus.TransferType.GET, fileInSourceCollection.getAbsolutePath(), targetLocalFile.getAbsolutePath(), "", fileInSourceCollection.length(), fileInSourceCollection.length(), transferControlBlock.getTotalFilesTransferredSoFar(), transferControlBlock.getTotalFilesSkippedSoFar(), transferControlBlock.getTotalFilesToTransfer(), interruptStatus, this.dataObjectAO.getIRODSAccount().getHost(), this.dataObjectAO.getIRODSAccount().getZone());
                    transferStatusCallbackListener.statusCallback(status);
                    return;
                }
            }
            try {
                if (fileInSourceCollection.isDirectory()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(targetLocalFile.getAbsolutePath());
                    sb.append('/');
                    sb.append(fileInSourceCollection.getName());
                    log.info("recursively creating parent directory in local file system at: {}", (Object)sb.toString());
                    File newSubCollection = new File(sb.toString());
                    boolean success = newSubCollection.mkdirs();
                    if (!success) {
                        log.warn("unable to make directories in local file system, log and proceed");
                    }
                    this.recursivelyGet((IRODSFile)((Object)fileInSourceCollection), newSubCollection, transferStatusCallbackListener, transferControlBlock);
                    continue;
                }
                this.processGetOfSingleFile((IRODSFile)((Object)fileInSourceCollection), targetLocalFile, transferStatusCallbackListener, transferControlBlock);
            }
            catch (JargonException e) {
                if (transferControlBlock.isCancelled()) continue;
                throw e;
            }
            catch (Exception e) {
                if (transferControlBlock.isCancelled()) continue;
                log.info("unanticipated exception will be transformed into a Jargon exception", (Throwable)e);
                throw new JargonException(e);
            }
        }
    }

    void processGetOfSingleFile(IRODSFile irodsSourceFile, File targetLocalFile, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock) throws OverwriteException, FileNotFoundException, JargonException {
        block15: {
            log.info("processGetOfSingleFile()");
            if (irodsSourceFile == null) {
                throw new IllegalArgumentException("null irodsSourceFile");
            }
            if (targetLocalFile == null) {
                throw new IllegalArgumentException("null targetLocalFile");
            }
            File targetLocalFileAsFile = null;
            if (targetLocalFile.isDirectory()) {
                StringBuilder sb = new StringBuilder();
                sb.append(targetLocalFile.getAbsolutePath());
                sb.append("/");
                sb.append(irodsSourceFile.getName());
                targetLocalFileAsFile = new File(sb.toString());
            } else {
                targetLocalFileAsFile = targetLocalFile;
            }
            log.info("get of single file...filtered?");
            int totalFiles = 0;
            totalFiles = transferControlBlock.getTotalFilesToTransfer();
            if (!transferControlBlock.filter(irodsSourceFile.getAbsolutePath())) {
                log.info("file is filtered and discarded: {}", (Object)irodsSourceFile.getAbsolutePath());
                transferControlBlock.incrementFilesSkippedSoFar();
                if (transferStatusCallbackListener != null) {
                    TransferStatus status = TransferStatus.instance(TransferStatus.TransferType.GET, irodsSourceFile.getAbsolutePath(), targetLocalFileAsFile.getAbsolutePath(), "", 0L, 0L, transferControlBlock.getTotalFilesTransferredSoFar(), transferControlBlock.getTotalFilesSkippedSoFar(), totalFiles, TransferStatus.TransferState.RESTARTING, this.dataObjectAO.getIRODSAccount().getHost(), this.dataObjectAO.getIRODSAccount().getZone());
                    transferStatusCallbackListener.statusCallback(status);
                }
                return;
            }
            log.info("filter passed, process...");
            try {
                TransferStatus status;
                long sourceFileLength;
                if (transferStatusCallbackListener != null) {
                    sourceFileLength = irodsSourceFile.length();
                    status = TransferStatus.instance(TransferStatus.TransferType.GET, irodsSourceFile.getAbsolutePath(), targetLocalFileAsFile.getAbsolutePath(), "", sourceFileLength, 0L, transferControlBlock.getTotalFilesTransferredSoFar(), transferControlBlock.getTotalFilesSkippedSoFar(), totalFiles, TransferStatus.TransferState.IN_PROGRESS_START_FILE, this.dataObjectAO.getIRODSAccount().getHost(), this.dataObjectAO.getIRODSAccount().getZone());
                    TransferStatusCallbackListener.FileStatusCallbackResponse response = transferStatusCallbackListener.statusCallback(status);
                    if (response == TransferStatusCallbackListener.FileStatusCallbackResponse.SKIP) {
                        log.info("file signalled as skipped in callback response:{}", (Object)irodsSourceFile.getAbsolutePath());
                        transferControlBlock.incrementFilesSkippedSoFar();
                        status = TransferStatus.instance(TransferStatus.TransferType.GET, irodsSourceFile.getAbsolutePath(), targetLocalFileAsFile.getAbsolutePath(), "", 0L, 0L, transferControlBlock.getTotalFilesTransferredSoFar(), transferControlBlock.getTotalFilesSkippedSoFar(), totalFiles, TransferStatus.TransferState.SKIPPING, this.dataObjectAO.getIRODSAccount().getHost(), this.dataObjectAO.getIRODSAccount().getZone());
                        transferStatusCallbackListener.statusCallback(status);
                        return;
                    }
                }
                try {
                    this.dataObjectAO.getDataObjectFromIrods(irodsSourceFile, targetLocalFileAsFile, transferControlBlock, transferStatusCallbackListener);
                }
                catch (JargonException e) {
                    log.error("exception in transfer, will abandon the connection and rethrow", (Throwable)e);
                    throw e;
                }
                catch (Exception e) {
                    log.error("exception in transfer, will abandon the connection and rethrow", (Throwable)e);
                    this.dataObjectAO.getIRODSAccessObjectFactory().getIrodsSession().discardSessionForErrors(this.dataObjectAO.getIRODSAccount());
                    throw new JargonException(e);
                }
                transferControlBlock.incrementFilesTransferredSoFar();
                if (transferStatusCallbackListener != null) {
                    sourceFileLength = irodsSourceFile.length();
                    status = TransferStatus.instance(TransferStatus.TransferType.GET, irodsSourceFile.getAbsolutePath(), targetLocalFileAsFile.getAbsolutePath(), "", sourceFileLength, sourceFileLength, transferControlBlock.getTotalFilesTransferredSoFar(), transferControlBlock.getTotalFilesSkippedSoFar(), totalFiles, TransferStatus.TransferState.IN_PROGRESS_COMPLETE_FILE, this.dataObjectAO.getIRODSAccount().getHost(), this.dataObjectAO.getIRODSAccount().getZone());
                    transferStatusCallbackListener.statusCallback(status);
                }
            }
            catch (JargonException je) {
                if (transferControlBlock.isCancelled()) break block15;
                log.error("exception in transfer", (Throwable)je);
                transferControlBlock.reportErrorInTransfer();
                if (transferStatusCallbackListener != null) {
                    log.warn("exception will be passed back to existing callback listener");
                    TransferStatus status = TransferStatus.instanceForException(TransferStatus.TransferType.GET, irodsSourceFile.getAbsolutePath(), targetLocalFileAsFile.getAbsolutePath(), "", targetLocalFileAsFile.length(), transferControlBlock.getTotalBytesTransferredSoFar(), transferControlBlock.getTotalFilesTransferredSoFar(), transferControlBlock.getTotalFilesSkippedSoFar(), totalFiles, je, this.dataObjectAO.getIRODSAccount().getHost(), this.dataObjectAO.getIRODSAccount().getZone());
                    transferStatusCallbackListener.statusCallback(status);
                }
                log.warn("exception will be re-thrown, as there is no status callback listener");
                throw je;
            }
        }
    }

    void recursivelyPut(File sourceFile, IRODSFile targetIrodsCollection, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock) throws OverwriteException, DataNotFoundException, JargonException {
        block10: {
            if (sourceFile == null) {
                throw new IllegalArgumentException("null source file");
            }
            if (targetIrodsCollection == null) {
                throw new IllegalArgumentException("null targetIrodsCollection");
            }
            if (!sourceFile.isDirectory()) {
                throw new JargonException("source file is not a directory, cannot recursively put");
            }
            log.info("recursively putting source file: {}", (Object)sourceFile.getAbsolutePath());
            log.info("    into iRODS file: {}", (Object)targetIrodsCollection.getAbsolutePath());
            log.info("     to resource:{}", (Object)targetIrodsCollection.getResource());
            try {
                File[] files = sourceFile.listFiles();
                if (files == null) break block10;
                for (File fileInSourceCollection : files) {
                    if (Thread.interrupted()) {
                        log.info("cancellation detected, set cancelled in tcb");
                        transferControlBlock.setCancelled(true);
                    }
                    if (transferControlBlock.isCancelled() || transferControlBlock.isPaused()) {
                        log.info("will notify pause or cancel for this put");
                        this.notifyPauseOrCancelCallbackForPut(targetIrodsCollection, transferStatusCallbackListener, transferControlBlock, fileInSourceCollection);
                        break;
                    }
                    if (this.collectionAO.getIRODSProtocol().getPipelineConfiguration().getSocketRenewalIntervalInSeconds() > 0) {
                        this.collectionAO.getIRODSSession().currentConnectionCheckRenewalOfSocket(this.collectionAO.getIRODSAccount());
                    }
                    if (fileInSourceCollection.isDirectory()) {
                        this.recursivelyPutACollection(targetIrodsCollection, transferStatusCallbackListener, transferControlBlock, fileInSourceCollection);
                        continue;
                    }
                    this.processPutOfSingleFile(fileInSourceCollection, targetIrodsCollection, transferStatusCallbackListener, transferControlBlock);
                }
            }
            catch (Exception e) {
                if (transferControlBlock.isCancelled()) break block10;
                log.info("unanticipated exception will be transformed into a Jargon exception", (Throwable)e);
                throw new JargonException(e);
            }
        }
    }

    private void notifyPauseOrCancelCallbackForPut(IRODSFile targetIrodsCollection, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock, File fileInSourceCollection) throws JargonException {
        log.info("transfer cancelled or paused, signal with a callback");
        if (transferStatusCallbackListener != null) {
            TransferStatus.TransferState interruptStatus = transferControlBlock.shouldTransferBeAbandonedDueToNumberOfErrors() ? TransferStatus.TransferState.FAILURE : (transferControlBlock.isCancelled() ? TransferStatus.TransferState.CANCELLED : TransferStatus.TransferState.PAUSED);
            TransferStatus status = TransferStatus.instance(TransferStatus.TransferType.PUT, fileInSourceCollection.getAbsolutePath(), targetIrodsCollection.getAbsolutePath(), "", fileInSourceCollection.length(), fileInSourceCollection.length(), transferControlBlock.getTotalFilesTransferredSoFar(), transferControlBlock.getTotalFilesSkippedSoFar(), transferControlBlock.getTotalFilesToTransfer(), interruptStatus, this.dataObjectAO.getIRODSAccount().getHost(), this.dataObjectAO.getIRODSAccount().getZone());
            log.info("status callback for cancel:{}", (Object)status);
            transferStatusCallbackListener.statusCallback(status);
        }
    }

    private void processRecursivePutException(File fileInSourceCollection, TransferStatusCallbackListener transferStatusCallbackListener, IRODSFile newIrodsFile, TransferControlBlock transferControlBlock, JargonException je) throws JargonException {
        int filesSkippedSoFar;
        int filesTransferredSoFar;
        int totalFiles;
        log.error("exception in transfer", (Throwable)je);
        if (transferStatusCallbackListener != null) {
            log.warn("exception will be passed back to existing callback listener");
            totalFiles = 0;
            if (transferControlBlock != null) {
                transferControlBlock.reportErrorInTransfer();
                totalFiles = transferControlBlock.getTotalFilesToTransfer();
            }
            filesTransferredSoFar = 0;
            filesSkippedSoFar = 0;
            if (transferControlBlock != null) {
                filesTransferredSoFar = transferControlBlock.getTotalFilesTransferredSoFar();
                filesSkippedSoFar = transferControlBlock.getTotalFilesSkippedSoFar();
            }
        } else {
            log.warn("exception will be re-thrown, as there is no status callback listener");
            throw je;
        }
        TransferStatus status = TransferStatus.instanceForException(TransferStatus.TransferType.PUT, fileInSourceCollection.getAbsolutePath(), newIrodsFile.getAbsolutePath(), "", fileInSourceCollection.length(), fileInSourceCollection.length(), filesTransferredSoFar, filesSkippedSoFar, totalFiles, je, this.dataObjectAO.getIRODSAccount().getHost(), this.dataObjectAO.getIRODSAccount().getZone());
        log.info("status callback to be sent for error:{}", (Object)status);
        transferStatusCallbackListener.statusCallback(status);
    }

    private void recursivelyPutACollection(IRODSFile targetIrodsCollection, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock, File fileInSourceCollection) throws OverwriteException, DataNotFoundException, JargonException {
        block4: {
            StringBuilder sb = new StringBuilder();
            sb.append(targetIrodsCollection.getAbsolutePath());
            sb.append('/');
            sb.append(fileInSourceCollection.getName());
            log.info("recursively creating parent directory in irods at: {}", (Object)sb.toString());
            IRODSFile newSubCollection = this.collectionAO.instanceIRODSFileForCollectionPath(sb.toString());
            newSubCollection.setResource(targetIrodsCollection.getResource());
            try {
                newSubCollection.mkdirs();
                this.recursivelyPut(fileInSourceCollection, newSubCollection, transferStatusCallbackListener, transferControlBlock);
            }
            catch (JargonException je) {
                if (!transferControlBlock.isCancelled()) {
                    this.processRecursivePutException(fileInSourceCollection, transferStatusCallbackListener, newSubCollection, transferControlBlock, je);
                }
            }
            catch (Exception e) {
                if (transferControlBlock.isCancelled()) break block4;
                log.error("unanticipated exception will be transformed into a JargonException and processed", (Throwable)e);
                JargonException je = new JargonException(e);
                this.processRecursivePutException(fileInSourceCollection, transferStatusCallbackListener, newSubCollection, transferControlBlock, je);
            }
        }
    }

    void recursivelyReplicate(IRODSFile sourceFile, String targetResource, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock) throws JargonException {
        if (!sourceFile.isDirectory()) {
            throw new JargonException("source file is not a directory, cannot recursively replicate");
        }
        log.info("recursively replicating source file: {}", (Object)sourceFile.getAbsolutePath());
        log.info("    into resource: {}", (Object)targetResource);
        for (File fileInSourceCollection : sourceFile.listFiles()) {
            if (Thread.interrupted()) {
                log.info("cancellation detected, set cancelled in tcb");
                transferControlBlock.setCancelled(true);
            }
            if (transferControlBlock.isCancelled() || transferControlBlock.isPaused()) {
                log.info("transfer cancelled or paused");
                if (transferStatusCallbackListener != null) {
                    TransferStatus.TransferState interruptStatus = transferControlBlock.shouldTransferBeAbandonedDueToNumberOfErrors() ? TransferStatus.TransferState.FAILURE : (transferControlBlock.isCancelled() ? TransferStatus.TransferState.CANCELLED : TransferStatus.TransferState.PAUSED);
                    TransferStatus status = TransferStatus.instance(TransferStatus.TransferType.REPLICATE, fileInSourceCollection.getAbsolutePath(), "", targetResource, fileInSourceCollection.length(), fileInSourceCollection.length(), transferControlBlock.getTotalFilesTransferredSoFar(), transferControlBlock.getTotalFilesSkippedSoFar(), transferControlBlock.getTotalFilesToTransfer(), interruptStatus, this.dataObjectAO.getIRODSAccount().getHost(), this.dataObjectAO.getIRODSAccount().getZone());
                    transferStatusCallbackListener.statusCallback(status);
                    return;
                }
            }
            if (fileInSourceCollection.isDirectory()) {
                this.replicateWhenADirectory(targetResource, transferStatusCallbackListener, transferControlBlock, fileInSourceCollection);
                if (!transferControlBlock.isCancelled() && !transferControlBlock.isPaused()) continue;
                log.info("returning, is paused or cancelled");
                break;
            }
            this.processReplicationOfSingleFile(fileInSourceCollection.getAbsolutePath(), targetResource, transferStatusCallbackListener, transferControlBlock);
        }
    }

    private void replicateWhenADirectory(String targetResource, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock, File fileInSourceCollection) throws JargonException {
        block2: {
            try {
                this.recursivelyReplicate((IRODSFile)((Object)fileInSourceCollection), targetResource, transferStatusCallbackListener, transferControlBlock);
            }
            catch (Exception je) {
                if (transferControlBlock.isCancelled()) break block2;
                this.notifyReplicationTransferException(targetResource, transferStatusCallbackListener, transferControlBlock, fileInSourceCollection, je);
            }
        }
    }

    private void notifyReplicationTransferException(String targetResource, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock, File fileInSourceCollection, Exception je) throws JargonException {
        int totalFiles = 0;
        int totalFilesSoFar = 0;
        int totalFilesSkipped = 0;
        transferControlBlock.reportErrorInTransfer();
        totalFiles = transferControlBlock.getTotalFilesToTransfer();
        totalFilesSoFar = transferControlBlock.getTotalFilesTransferredSoFar();
        totalFilesSkipped = transferControlBlock.getTotalFilesSkippedSoFar();
        TransferStatus status = TransferStatus.instanceForException(TransferStatus.TransferType.REPLICATE, fileInSourceCollection.getAbsolutePath(), "", targetResource, fileInSourceCollection.length(), fileInSourceCollection.length(), totalFilesSoFar, totalFilesSkipped, totalFiles, je, this.dataObjectAO.getIRODSAccount().getHost(), this.dataObjectAO.getIRODSAccount().getZone());
        transferStatusCallbackListener.statusCallback(status);
    }

    void processPutOfSingleFile(File sourceFile, IRODSFile targetIrodsFile, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock) throws OverwriteException, DataNotFoundException, JargonException {
        block11: {
            log.info("put of single file");
            if (sourceFile == null) {
                throw new IllegalArgumentException("null sourceFile");
            }
            if (targetIrodsFile == null) {
                throw new IllegalArgumentException("null targetIrodsFile");
            }
            if (transferControlBlock == null) {
                throw new IllegalArgumentException("null transferControlBlock");
            }
            IRODSFile targetFileAsFile = null;
            if (targetIrodsFile.isDirectory()) {
                StringBuilder sb = new StringBuilder();
                sb.append(targetIrodsFile.getAbsolutePath());
                sb.append("/");
                sb.append(sourceFile.getName());
                targetFileAsFile = this.collectionAO.getIRODSFileFactory().instanceIRODSFile(sb.toString());
                targetFileAsFile.setResource(targetIrodsFile.getResource());
            } else {
                targetFileAsFile = targetIrodsFile;
            }
            try {
                TransferStatusCallbackListener.FileStatusCallbackResponse response;
                TransferStatus status;
                if (!transferControlBlock.filter(sourceFile.getAbsolutePath())) {
                    log.debug("file filtered and not transferred");
                    transferControlBlock.incrementFilesSkippedSoFar();
                    status = TransferStatus.instance(TransferStatus.TransferType.PUT, sourceFile.getAbsolutePath(), targetFileAsFile.getAbsolutePath(), "", 0L, 0L, transferControlBlock.getTotalFilesTransferredSoFar(), transferControlBlock.getTotalFilesSkippedSoFar(), transferControlBlock.getTotalFilesToTransfer(), TransferStatus.TransferState.RESTARTING, this.dataObjectAO.getIRODSAccount().getHost(), this.dataObjectAO.getIRODSAccount().getZone());
                    transferStatusCallbackListener.statusCallback(status);
                    return;
                }
                if (transferStatusCallbackListener != null && (response = transferStatusCallbackListener.statusCallback(status = TransferStatus.instance(TransferStatus.TransferType.PUT, sourceFile.getAbsolutePath(), targetFileAsFile.getAbsolutePath(), targetFileAsFile.getResource(), sourceFile.length(), 0L, transferControlBlock.getTotalFilesTransferredSoFar(), transferControlBlock.getTotalFilesSkippedSoFar(), transferControlBlock.getTotalFilesToTransfer(), TransferStatus.TransferState.IN_PROGRESS_START_FILE, this.dataObjectAO.getIRODSAccount().getHost(), this.dataObjectAO.getIRODSAccount().getZone()))) == TransferStatusCallbackListener.FileStatusCallbackResponse.SKIP) {
                    log.info("file signalled as skipped in callback response:{}", (Object)sourceFile.getAbsolutePath());
                    transferControlBlock.incrementFilesSkippedSoFar();
                    status = TransferStatus.instance(TransferStatus.TransferType.PUT, sourceFile.getAbsolutePath(), targetFileAsFile.getAbsolutePath(), "", 0L, 0L, transferControlBlock.getTotalFilesTransferredSoFar(), transferControlBlock.getTotalFilesSkippedSoFar(), transferControlBlock.getTotalFilesToTransfer(), TransferStatus.TransferState.SKIPPING, this.dataObjectAO.getIRODSAccount().getHost(), this.dataObjectAO.getIRODSAccount().getZone());
                    transferStatusCallbackListener.statusCallback(status);
                    return;
                }
                this.dataObjectAO.putLocalDataObjectToIRODS(sourceFile, targetFileAsFile, transferControlBlock, transferStatusCallbackListener, false);
                transferControlBlock.incrementFilesTransferredSoFar();
                if (transferStatusCallbackListener != null) {
                    status = TransferStatus.instance(TransferStatus.TransferType.PUT, sourceFile.getAbsolutePath(), targetFileAsFile.getAbsolutePath(), targetFileAsFile.getResource(), sourceFile.length(), sourceFile.length(), transferControlBlock.getTotalFilesTransferredSoFar(), transferControlBlock.getTotalFilesSkippedSoFar(), transferControlBlock.getTotalFilesToTransfer(), TransferStatus.TransferState.IN_PROGRESS_COMPLETE_FILE, this.dataObjectAO.getIRODSAccount().getHost(), this.dataObjectAO.getIRODSAccount().getZone());
                    transferStatusCallbackListener.statusCallback(status);
                }
            }
            catch (JargonException je) {
                if (transferControlBlock.isCancelled()) break block11;
                log.error("exception in transfer", (Throwable)je);
                transferControlBlock.reportErrorInTransfer();
                if (transferStatusCallbackListener != null) {
                    log.warn("exception will be passed back to existing callback listener");
                    TransferStatus status = TransferStatus.instanceForException(TransferStatus.TransferType.PUT, sourceFile.getAbsolutePath(), targetFileAsFile.getAbsolutePath(), targetFileAsFile.getResource(), sourceFile.length(), targetFileAsFile.length(), transferControlBlock.getTotalFilesTransferredSoFar(), transferControlBlock.getTotalFilesSkippedSoFar(), transferControlBlock.getTotalFilesToTransfer(), je, this.dataObjectAO.getIRODSAccount().getHost(), this.dataObjectAO.getIRODSAccount().getZone());
                    transferStatusCallbackListener.statusCallback(status);
                }
                log.warn("exception will be re-thrown, as there is no status callback listener");
                throw je;
            }
        }
    }

    void processReplicationOfSingleFile(String irodsFileAbsolutePath, String targetResource, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock) throws JargonException {
        block6: {
            log.info("replicate single file");
            if (!transferControlBlock.filter(irodsFileAbsolutePath)) {
                log.info("file is filtered and discarded: {}", (Object)irodsFileAbsolutePath);
                transferControlBlock.incrementFilesSkippedSoFar();
                TransferStatus status = TransferStatus.instance(TransferStatus.TransferType.REPLICATE, irodsFileAbsolutePath, "", targetResource, 0L, 0L, transferControlBlock.getTotalFilesTransferredSoFar(), transferControlBlock.getTotalFilesSkippedSoFar(), transferControlBlock.getTotalFilesToTransfer(), TransferStatus.TransferState.RESTARTING, this.dataObjectAO.getIRODSAccount().getHost(), this.dataObjectAO.getIRODSAccount().getZone());
                transferStatusCallbackListener.statusCallback(status);
                return;
            }
            log.info("filter passed, process...");
            try {
                this.dataObjectAO.replicateIrodsDataObject(irodsFileAbsolutePath, targetResource);
                log.info("replicate successful for file: {}", (Object)irodsFileAbsolutePath);
                transferControlBlock.incrementFilesTransferredSoFar();
                if (transferStatusCallbackListener != null) {
                    TransferStatus transferStatus = TransferStatus.instance(TransferStatus.TransferType.REPLICATE, irodsFileAbsolutePath, "", targetResource, 0L, 0L, transferControlBlock.getTotalFilesTransferredSoFar(), transferControlBlock.getTotalFilesSkippedSoFar(), transferControlBlock.getTotalFilesToTransfer(), TransferStatus.TransferState.SUCCESS, this.dataObjectAO.getIRODSAccount().getHost(), this.dataObjectAO.getIRODSAccount().getZone());
                    transferStatusCallbackListener.statusCallback(transferStatus);
                }
            }
            catch (JargonException e) {
                if (!transferControlBlock.isCancelled()) {
                    this.handleExceptionInReplicate(irodsFileAbsolutePath, targetResource, transferStatusCallbackListener, transferControlBlock, transferControlBlock.getTotalFilesToTransfer(), transferControlBlock.getTotalFilesTransferredSoFar(), transferControlBlock.getTotalFilesSkippedSoFar(), e);
                }
            }
            catch (Exception e) {
                if (transferControlBlock.isCancelled()) break block6;
                log.error("unanticipated exception in replicate, will wrap as a JargonException so that callback handlers may have a crack at it...", (Throwable)e);
                this.handleExceptionInReplicate(irodsFileAbsolutePath, targetResource, transferStatusCallbackListener, transferControlBlock, transferControlBlock.getTotalFilesTransferredSoFar(), transferControlBlock.getTotalFilesSkippedSoFar(), transferControlBlock.getTotalFilesToTransfer(), new JargonException(e));
            }
        }
    }

    private void handleExceptionInReplicate(String irodsFileAbsolutePath, String targetResource, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock, int totalFiles, int totalFilesSoFar, int totalFilesSkippedSoFar, JargonException e) throws JargonException {
        log.error("exception in transfer", (Throwable)e);
        if (transferStatusCallbackListener == null) {
            log.warn("exception will be re-thrown, as there is no status callback listener");
            throw e;
        }
        log.warn("exception will be passed back to existing callback listener");
        TransferStatus status = TransferStatus.instanceForException(TransferStatus.TransferType.REPLICATE, irodsFileAbsolutePath, "", targetResource, 0L, 0L, totalFilesSoFar, totalFilesSkippedSoFar, totalFiles, e, this.dataObjectAO.getIRODSAccount().getHost(), this.dataObjectAO.getIRODSAccount().getZone());
        transferStatusCallbackListener.statusCallback(status);
    }

    void recursivelyCopy(IRODSFile irodsSourceFile, String targetResource, String targetIrodsFileAbsolutePath, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock) throws OverwriteException, DataNotFoundException, JargonException {
        if (!irodsSourceFile.isDirectory()) {
            throw new JargonException("source file is not a directory, cannot recursively copy");
        }
        log.info("recursively copying source file: {}", (Object)irodsSourceFile.getAbsolutePath());
        log.info("to target file: {}", (Object)targetIrodsFileAbsolutePath);
        log.info("resource: {}", (Object)targetResource);
        IRODSFile childTargetFile = null;
        for (File fileInSourceCollection : irodsSourceFile.listFiles()) {
            if (Thread.interrupted()) {
                log.info("cancellation detected, set cancelled in tcb");
                transferControlBlock.setCancelled(true);
            }
            if (transferControlBlock.isCancelled() || transferControlBlock.isPaused()) {
                log.info("transfer cancelled or paused");
                if (transferStatusCallbackListener != null) {
                    TransferStatus.TransferState interruptStatus = transferControlBlock.shouldTransferBeAbandonedDueToNumberOfErrors() ? TransferStatus.TransferState.FAILURE : (transferControlBlock.isCancelled() ? TransferStatus.TransferState.CANCELLED : TransferStatus.TransferState.PAUSED);
                    TransferStatus status = TransferStatus.instance(TransferStatus.TransferType.COPY, fileInSourceCollection.getAbsolutePath(), targetIrodsFileAbsolutePath, targetResource, 0L, 0L, transferControlBlock.getTotalFilesTransferredSoFar(), transferControlBlock.getTotalFilesSkippedSoFar(), transferControlBlock.getTotalFilesToTransfer(), interruptStatus, this.dataObjectAO.getIRODSAccount().getHost(), this.dataObjectAO.getIRODSAccount().getZone());
                    transferStatusCallbackListener.statusCallback(status);
                    return;
                }
            }
            if (fileInSourceCollection.isDirectory()) {
                log.debug("source is a collection, create the target");
                StringBuilder targetCollectionName = new StringBuilder(targetIrodsFileAbsolutePath);
                targetCollectionName.append("/");
                targetCollectionName.append(fileInSourceCollection.getName());
                String targetCollection = targetCollectionName.toString();
                childTargetFile = this.collectionAO.instanceIRODSFileForCollectionPath(targetCollection);
                childTargetFile.mkdirs();
                this.recursivelyCopy((IRODSFile)((Object)fileInSourceCollection), targetResource, targetCollection, transferStatusCallbackListener, transferControlBlock);
                continue;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(targetIrodsFileAbsolutePath);
            sb.append("/");
            sb.append(fileInSourceCollection.getName());
            this.processCopyOfSingleFile(fileInSourceCollection.getAbsolutePath(), targetResource, sb.toString(), transferStatusCallbackListener, transferControlBlock);
        }
    }

    void processCopyOfSingleFile(String irodsSourceFileAbsolutePath, String targetResource, String irodsTargetFileAbsolutePath, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock) throws OverwriteException, DataNotFoundException, JargonException {
        block5: {
            log.info("processCopyOfSingleFile()");
            log.info("irodsSourceFileAbsolutePath:{}", (Object)irodsSourceFileAbsolutePath);
            log.info("targetResource:{}", (Object)targetResource);
            log.info("irodsTargetFileAbsolutePath:{}", (Object)irodsTargetFileAbsolutePath);
            try {
                if (!transferControlBlock.filter(irodsSourceFileAbsolutePath)) {
                    log.info("file is filtered and discarded: {}", (Object)irodsTargetFileAbsolutePath);
                    transferControlBlock.incrementFilesSkippedSoFar();
                    TransferStatus status = TransferStatus.instance(TransferStatus.TransferType.COPY, irodsSourceFileAbsolutePath, irodsTargetFileAbsolutePath, targetResource, 0L, 0L, transferControlBlock.getTotalFilesTransferredSoFar(), transferControlBlock.getTotalFilesSkippedSoFar(), transferControlBlock.getTotalFilesToTransfer(), TransferStatus.TransferState.RESTARTING, this.dataObjectAO.getIRODSAccount().getHost(), this.dataObjectAO.getIRODSAccount().getZone());
                    transferStatusCallbackListener.statusCallback(status);
                    return;
                }
                log.info("filter passed, process...");
                IRODSFile irodsSourceFile = this.dataObjectAO.getIRODSFileFactory().instanceIRODSFile(irodsSourceFileAbsolutePath);
                IRODSFile irodsTargetFile = this.dataObjectAO.getIRODSFileFactory().instanceIRODSFile(irodsTargetFileAbsolutePath);
                irodsTargetFile.setResource(targetResource);
                this.dataObjectAO.copyIRODSDataObject(irodsSourceFile, irodsTargetFile, transferControlBlock, transferStatusCallbackListener);
                log.info("copy successful for file: {}", (Object)irodsSourceFileAbsolutePath);
                transferControlBlock.incrementFilesTransferredSoFar();
                if (transferStatusCallbackListener != null) {
                    TransferStatus transferStatus = TransferStatus.instance(TransferStatus.TransferType.COPY, irodsSourceFileAbsolutePath, irodsTargetFileAbsolutePath, targetResource, 0L, 0L, transferControlBlock.getTotalFilesTransferredSoFar(), transferControlBlock.getTotalFilesSkippedSoFar(), transferControlBlock.getTotalFilesToTransfer(), TransferStatus.TransferState.SUCCESS, this.dataObjectAO.getIRODSAccount().getHost(), this.dataObjectAO.getIRODSAccount().getZone());
                    transferStatusCallbackListener.statusCallback(transferStatus);
                }
            }
            catch (JargonException e) {
                if (transferControlBlock.isCancelled()) break block5;
                log.error("exception in transfer", (Throwable)e);
                transferControlBlock.reportErrorInTransfer();
                if (transferStatusCallbackListener != null) {
                    log.warn("exception will be passed back to existing callback listener");
                    TransferStatus status = TransferStatus.instanceForException(TransferStatus.TransferType.COPY, irodsSourceFileAbsolutePath, irodsTargetFileAbsolutePath, targetResource, 0L, 0L, transferControlBlock.getTotalFilesTransferredSoFar(), transferControlBlock.getTotalFilesSkippedSoFar(), transferControlBlock.getTotalFilesToTransfer(), e, this.dataObjectAO.getIRODSAccount().getHost(), this.dataObjectAO.getIRODSAccount().getZone());
                    transferStatusCallbackListener.statusCallback(status);
                }
                log.warn("exception will be re-thrown, as there is no status callback listener");
                throw e;
            }
        }
    }
}

