/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import java.util.ArrayList;
import java.util.List;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.exception.DataNotFoundException;
import org.irods.jargon.core.exception.DuplicateDataException;
import org.irods.jargon.core.exception.InvalidUserException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.exception.NoMoreRulesException;
import org.irods.jargon.core.packinstr.GeneralAdminInp;
import org.irods.jargon.core.packinstr.GetTempPasswordForOther;
import org.irods.jargon.core.packinstr.GetTempPasswordIn;
import org.irods.jargon.core.packinstr.ModAvuMetadataInp;
import org.irods.jargon.core.packinstr.Tag;
import org.irods.jargon.core.packinstr.UserAdminInp;
import org.irods.jargon.core.protovalues.UserTypeEnum;
import org.irods.jargon.core.pub.IRODSGenQueryExecutor;
import org.irods.jargon.core.pub.IRODSGenQueryExecutorImpl;
import org.irods.jargon.core.pub.IRODSGenericAO;
import org.irods.jargon.core.pub.UserAO;
import org.irods.jargon.core.pub.aohelper.UserAOHelper;
import org.irods.jargon.core.pub.domain.AvuData;
import org.irods.jargon.core.pub.domain.User;
import org.irods.jargon.core.query.GenQueryBuilderException;
import org.irods.jargon.core.query.GenQueryOrderByField;
import org.irods.jargon.core.query.IRODSGenQuery;
import org.irods.jargon.core.query.IRODSGenQueryBuilder;
import org.irods.jargon.core.query.IRODSGenQueryFromBuilder;
import org.irods.jargon.core.query.IRODSQueryResultRow;
import org.irods.jargon.core.query.IRODSQueryResultSet;
import org.irods.jargon.core.query.JargonQueryException;
import org.irods.jargon.core.query.QueryConditionOperators;
import org.irods.jargon.core.query.RodsGenQueryEnum;
import org.irods.jargon.core.security.IRODSPasswordUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UserAOImpl
extends IRODSGenericAO
implements UserAO {
    private static final String ERROR_IN_USER_QUERY = "error in user query";
    private static final int DEFAULT_REC_COUNT = 500;
    Logger log = LoggerFactory.getLogger(this.getClass());
    private static final char COMMA = ',';
    private static final String AND = " AND ";
    private static final String EQUALS = " = ";
    private static final String STRING_TO_HASH_WITH = "stringToHashWith";
    private IRODSGenQueryExecutor irodsGenQueryExecutor = null;

    protected UserAOImpl(IRODSSession irodsSession, IRODSAccount irodsAccount) throws JargonException {
        super(irodsSession, irodsAccount);
    }

    @Override
    public List<AvuData> listUserMetadataForUserId(String userId) throws JargonException {
        IRODSQueryResultSet resultSet;
        if (userId == null || userId.isEmpty()) {
            throw new IllegalArgumentException("null or empty userId");
        }
        this.log.info("list user metadata for {}", (Object)userId);
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        sb.append(RodsGenQueryEnum.COL_META_USER_ATTR_NAME.getName());
        sb.append(',');
        sb.append(RodsGenQueryEnum.COL_META_USER_ATTR_VALUE.getName());
        sb.append(',');
        sb.append(RodsGenQueryEnum.COL_META_USER_ATTR_UNITS.getName());
        sb.append(" WHERE ");
        sb.append(RodsGenQueryEnum.COL_USER_ID.getName());
        sb.append(" = '");
        sb.append(userId);
        sb.append("'");
        this.log.debug("user avu list query: {}", (Object)sb.toString());
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(sb.toString(), 500);
        try {
            resultSet = this.getGenQueryExecutor().executeIRODSQueryAndCloseResult(irodsQuery, 0);
        }
        catch (JargonQueryException e) {
            this.log.error("query exception for user query: " + sb.toString(), (Throwable)e);
            throw new JargonException(ERROR_IN_USER_QUERY);
        }
        ArrayList<AvuData> avuDatas = new ArrayList<AvuData>();
        AvuData avuData = null;
        if (resultSet.getNumberOfResultColumns() != 3) {
            String msg = "number of results for avu query should be 3, was:" + resultSet.getNumberOfResultColumns();
            this.log.error(msg);
            throw new JargonException(msg);
        }
        for (IRODSQueryResultRow row : resultSet.getResults()) {
            avuData = AvuData.instance(row.getColumn(0), row.getColumn(1), row.getColumn(2));
            avuDatas.add(avuData);
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug("found avu for user:" + avuData);
        }
        return avuDatas;
    }

    @Override
    public List<AvuData> listUserMetadataForUserName(String userName) throws JargonException {
        IRODSQueryResultSet resultSet;
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        this.log.info("list user metadata for user name: {}", (Object)userName);
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        sb.append(RodsGenQueryEnum.COL_META_USER_ATTR_NAME.getName());
        sb.append(',');
        sb.append(RodsGenQueryEnum.COL_META_USER_ATTR_VALUE.getName());
        sb.append(',');
        sb.append(RodsGenQueryEnum.COL_META_USER_ATTR_UNITS.getName());
        sb.append(" WHERE ");
        sb.append(RodsGenQueryEnum.COL_USER_NAME.getName());
        sb.append(" = '");
        sb.append(userName);
        sb.append("'");
        this.log.debug("user avu list query: {}", (Object)sb.toString());
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(sb.toString(), 500);
        try {
            resultSet = this.getGenQueryExecutor().executeIRODSQueryAndCloseResult(irodsQuery, 0);
        }
        catch (JargonQueryException e) {
            this.log.error("query exception for user query:{} ", (Object)sb.toString(), (Object)e);
            throw new JargonException(ERROR_IN_USER_QUERY);
        }
        ArrayList<AvuData> avuDatas = new ArrayList<AvuData>();
        AvuData avuData = null;
        for (IRODSQueryResultRow row : resultSet.getResults()) {
            avuData = AvuData.instance(row.getColumn(0), row.getColumn(1), row.getColumn(2));
            avuDatas.add(avuData);
            this.log.debug("found avu for user:{}", (Object)avuData);
        }
        return avuDatas;
    }

    @Override
    public User addUser(User user) throws JargonException, DuplicateDataException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("adding a user:{}", (Object)user);
        }
        if (user == null) {
            throw new IllegalArgumentException("cannot add null user");
        }
        this.updatePreChecks(user);
        GeneralAdminInp adminPI = GeneralAdminInp.instanceForAddUser(user);
        this.log.debug("executing admin PI");
        try {
            this.getIRODSProtocol().irodsFunction(adminPI);
        }
        catch (DuplicateDataException dde) {
            throw dde;
        }
        catch (NoMoreRulesException nmr) {
            this.log.warn("no more rules exception caught, will throw as duplicate data for backwards compatibility", (Throwable)nmr);
            throw new DuplicateDataException("no more rules interpereted as duplicate data exception for backwards compatibility");
        }
        this.log.debug("user added, now process other fields");
        if (!user.getComment().isEmpty()) {
            this.log.info("comment has changed");
            this.updateUserComment(user);
        }
        if (!user.getInfo().isEmpty()) {
            this.log.info("info has changed");
            this.updateUserInfo(user);
        }
        if (!user.getUserDN().isEmpty()) {
            this.updateUserDN(user.getName(), user.getUserDN());
        }
        return this.findByName(user.getName());
    }

    @Override
    public List<User> findAll() throws JargonException {
        IRODSGenQueryBuilder builder = new IRODSGenQueryBuilder(true, null);
        IRODSQueryResultSet resultSet = null;
        try {
            UserAOHelper.addUserSelectsToBuilder(builder);
            builder.addOrderByGenQueryField(RodsGenQueryEnum.COL_USER_NAME, GenQueryOrderByField.OrderByType.ASC).addOrderByGenQueryField(RodsGenQueryEnum.COL_USER_ZONE, GenQueryOrderByField.OrderByType.ASC);
            IRODSGenQueryFromBuilder irodsQuery = builder.exportIRODSQueryFromBuilder(this.getJargonProperties().getMaxFilesAndDirsQueryMax());
            resultSet = this.getGenQueryExecutor().executeIRODSQueryAndCloseResult(irodsQuery, 0);
        }
        catch (JargonQueryException e) {
            this.log.error("query exception for query", (Throwable)e);
            throw new JargonException("error in query for user", e);
        }
        catch (GenQueryBuilderException e) {
            this.log.error("query exception for query", (Throwable)e);
            throw new JargonException("error in query for user", e);
        }
        ArrayList<User> users = new ArrayList<User>();
        for (IRODSQueryResultRow row : resultSet.getResults()) {
            User user = UserAOHelper.buildUserFromResultSet(row, this.getGenQueryExecutor(), false);
            user.setTotalRecords(resultSet.getTotalRecords());
            users.add(user);
        }
        return users;
    }

    @Override
    public List<User> findWhere(String whereStatement) throws JargonException {
        IRODSQueryResultSet resultSet;
        if (whereStatement == null) {
            throw new IllegalArgumentException("null where statement");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(UserAOHelper.buildUserSelects());
        if (!whereStatement.isEmpty()) {
            sb.append(" WHERE ");
            sb.append(whereStatement);
        } else {
            this.log.debug("no where statement given, so will do plain select");
        }
        String userQueryString = sb.toString();
        if (this.log.isInfoEnabled()) {
            this.log.info("user query: " + userQueryString);
        }
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(userQueryString, 500);
        try {
            resultSet = this.getGenQueryExecutor().executeIRODSQueryAndCloseResult(irodsQuery, 0);
        }
        catch (JargonQueryException e) {
            this.log.error("query exception for user query: {}", (Object)userQueryString, (Object)e);
            throw new JargonException(ERROR_IN_USER_QUERY);
        }
        ArrayList<User> users = new ArrayList<User>();
        for (IRODSQueryResultRow row : resultSet.getResults()) {
            User user = UserAOHelper.buildUserFromResultSet(row, this.getGenQueryExecutor(), false);
            user.setTotalRecords(resultSet.getTotalRecords());
            users.add(user);
        }
        return users;
    }

    @Override
    public User findById(String userId) throws JargonException, DataNotFoundException {
        return this.findByIdInZone(userId, this.getIRODSAccount().getZone());
    }

    public String findUserDNByUserName(String userName) throws JargonException {
        this.log.info("findUserDNByUserName()");
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        return null;
    }

    @Override
    public User findByIdInZone(String userId, String zone) throws JargonException, DataNotFoundException {
        IRODSQueryResultSet resultSet;
        IRODSGenQueryExecutorImpl irodsGenQueryExecutorImpl = new IRODSGenQueryExecutorImpl(this.getIRODSSession(), this.getIRODSAccount());
        StringBuilder userQuery = new StringBuilder();
        userQuery.append(UserAOHelper.buildUserSelects());
        userQuery.append(" where ");
        userQuery.append(RodsGenQueryEnum.COL_USER_ID.getName());
        userQuery.append(" = '");
        userQuery.append(userId);
        userQuery.append("'");
        String userQueryString = userQuery.toString();
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(userQueryString, 500);
        try {
            resultSet = irodsGenQueryExecutorImpl.executeIRODSQueryAndCloseResultInZone(irodsQuery, 0, zone);
        }
        catch (JargonQueryException e) {
            this.log.error("query exception for user query:{}", (Object)userQueryString, (Object)e);
            throw new JargonException(ERROR_IN_USER_QUERY);
        }
        if (resultSet.getResults().size() == 0) {
            StringBuilder messageBuilder = new StringBuilder();
            messageBuilder.append("user not found for id:");
            messageBuilder.append(userId);
            String message = messageBuilder.toString();
            this.log.warn(message);
            throw new DataNotFoundException(message);
        }
        if (resultSet.getResults().size() > 1) {
            StringBuilder messageBuilder = new StringBuilder();
            messageBuilder.append("more than one user found for id:");
            messageBuilder.append(userId);
            String message = messageBuilder.toString();
            this.log.error(message);
            throw new JargonException(message);
        }
        IRODSQueryResultRow row = resultSet.getFirstResult();
        User user = UserAOHelper.buildUserFromResultSet(row, this.getGenQueryExecutor(), true);
        return user;
    }

    @Override
    public User findByName(String userName) throws JargonException, DataNotFoundException {
        IRODSQueryResultSet resultSet;
        String theUser = UserAOHelper.getUserNameFromUserPoundZone(userName);
        String theZone = UserAOHelper.getZoneFromUserPoundZone(userName);
        if (theZone.isEmpty()) {
            theZone = this.getIRODSAccount().getZone();
        }
        StringBuilder userQuery = new StringBuilder();
        userQuery.append(UserAOHelper.buildUserSelects());
        userQuery.append(" where ");
        userQuery.append(RodsGenQueryEnum.COL_USER_NAME.getName());
        userQuery.append(" = '");
        userQuery.append(theUser);
        userQuery.append("'");
        userQuery.append(AND);
        userQuery.append(RodsGenQueryEnum.COL_USER_ZONE.getName());
        userQuery.append(EQUALS);
        userQuery.append("'");
        userQuery.append(theZone);
        userQuery.append("'");
        String userQueryString = userQuery.toString();
        this.log.info("user query:{}", (Object)userQueryString);
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(userQueryString, 500);
        try {
            resultSet = this.getGenQueryExecutor().executeIRODSQueryAndCloseResult(irodsQuery, 0);
        }
        catch (JargonQueryException e) {
            this.log.error("query exception for user query:{}", (Object)userQueryString, (Object)e);
            throw new JargonException(ERROR_IN_USER_QUERY);
        }
        if (resultSet.getResults().size() == 0) {
            StringBuilder messageBuilder = new StringBuilder();
            messageBuilder.append("user not found for name:");
            messageBuilder.append(userName);
            String message = messageBuilder.toString();
            this.log.warn(message);
            throw new DataNotFoundException(message);
        }
        if (resultSet.getResults().size() > 1) {
            StringBuilder messageBuilder = new StringBuilder();
            messageBuilder.append("more than one user found for name:");
            messageBuilder.append(userName);
            String message = messageBuilder.toString();
            this.log.error(message);
            throw new JargonException(message);
        }
        IRODSQueryResultRow row = resultSet.getResults().get(0);
        User user = UserAOHelper.buildUserFromResultSet(row, this.getGenQueryExecutor(), true);
        return user;
    }

    @Override
    public List<String> findUserNameLike(String userName) throws JargonException {
        if (userName == null) {
            throw new IllegalArgumentException("null userName");
        }
        this.log.info("findUserNameLike {}", (Object)userName);
        IRODSGenQueryBuilder builder = new IRODSGenQueryBuilder(true, null);
        StringBuilder userQuery = new StringBuilder();
        userQuery.append(userName.trim());
        userQuery.append("%");
        IRODSQueryResultSet resultSet = null;
        try {
            UserAOHelper.addUserSelectsToBuilder(builder);
            builder.addOrderByGenQueryField(RodsGenQueryEnum.COL_USER_NAME, GenQueryOrderByField.OrderByType.ASC).addOrderByGenQueryField(RodsGenQueryEnum.COL_USER_ZONE, GenQueryOrderByField.OrderByType.ASC).addConditionAsGenQueryField(RodsGenQueryEnum.COL_USER_NAME, QueryConditionOperators.LIKE, userQuery.toString().trim());
            IRODSGenQueryFromBuilder irodsQuery = builder.exportIRODSQueryFromBuilder(this.getJargonProperties().getMaxFilesAndDirsQueryMax());
            resultSet = this.getGenQueryExecutor().executeIRODSQueryAndCloseResult(irodsQuery, 0);
        }
        catch (JargonQueryException e) {
            this.log.error("query exception for query", (Throwable)e);
            throw new JargonException("error in query for user", e);
        }
        catch (GenQueryBuilderException e) {
            this.log.error("query exception for query", (Throwable)e);
            throw new JargonException("error in query for user", e);
        }
        ArrayList<String> results = new ArrayList<String>();
        StringBuilder name = new StringBuilder();
        for (IRODSQueryResultRow row : resultSet.getResults()) {
            name = new StringBuilder();
            name.append(row.getColumn(1));
            name.append('#');
            name.append(row.getColumn(0));
            results.add(name.toString());
        }
        this.log.debug("user list:{}", results);
        return results;
    }

    @Override
    public String retriveUserDNByUserId(String userId) throws JargonException {
        return UserAOHelper.findUserDnIfExists(userId, this.getGenQueryExecutor());
    }

    @Override
    public void deleteUser(String userName) throws InvalidUserException, JargonException {
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty user name");
        }
        GeneralAdminInp adminPI = GeneralAdminInp.instanceForDeleteUser(userName);
        this.log.debug("executing admin PI");
        try {
            this.getIRODSProtocol().irodsFunction(adminPI);
        }
        catch (DataNotFoundException dnf) {
            this.log.debug("user does not exist, just behave as if deleted");
        }
        catch (InvalidUserException iue) {
            this.log.debug("user does not exist, just behave as if deleted");
        }
        catch (NoMoreRulesException nmr) {
            this.log.debug("no more rules exception interpereted as user does not exist, just behave as if deleted");
        }
        this.log.info("user {} removed", (Object)userName);
    }

    @Override
    public void updateUser(User user) throws JargonException, DataNotFoundException {
        if (user == null) {
            throw new IllegalArgumentException("user is null");
        }
        if (user.getId() == null || user.getId().isEmpty()) {
            throw new IllegalArgumentException("user id is null or empty, cannot update");
        }
        this.updatePreChecks(user);
        User currentUser = this.findById(user.getId());
        if (!user.getComment().equals(currentUser.getComment())) {
            this.log.debug("comment has changed");
            this.updateUserComment(user);
        }
        if (!user.getInfo().equals(currentUser.getInfo())) {
            this.log.debug("info has changed");
            this.updateUserInfo(user);
        }
        if (!user.getZone().equals(currentUser.getZone())) {
            this.log.debug("zone has changed");
            this.updateUserZone(user);
        }
        if (!user.getUserType().equals((Object)currentUser.getUserType())) {
            this.log.debug("user type has changed");
            this.updateUserType(user);
        }
        if (!user.getUserDN().equals(currentUser.getUserDN())) {
            if (user.getUserDN().isEmpty()) {
                this.log.info("removing DN");
                this.removeUserDN(currentUser.getNameWithZone(), currentUser.getUserDN());
            } else if (currentUser.getUserDN().isEmpty()) {
                this.log.info("add new DN");
                this.updateUserDN(currentUser.getNameWithZone(), user.getUserDN());
            } else {
                this.log.info("remove old");
                this.removeUserDN(currentUser.getNameWithZone(), currentUser.getUserDN());
                this.log.info("add new");
                this.updateUserDN(currentUser.getNameWithZone(), user.getUserDN());
            }
        }
    }

    @Override
    public String getTemporaryPasswordForConnectedUser() throws JargonException {
        GetTempPasswordIn getPasswordInPI = GetTempPasswordIn.instance();
        this.log.debug("executing getPasswordInPI");
        Tag response = this.getIRODSProtocol().irodsFunction(getPasswordInPI);
        String responseHashCode = response.getTag(STRING_TO_HASH_WITH).getStringValue();
        this.log.info("hash value:{}", (Object)responseHashCode);
        String tempPassword = IRODSPasswordUtilities.getHashedPassword(responseHashCode, this.getIRODSAccount());
        return tempPassword;
    }

    @Override
    public String getTemporaryPasswordForASpecifiedUser(String targetUserName) throws JargonException {
        this.log.info("getTemporaryPasswordForASpecifiedUser()");
        if (!this.getIRODSServerProperties().isTheIrodsServerAtLeastAtTheGivenReleaseVersion("rods3.1")) {
            throw new UnsupportedOperationException("temp password generation implemented in iRODS 3.1+ only");
        }
        GetTempPasswordForOther getTempPasswordForOtherPI = GetTempPasswordForOther.instance(targetUserName);
        Tag response = this.getIRODSProtocol().irodsFunction(getTempPasswordForOtherPI);
        String responseHashCode = response.getTag(STRING_TO_HASH_WITH).getStringValue();
        this.log.info("hash value:{}", (Object)responseHashCode);
        String tempPassword = IRODSPasswordUtilities.getHashedPassword(responseHashCode, this.getIRODSAccount());
        return tempPassword;
    }

    @Override
    public void changeAUserPasswordByThatUser(String userName, String currentPassword, String newPassword) throws JargonException {
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("userName is null or missing");
        }
        if (currentPassword == null || currentPassword.isEmpty()) {
            throw new IllegalArgumentException("currentPassword is null or missing");
        }
        if (newPassword == null || newPassword.isEmpty()) {
            throw new IllegalArgumentException("newPassword is null or missing");
        }
        this.log.info("changeAUserPasswordByThatUser for user:{}", (Object)userName);
        String obfuscatedPassword = IRODSPasswordUtilities.obfEncodeByKey(newPassword, currentPassword, true);
        UserAdminInp userAdminIn = UserAdminInp.instanceForChangeUserPassword(userName, obfuscatedPassword);
        this.getIRODSProtocol().irodsFunction(userAdminIn);
    }

    @Override
    public void changeAUserPasswordByAnAdmin(String userName, String newPassword) throws JargonException {
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("userName is null or missing");
        }
        if (newPassword == null || newPassword.isEmpty()) {
            throw new IllegalArgumentException("newPassword is null or missing");
        }
        String randPaddedNewPassword = IRODSPasswordUtilities.padPasswordWithRandomStringData(newPassword);
        String key2 = this.getIRODSProtocol().getAuthResponse().getChallengeValue();
        String derivedChallenge = IRODSPasswordUtilities.deriveHexSubsetOfChallenge(key2);
        String myKey2 = IRODSPasswordUtilities.obfuscateIRODSPasswordForAdminPasswordChange(randPaddedNewPassword, this.getIRODSAccount().getPassword(), derivedChallenge);
        this.log.info("changeAUserPasswordByAnAdmin for user:{}", (Object)userName);
        GeneralAdminInp adminPI = GeneralAdminInp.instanceForModifyUserPassword(userName, myKey2);
        this.getIRODSProtocol().irodsFunction(adminPI);
    }

    private void updatePreChecks(User user) throws JargonException {
        if (user.getName() == null || user.getName().isEmpty()) {
            throw new JargonException("user name is null or missing");
        }
        if (user.getComment() == null) {
            throw new JargonException("user comment is null");
        }
        if (user.getInfo() == null) {
            throw new JargonException("user info is null");
        }
        if (user.getZone() == null) {
            throw new JargonException("user zone is null");
        }
        if (user.getUserType() == null || user.getUserType() == UserTypeEnum.RODS_UNKNOWN) {
            throw new JargonException("null or unknown user type");
        }
    }

    @Override
    public void addAVUMetadata(String userName, AvuData avuData) throws DataNotFoundException, JargonException {
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        if (avuData == null) {
            throw new IllegalArgumentException("null AVU data");
        }
        this.log.info("adding avu metadata to user: {}", (Object)avuData);
        this.log.info("userName {}", (Object)userName);
        ModAvuMetadataInp modifyAvuMetadataInp = ModAvuMetadataInp.instanceForAddUserMetadata(userName, avuData);
        this.log.debug("sending avu request");
        try {
            this.getIRODSProtocol().irodsFunction(modifyAvuMetadataInp);
        }
        catch (JargonException je) {
            if (je.getMessage().indexOf("-827000") > -1) {
                throw new DataNotFoundException("User was not found, could not add AVU");
            }
            this.log.error("jargon exception adding AVU metadata", (Throwable)je);
            throw je;
        }
        this.log.debug("metadata added");
    }

    @Override
    public void modifyAVUMetadata(String userName, AvuData avuData) throws DataNotFoundException, JargonException {
        throw new UnsupportedOperationException("need to implement");
    }

    @Override
    public void deleteAVUMetadata(String userName, AvuData avuData) throws DataNotFoundException, JargonException {
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        if (avuData == null) {
            throw new IllegalArgumentException("null AVU data");
        }
        this.log.info("deleting avu metadata for user: {}", (Object)avuData);
        this.log.info("userName {}", (Object)userName);
        ModAvuMetadataInp modifyAvuMetadataInp = ModAvuMetadataInp.instanceForDeleteUserMetadata(userName, avuData);
        this.log.debug("sending avu request");
        try {
            this.getIRODSProtocol().irodsFunction(modifyAvuMetadataInp);
        }
        catch (JargonException je) {
            if (je.getMessage().indexOf("-827000") > -1) {
                throw new DataNotFoundException("User was not found, could not delete AVU");
            }
            this.log.error("jargon exception adding AVU metadata", (Throwable)je);
            throw je;
        }
        this.log.debug("metadata deleted");
    }

    @Override
    public void updateUserInfo(String userName, String userInfo) throws DataNotFoundException, JargonException {
        this.log.info("updateUserInfo()");
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        if (userInfo == null) {
            throw new IllegalArgumentException("null userInfo");
        }
        this.log.info("userName:{}", (Object)userName);
        this.log.info("userInfo:{}", (Object)userInfo);
        User user = this.findByName(userName);
        this.log.info("looked up user:{}", (Object)user);
        user.setInfo(userInfo);
        this.updateUserInfo(user);
        this.log.info("updated info");
    }

    private void updateUserType(User user) throws JargonException {
        GeneralAdminInp adminPI = GeneralAdminInp.instanceForModifyUserType(user.getName(), user.getUserType());
        this.getIRODSProtocol().irodsFunction(adminPI);
    }

    @Override
    public void updateUserDN(String userName, String userDN) throws InvalidUserException, JargonException {
        this.log.info("updateUserDN()");
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        if (userDN == null || userDN.isEmpty()) {
            throw new IllegalArgumentException("null or empty userDN");
        }
        this.log.info("userName:{}", (Object)userName);
        this.log.info("userDN:{}", (Object)userDN);
        GeneralAdminInp adminPI = GeneralAdminInp.instanceForModifyUserDN(userName, userDN);
        this.getIRODSProtocol().irodsFunction(adminPI);
    }

    @Override
    public void removeUserDN(String userName, String userDN) throws JargonException {
        this.log.info("removeUserDN()");
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        if (userDN == null || userDN.isEmpty()) {
            throw new IllegalArgumentException("null or empty userDN");
        }
        this.log.info("userName:{}", (Object)userName);
        this.log.info("userDN:{}", (Object)userDN);
        GeneralAdminInp adminPI = GeneralAdminInp.instanceForRemoveUserDN(userName, userDN);
        this.getIRODSProtocol().irodsFunction(adminPI);
    }

    private void updateUserZone(User user) throws JargonException {
        GeneralAdminInp adminPI = GeneralAdminInp.instanceForModifyUserZone(user.getName(), user.getZone());
        this.getIRODSProtocol().irodsFunction(adminPI);
    }

    private void updateUserComment(User user) throws JargonException {
        GeneralAdminInp adminPI = GeneralAdminInp.instanceForModifyUserComment(user.getName(), user.getComment());
        this.getIRODSProtocol().irodsFunction(adminPI);
    }

    private void updateUserInfo(User user) throws JargonException {
        GeneralAdminInp adminPI = GeneralAdminInp.instanceForModifyUserInfo(user.getName(), user.getInfo());
        this.getIRODSProtocol().irodsFunction(adminPI);
    }

    private IRODSGenQueryExecutor getGenQueryExecutor() throws JargonException {
        if (this.irodsGenQueryExecutor == null) {
            this.irodsGenQueryExecutor = this.getIRODSAccessObjectFactory().getIRODSGenQueryExecutor(this.getIRODSAccount());
        }
        return this.irodsGenQueryExecutor;
    }
}

