/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.transfer.encrypt;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import org.irods.jargon.core.connection.NegotiatedClientServerConfiguration;
import org.irods.jargon.core.connection.PipelineConfiguration;
import org.irods.jargon.core.exception.ClientServerNegotiationException;
import org.irods.jargon.core.exception.JargonRuntimeException;
import org.irods.jargon.core.transfer.encrypt.EncryptionBuffer;
import org.irods.jargon.core.transfer.encrypt.ParallelDecryptionCipherWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AesCipherDecryptWrapper
extends ParallelDecryptionCipherWrapper {
    public static final Logger log = LoggerFactory.getLogger(AesCipherDecryptWrapper.class);

    AesCipherDecryptWrapper(PipelineConfiguration pipelineConfiguration, NegotiatedClientServerConfiguration negotiatedClientServerConfiguration) throws ClientServerNegotiationException {
        super(pipelineConfiguration, negotiatedClientServerConfiguration);
        this.initImplementation();
    }

    private void initImplementation() {
        try {
            log.info("initCipher()");
            this.setCipher(Cipher.getInstance(this.getPipelineConfiguration().getEncryptionAlgorithmEnum().getCypherKey()));
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            log.error("error initing for cipher", (Throwable)e);
            throw new JargonRuntimeException("cannot init for cipher", e);
        }
    }

    @Override
    protected byte[] doDecrypt(EncryptionBuffer input) {
        try {
            this.getCipher().init(2, (Key)this.getNegotiatedClientServerConfiguration().getSecretKey(), new IvParameterSpec(input.getInitializationVector()));
            byte[] original = this.getCipher().doFinal(input.getEncryptedData());
            return original;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            log.error("error during encryption", (Throwable)e);
            throw new JargonRuntimeException("Unable to decrypt given negotiated settings", e);
        }
    }

    @Override
    protected byte[] doDecrypt(byte[] fullBuffer) {
        log.info("doDecrypt()");
        if (fullBuffer.length < 32) {
            log.error("unusable data in buffer, less than 32 bytes");
            throw new JargonRuntimeException("unusable data in data buffer");
        }
        if (fullBuffer.length == 32) {
            log.warn("no data in buffer to decrypt, return empty buffer");
            return new byte[0];
        }
        log.debug("fullbuffer length:{}", (Object)fullBuffer.length);
        log.debug("buffer - iv length:{}", (Object)(fullBuffer.length - 32));
        EncryptionBuffer encryptionBuffer = new EncryptionBuffer(Arrays.copyOfRange(fullBuffer, 0, 16), this.extractEncryptedData(fullBuffer));
        log.debug("length of encrypted buffer:{}", (Object)encryptionBuffer.getEncryptedData().length);
        return this.doDecrypt(encryptionBuffer);
    }

    private byte[] extractEncryptedData(byte[] fullBuffer) {
        byte[] returned = new byte[fullBuffer.length - 32];
        System.arraycopy(fullBuffer, 32, returned, 0, fullBuffer.length - 32);
        return returned;
    }
}

