/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.testutils;

import java.util.Properties;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.exception.JargonRuntimeException;
import org.irods.jargon.core.exception.UnixFileRenameException;
import org.irods.jargon.core.pub.IRODSFileSystem;
import org.irods.jargon.core.pub.io.IRODSFile;
import org.irods.jargon.testutils.TestingPropertiesHelper;
import org.irods.jargon.testutils.TestingUtilsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IRODSTestSetupUtilities {
    private TestingPropertiesHelper testingPropertiesHelper = new TestingPropertiesHelper();
    private Properties testingProperties = this.testingPropertiesHelper.getTestProperties();
    private IRODSFileSystem irodsFileSystem;
    public static final Logger log = LoggerFactory.getLogger(IRODSTestSetupUtilities.class);

    public IRODSTestSetupUtilities() throws TestingUtilsException {
        try {
            this.irodsFileSystem = IRODSFileSystem.instance();
        }
        catch (JargonException e) {
            throw new TestingUtilsException("cannot create IRODSFileSystem", e);
        }
    }

    public void clearIrodsScratchDirectory() throws TestingUtilsException {
        try {
            IRODSAccount irodsAccount = this.testingPropertiesHelper.buildIRODSAccountFromTestProperties(this.testingProperties);
            String targetIrodsCollection = this.testingPropertiesHelper.buildIRODSCollectionAbsolutePathFromTestProperties(this.testingProperties, "");
            IRODSFile testScratchFile = this.irodsFileSystem.getIRODSFileFactory(irodsAccount).instanceIRODSFile(targetIrodsCollection);
            try {
                testScratchFile.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        catch (JargonRuntimeException e) {
            if (e.getCause() instanceof UnixFileRenameException) {
                log.error("rename exception, overheaded per bug  [#1628] intermittent -528036 errors on delete of collections", (Throwable)e);
                return;
            }
            throw new TestingUtilsException("error clearing irods scratch dir", e);
        }
        catch (Exception e) {
            throw new TestingUtilsException("error clearing scratch dir", e);
        }
        finally {
            if (this.irodsFileSystem != null) {
                this.irodsFileSystem.closeAndEatExceptions();
            }
        }
    }

    public void initializeIrodsScratchDirectory() throws TestingUtilsException {
        this.clearIrodsScratchDirectory();
        try {
            IRODSAccount irodsAccount = this.testingPropertiesHelper.buildIRODSAccountFromTestProperties(this.testingProperties);
            String targetIrodsCollection = this.testingPropertiesHelper.buildIRODSCollectionAbsolutePathFromTestProperties(this.testingProperties, this.testingProperties.getProperty(TestingPropertiesHelper.IRODS_SCRATCH_DIR_KEY));
            IRODSFile testScratchFile = this.irodsFileSystem.getIRODSFileFactory(irodsAccount).instanceIRODSFile(targetIrodsCollection);
            testScratchFile.mkdirs();
        }
        catch (Exception e) {
            throw new TestingUtilsException("error clearing irods scratch dir", e);
        }
        finally {
            if (this.irodsFileSystem != null) {
                this.irodsFileSystem.closeAndEatExceptions();
            }
        }
    }

    public void initializeDirectoryForTest(String testingDirectory) throws TestingUtilsException {
        StringBuilder scratchDir = new StringBuilder();
        scratchDir.append(this.testingPropertiesHelper.buildIRODSCollectionAbsolutePathFromTestProperties(this.testingProperties, ""));
        scratchDir.append('/');
        scratchDir.append(testingDirectory);
        try {
            IRODSAccount irodsAccount = this.testingPropertiesHelper.buildIRODSAccountFromTestProperties(this.testingProperties);
            this.testingPropertiesHelper.buildIRODSCollectionAbsolutePathFromTestProperties(this.testingProperties, this.testingProperties.getProperty(TestingPropertiesHelper.IRODS_SCRATCH_DIR_KEY));
            IRODSFile testScratchFile = this.irodsFileSystem.getIRODSFileFactory(irodsAccount).instanceIRODSFile(scratchDir.toString());
            testScratchFile.mkdirs();
        }
        catch (Exception e) {
            throw new TestingUtilsException("error clearing irods scratch dir", e);
        }
        finally {
            if (this.irodsFileSystem != null) {
                this.irodsFileSystem.closeAndEatExceptions();
            }
        }
    }
}

