/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.testutils.filemanip;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.irods.jargon.testutils.TestingPropertiesHelper;
import org.irods.jargon.testutils.TestingUtilsException;

public class ScratchFileUtils {
    private Properties testingProperties = new Properties();

    public ScratchFileUtils(Properties testingProperties) throws TestingUtilsException {
        this.testingProperties = testingProperties;
        this.checkTrailingSlash(testingProperties.getProperty(TestingPropertiesHelper.GENERATED_FILE_DIRECTORY_KEY));
    }

    public void createScratchDirIfNotExists(String pathUnderScratch) {
        File scratchDir = new File(this.testingProperties.getProperty(TestingPropertiesHelper.GENERATED_FILE_DIRECTORY_KEY) + pathUnderScratch);
        scratchDir.mkdirs();
    }

    public void createBaseScratchDir() {
        this.createScratchDirIfNotExists("");
    }

    public void clearAndReinitializeScratchDirectory(String pathUnderScratch) {
        File scratchDir = new File(this.testingProperties.getProperty(TestingPropertiesHelper.GENERATED_FILE_DIRECTORY_KEY) + pathUnderScratch);
        if (scratchDir.exists()) {
            this.removeFiles(scratchDir);
            scratchDir.delete();
        }
        scratchDir.delete();
        scratchDir.mkdirs();
    }

    private void removeFiles(File file) {
        File[] files;
        if (file == null) {
            throw new IllegalArgumentException("null file");
        }
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File file2 : files) {
                this.removeFiles(file2);
            }
        }
        file.delete();
    }

    public boolean checkIfFileExistsInScratch(String pathUnderScratch) {
        File targetFile = new File(this.testingProperties.getProperty(TestingPropertiesHelper.GENERATED_FILE_DIRECTORY_KEY) + pathUnderScratch);
        return targetFile.exists();
    }

    public void createDirectoryUnderScratch(String relativePath) {
        this.createScratchDirIfNotExists(relativePath);
    }

    public String createAndReturnAbsoluteScratchPath(String path) {
        this.createScratchDirIfNotExists(path);
        StringBuilder pathBuilder = new StringBuilder();
        pathBuilder.append(this.testingProperties.getProperty(TestingPropertiesHelper.GENERATED_FILE_DIRECTORY_KEY));
        pathBuilder.append(path);
        pathBuilder.append('/');
        return pathBuilder.toString();
    }

    public byte[] computeFileCheckSum(String pathUnderScratch) throws TestingUtilsException {
        MessageDigest complete;
        StringBuilder pathBuilder = new StringBuilder();
        pathBuilder.append(this.testingProperties.getProperty(TestingPropertiesHelper.GENERATED_FILE_DIRECTORY_KEY));
        pathBuilder.append(pathUnderScratch);
        InputStream fis = null;
        try {
            int numRead;
            fis = new FileInputStream(pathBuilder.toString());
            byte[] buffer = new byte[1024];
            complete = MessageDigest.getInstance("MD5");
            do {
                if ((numRead = fis.read(buffer)) <= 0) continue;
                complete.update(buffer, 0, numRead);
            } while (numRead != -1);
        }
        catch (FileNotFoundException fnfe) {
            StringBuilder message = new StringBuilder();
            message.append("could not find file to checksum at:");
            message.append((CharSequence)pathBuilder);
            throw new TestingUtilsException(message.toString(), fnfe);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new TestingUtilsException("could not MD5 algorithim for checksum", nsae);
        }
        catch (IOException ioe) {
            StringBuilder message = new StringBuilder();
            message.append("io exception generating checksum for file:");
            message.append((CharSequence)pathBuilder);
            throw new TestingUtilsException(message.toString(), ioe);
        }
        finally {
            try {
                fis.close();
            }
            catch (Exception exception) {}
        }
        return complete.digest();
    }

    public long computeFileCheckSumViaAbsolutePath(String absolutePathToLocalFile) throws TestingUtilsException {
        FileInputStream file;
        try {
            file = new FileInputStream(absolutePathToLocalFile);
        }
        catch (FileNotFoundException e1) {
            throw new TestingUtilsException("error computing checksum, file not found:" + absolutePathToLocalFile, e1);
        }
        CheckedInputStream check = new CheckedInputStream(file, new CRC32());
        BufferedInputStream in = new BufferedInputStream(check);
        try {
            while (in.read() != -1) {
            }
        }
        catch (IOException e) {
            throw new TestingUtilsException("error computing checksum for file:" + absolutePathToLocalFile, e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return check.getChecksum().getValue();
    }

    private void checkTrailingSlash(String path) throws TestingUtilsException {
        String trimmedPath = path.trim();
        String lastChar = trimmedPath.substring(trimmedPath.length() - 1);
        if (!lastChar.equals("/") && !lastChar.equals("\\")) {
            throw new TestingUtilsException("please set the test.data.directory property in testing.properties to have a trailing / char ");
        }
    }
}

