/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.ProxyCredentialsStore;
import ch.cyberduck.core.preferences.MemoryPreferences;
import ch.cyberduck.core.preferences.Preferences;

public class PreferencesProxyCredentialsStore
implements ProxyCredentialsStore {
    private final Preferences preferences;

    public PreferencesProxyCredentialsStore() {
        this(new MemoryPreferences());
    }

    public PreferencesProxyCredentialsStore(Preferences preferences) {
        this.preferences = preferences;
        this.preferences.load();
    }

    @Override
    public Credentials getCredentials(String proxy) {
        return new Credentials(this.preferences.getProperty(String.format("proxy.credentials.username.%s", proxy)), this.preferences.getProperty(String.format("proxy.credentials.password.%s", proxy)));
    }

    @Override
    public void addCredentials(String proxy, String accountName, String password) {
        this.preferences.setProperty(String.format("proxy.credentials.username.%s", proxy), accountName);
        this.preferences.setProperty(String.format("proxy.credentials.password.%s", proxy), password);
    }

    @Override
    public void deleteCredentials(String proxy) {
        this.preferences.deleteProperty(String.format("proxy.credentials.username.%s", proxy));
        this.preferences.deleteProperty(String.format("proxy.credentials.password.%s", proxy));
    }
}

