/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.editor;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.editor.AbstractEditor;
import ch.cyberduck.core.io.watchservice.NIOEventWatchService;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.local.ApplicationFinder;
import ch.cyberduck.core.local.ApplicationLauncher;
import ch.cyberduck.core.local.FileWatcher;
import ch.cyberduck.core.local.FileWatcherListener;
import ch.cyberduck.core.pool.SessionPool;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.apache.log4j.Logger;

public class DefaultWatchEditor
extends AbstractEditor {
    private static final Logger log = Logger.getLogger(DefaultWatchEditor.class);
    private final FileWatcher monitor = new FileWatcher(new NIOEventWatchService());

    public DefaultWatchEditor(Application application, SessionPool session, Path file, ProgressListener listener) {
        super(application, session, file, listener);
    }

    public DefaultWatchEditor(Application application, SessionPool session, Path file, ApplicationLauncher launcher, ApplicationFinder finder, ProgressListener listener) {
        super(application, session, file, launcher, finder, listener);
    }

    @Override
    protected void watch(Local local, FileWatcherListener listener) throws IOException {
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)this.monitor.register(local.getParent(), new FileWatcher.DefaultFileFilter(local), listener));
    }

    @Override
    public void close() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Close monitor %s", this.monitor));
        }
        this.monitor.close();
    }
}

