/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.formatter;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.formatter.SizeFormatter;
import ch.cyberduck.core.formatter.Unit;
import java.math.BigDecimal;
import java.text.NumberFormat;

public abstract class AbstractSizeFormatter
implements SizeFormatter {
    private final Unit kilo;
    private final Unit mega;
    private final Unit giga;

    public AbstractSizeFormatter(Unit kilo, Unit mega, Unit giga) {
        this.kilo = kilo;
        this.mega = mega;
        this.giga = giga;
    }

    @Override
    public String format(long size) {
        return this.format(size, false);
    }

    @Override
    public String format(long size, boolean plain) {
        if (size < 0L) {
            return LocaleFactory.localizedString("--");
        }
        if (size < this.kilo.multiple()) {
            return String.format("%d B", size);
        }
        StringBuilder formatted = new StringBuilder();
        if (size < this.mega.multiple()) {
            formatted.append(new BigDecimal(size).divide(new BigDecimal(this.kilo.multiple()), 1, 4).toString()).append(" ").append(this.kilo.suffix());
        } else if (size < this.giga.multiple()) {
            formatted.append(new BigDecimal(size).divide(new BigDecimal(this.mega.multiple()), 1, 4).toString()).append(" ").append(this.mega.suffix());
        } else {
            formatted.append(new BigDecimal(size).divide(new BigDecimal(this.giga.multiple()), 1, 4).toString()).append(" ").append(this.giga.suffix());
        }
        if (plain) {
            formatted.append(" (").append(NumberFormat.getInstance().format(size)).append(" bytes)");
        }
        return formatted.toString();
    }
}

