/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.http;

import ch.cyberduck.core.http.DelayedHttpEntity;
import ch.cyberduck.core.transfer.TransferStatus;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.mime.MIME;
import org.apache.http.util.ByteArrayBuffer;
import org.apache.log4j.Logger;

public class DelayedHttpMultipartEntity
extends DelayedHttpEntity {
    private static final Logger log = Logger.getLogger(DelayedHttpMultipartEntity.class);
    public static final String DEFAULT_BOUNDARY = "------------------------d8ad73fe428d737a";
    private final TransferStatus status;
    private final CountDownLatch exit = new CountDownLatch(1);
    private static final String CR_LF = "\r\n";
    private static final String TWO_DASHES = "--";
    private final byte[] header;
    private final byte[] footer;
    private OutputStream stream;
    private boolean consumed = false;

    public DelayedHttpMultipartEntity(String filename, TransferStatus status) {
        this(filename, status, DEFAULT_BOUNDARY);
    }

    public DelayedHttpMultipartEntity(String filename, TransferStatus status, String boundary) {
        this.status = status;
        StringBuilder multipartHeader = new StringBuilder();
        multipartHeader.append(TWO_DASHES);
        multipartHeader.append(boundary);
        multipartHeader.append(CR_LF);
        multipartHeader.append(String.format("Content-Disposition: form-data; name=\"file\"; filename=\"%s\"", filename));
        multipartHeader.append(CR_LF);
        multipartHeader.append(String.format("%s: %s", "Content-Type", StringUtils.isBlank((CharSequence)status.getMime()) ? "application/octet-stream" : status.getMime()));
        multipartHeader.append(CR_LF);
        multipartHeader.append(CR_LF);
        this.header = DelayedHttpMultipartEntity.encode(MIME.DEFAULT_CHARSET, multipartHeader.toString()).buffer();
        StringBuilder multipartFooter = new StringBuilder();
        multipartFooter.append(CR_LF);
        multipartFooter.append(TWO_DASHES);
        multipartFooter.append(boundary);
        multipartFooter.append(TWO_DASHES);
        multipartFooter.append(CR_LF);
        this.footer = DelayedHttpMultipartEntity.encode(MIME.DEFAULT_CHARSET, multipartFooter.toString()).buffer();
    }

    private static ByteArrayBuffer encode(Charset charset, String input) {
        ByteBuffer encoded = charset.encode(CharBuffer.wrap(input));
        ByteArrayBuffer bab = new ByteArrayBuffer(encoded.remaining());
        bab.append(encoded.array(), encoded.position(), encoded.remaining());
        return bab;
    }

    @Override
    public long getContentLength() {
        return (long)this.header.length + this.status.getLength() + (long)this.footer.length;
    }

    @Override
    public OutputStream getStream() {
        if (null == this.stream) {
            return NullOutputStream.NULL_OUTPUT_STREAM;
        }
        return this.stream;
    }

    @Override
    public void writeTo(final OutputStream out) throws IOException {
        try {
            this.stream = new OutputStream(){
                private final AtomicBoolean close = new AtomicBoolean();

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    out.write(b, off, len);
                }

                @Override
                public void write(int b) throws IOException {
                    out.write(b);
                }

                @Override
                public void write(byte[] b) throws IOException {
                    out.write(b);
                }

                @Override
                public void close() throws IOException {
                    if (this.close.get()) {
                        log.warn((Object)String.format("Skip double close of stream %s", this));
                        return;
                    }
                    try {
                        out.write(DelayedHttpMultipartEntity.this.footer);
                        super.close();
                    }
                    finally {
                        DelayedHttpMultipartEntity.this.exit.countDown();
                        this.close.set(true);
                    }
                }
            };
            this.stream.write(this.header);
        }
        finally {
            CountDownLatch entry = this.getEntry();
            entry.countDown();
        }
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)this.exit);
        this.consumed = true;
    }

    @Override
    public boolean isStreaming() {
        return !this.consumed;
    }
}

