/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.PromptUrlProvider;
import ch.cyberduck.core.worker.Worker;
import java.text.MessageFormat;
import java.util.Collections;
import org.apache.log4j.Logger;

public class DownloadShareWorker<Options>
extends Worker<DescriptiveUrl> {
    private static final Logger log = Logger.getLogger(DownloadShareWorker.class);
    private final Path file;
    private final Options options;
    private PasswordCallback callback;

    public DownloadShareWorker(Path file, Options options, PasswordCallback callback) {
        this.file = file;
        this.options = options;
        this.callback = callback;
    }

    @Override
    public DescriptiveUrl run(Session<?> session) throws BackgroundException {
        PromptUrlProvider provider = session.getFeature(PromptUrlProvider.class);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Run with feature %s", provider));
        }
        return provider.toDownloadUrl(this.file, this.options, this.callback);
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString("Prepare {0} ({1})", "Status"), this.toString(Collections.singletonList(this.file)), LocaleFactory.localizedString("URL", "Download"));
    }
}

