/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.comparator;

import ch.cyberduck.core.Path;
import ch.cyberduck.ui.comparator.BrowserComparator;
import ch.cyberduck.ui.comparator.FilenameComparator;
import java.text.Collator;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class ExtensionComparator
extends BrowserComparator {
    private static final long serialVersionUID = -7930478156003767294L;
    private final Collator impl = Collator.getInstance(Locale.getDefault());

    public ExtensionComparator(boolean ascending) {
        super(ascending, new FilenameComparator(ascending));
    }

    @Override
    protected int compareFirst(Path p1, Path p2) {
        if (p1.isDirectory() && p2.isDirectory()) {
            return 0;
        }
        if (p1.isFile() && p2.isFile()) {
            if (StringUtils.isBlank((CharSequence)p1.getExtension()) && StringUtils.isBlank((CharSequence)p2.getExtension())) {
                return 0;
            }
            if (StringUtils.isBlank((CharSequence)p1.getExtension())) {
                return -1;
            }
            if (StringUtils.isBlank((CharSequence)p2.getExtension())) {
                return 1;
            }
            if (this.ascending) {
                return this.impl.compare(p1.getExtension(), p2.getExtension());
            }
            return -this.impl.compare(p1.getExtension(), p2.getExtension());
        }
        if (p1.isFile()) {
            return this.ascending ? 1 : -1;
        }
        return this.ascending ? -1 : 1;
    }
}

