# eiscor - eigensolvers based on unitary core transformations #
This package is a collection of Fortran 90 subroutines for accurately 
and efficiently solving matrix eigenvalue problems using essentially 2x2 
unitary matrices.

## Authors ##
- [Jared L. Aurentz](https://www.icmat.es/jared.aurentz), 
University of Oxford, United Kingdom
- [Thomas Mach](https://sst.nu.edu.kz/thomas-mach/), 
KU Leuven, Belgium
- [Raf Vandebril](http://people.cs.kuleuven.be/~raf.vandebril/), 
KU Leuven, Belgium
- [David S. Watkins](http://www.math.wsu.edu/faculty/watkins/), 
Washington State University, United States

## The eiscor guide ##
To get started with __eiscor__ please checkout the [guide](https://github.com/eiscor/eiscor/blob/master/docs/GUIDE.md).

## Related articles ##
This software is based on the following articles:

 1. Jared L. Aurentz, Thomas Mach, Raf Vandebril, and David S. Watkins. 
[_Fast and stable unitary QR algorithm._](http://etna.mcs.kent.edu/volumes/2011-2020/vol44/abstract.php?vol=44&pages=327-341) 
Electronic Transactions on Numerical Analysis. Vol. 44, pp. 327-341. 2015.
 2. Jared L. Aurentz, Thomas Mach, Raf Vandebril, and David S. Watkins. 
[_Fast and backward stable computation of roots of polynomials._](http://epubs.siam.org/doi/10.1137/140983434) 
SIAM Journal on Matrix Analysis and Applications. Vol. 36, No. 3, pp. 
942-973. 2015.
 3. Thomas Mach and Raf Vandebril. [_On deﬂations in extended QR Algorithms._](http://epubs.siam.org/doi/abs/10.1137/130935665) SIAM Journal on Matrix 
Analysis and Applications. Vol. 35, No. 2, pp. 559–579. 2014. 
 4. Raf Vandebril and David S. Watkins. [_An extension of the QZ algorithm 
beyond the Hessenberg-upper triangular pencil._](http://etna.mcs.kent.edu/volumes/2011-2020/vol40/abstract.php?vol=40&pages=17-35) Electronic 
Transactions on Numerical Analysis. Vol. 40, pp. 17-35. 2013.
 5. Raf Vandebril and David S. Watkins. [_A generalization of the 
multishift QR-algorithm._](http://epubs.siam.org/doi/abs/10.1137/11085219X) 
SIAM Journal on Matrix Analysis and Applications. Vol. 33, No. 3, 
pp. 759-779. 2012.
 6. Raf Vandebril. [_Chasing bulges or rotations? A metamorphosis of the 
QR-algorithm._](http://epubs.siam.org/doi/abs/10.1137/100809167) SIAM Journal 
on Matrix Analysis and Applications. Vol. 32, No. 1, pp. 217-247. 2011.

