/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* TypeDef Declarations                                                       *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_TYPEDEF_CLASSES
#undef GET_TYPEDEF_CLASSES


namespace mlir {
class AsmParser;
class AsmPrinter;
} // namespace mlir
namespace fir {

/// CHARACTER type descriptor.
/// The type of a pair that describes a CHARACTER variable. Specifically, a
///     CHARACTER consists of a reference to a buffer (the string value) and a LEN
///     type parameter (the runtime length of the buffer).
class BoxCharType;
/// The type of a pair that describes a PROCEDURE reference. Pointers to
///     internal procedures must carry an additional reference to the host's
///     variables that are referenced.
class BoxProcType;
/// The type of a Fortran descriptor
/// Descriptors are tuples of information that describe an entity being passed
///     from a calling context. This information might include (but is not limited
///     to) whether the entity is an array, its size, or what type it has.
class BoxType;
/// FIR character type
/// Model of the Fortran CHARACTER intrinsic type, including the KIND type
///     parameter. The model optionally includes a LEN type parameter. A
///     CharacterType is thus the type of both a single character value and a
///     character with a LEN parameter.
class CharacterType;
/// Class type
/// Class type is used to model the Fortran CLASS intrinsic type. A class type
///     is equivalent to a fir.box type with a dynamic type.
class ClassType;
/// A field (in a RecordType) argument's type
/// The type of a field name. Implementations may defer the layout of a Fortran
///     derived type until runtime. This implies that the runtime must be able to
///     determine the offset of fields within the entity.
class FieldType;
/// Reference to an ALLOCATABLE attribute type
/// The type of a heap pointer. Fortran entities with the ALLOCATABLE attribute
///     may be allocated on the heap at runtime. These pointers are explicitly
///     distinguished to disallow the composition of multiple levels of
///     indirection. For example, an ALLOCATABLE POINTER is invalid.
class HeapType;
/// FIR integer type
/// Model of a Fortran INTEGER intrinsic type, including the KIND type
///     parameter.
class IntegerType;
/// FIR unsigned type
/// Model of a Fortran UNSIGNED extension intrinsic type, including
///     the KIND type parameter.
class UnsignedType;
/// A LEN parameter (in a RecordType) argument's type
/// The type of a LEN parameter name. Implementations may defer the layout of a
///     Fortran derived type until runtime. This implies that the runtime must be
///     able to determine the offset of LEN type parameters related to an entity.
class LenType;
/// FIR logical type
/// Model of a Fortran LOGICAL intrinsic type, including the KIND type
///     parameter.
class LogicalType;
/// Like LLVM pointer type
/// A pointer type that does not have any of the constraints and semantics
///     of other FIR pointer types and that translates to llvm pointer types.
///     It is meant to implement indirection that cannot be expressed directly
///     in Fortran, but are needed to implement some Fortran features (e.g,
///     double indirections).
class LLVMPointerType;
/// Reference to a POINTER attribute type
/// The type of entities with the POINTER attribute.  These pointers are
///     explicitly distinguished to disallow the composition of multiple levels of
///     indirection. For example, an ALLOCATABLE POINTER is invalid.
class PointerType;
/// FIR derived type
/// Model of Fortran's derived type, TYPE. The name of the TYPE includes any
///     KIND type parameters. The record includes runtime slots for LEN type
///     parameters and for data components.
class RecordType;
/// Reference to an entity type
/// The type of a reference to an entity in memory.
/// 
///     References can be volatile. Any ops taking an operand of a volatile
///     reference must set their memory effects appropriately. Accesses of
///     volatile references are currently modeled as read and write effects
///     to a specific memory resource.
class ReferenceType;
/// shape of a multidimensional array object
/// Type of a vector of runtime values that define the shape of a
///     multidimensional array object. The vector is the extents of each array
///     dimension. The rank of a ShapeType must be at least 1.
class ShapeType;
/// shape and origin of a multidimensional array object
/// Type of a vector of runtime values that define the shape and the origin of a
///     multidimensional array object. The vector is of pairs, origin offset and
///     extent, of each array dimension. The rank of a ShapeShiftType must be at
///     least 1.
class ShapeShiftType;
/// lower bounds of a multidimensional array object
/// Type of a vector of runtime values that define the lower bounds of a
///     multidimensional array object. The vector is the lower bounds of each array
///     dimension. The rank of a ShiftType must be at least 1.
class ShiftType;
/// FIR array type
/// A sequence type is a multi-dimensional array of values. The sequence type
///     may have an unknown number of dimensions or the extent of dimensions may be
///     unknown. A sequence type models a Fortran array entity, giving it a type in
///     FIR. A sequence type is assumed to be stored in a column-major order, which
///     differs from LLVM IR and other dialects of MLIR.
class SequenceType;
/// FIR slice
/// Type of a vector that represents an array slice operation on an array.
///     Fortran slices are triples of lower bound, upper bound, and stride. The rank
///     of a SliceType must be at least 1.
class SliceType;
/// FIR Type descriptor type
/// The type of a type descriptor object. The runtime may generate type
///     descriptor objects to determine the type of an entity at runtime, etc.
class TypeDescType;
/// FIR vector type
/// Replacement for the builtin vector type.
///     The FIR vector type is always rank one. Its size is always a constant.
///     A vector's element type must be real or integer.
class VectorType;
class VoidType;
/// Dummy scope type
/// `fir.dscope` is a type returned by fir.dummy_scope operation.
///     It defines a unique identifier for a runtime instance of a subroutine
///     that is used by the [hl]fir.declare operations representing
///     the dummy arguments' declarations.
class DummyScopeType;
namespace detail {

struct BoxCharTypeStorage;

} // namespace detail
class BoxCharType : public ::mlir::Type::TypeBase<BoxCharType, ::mlir::Type, detail::BoxCharTypeStorage> {
public:
  using Base::Base;
  using KindTy = unsigned;

  // a !fir.boxchar<k> always wraps a !fir.char<k, ?>
  CharacterType getElementType(mlir::MLIRContext *context) const;

  CharacterType getEleTy() const;
  static constexpr ::llvm::StringLiteral name = "fir.boxchar";
  static constexpr ::llvm::StringLiteral dialectName = "fir";
  static BoxCharType get(::mlir::MLIRContext *context, KindTy kind);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"boxchar"};
  }

  static ::mlir::Type parse(::mlir::AsmParser &odsParser);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  KindTy getKind() const;
};
namespace detail {

struct BoxProcTypeStorage;

} // namespace detail
class BoxProcType : public ::mlir::Type::TypeBase<BoxProcType, ::mlir::Type, detail::BoxProcTypeStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "fir.boxproc";
  static constexpr ::llvm::StringLiteral dialectName = "fir";
  using Base::getChecked;
  static BoxProcType get(::mlir::MLIRContext *context, mlir::Type eleTy);
  static BoxProcType getChecked(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, ::mlir::MLIRContext *context, mlir::Type eleTy);
  static ::llvm::LogicalResult verify(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, mlir::Type eleTy);
  static ::llvm::LogicalResult verifyInvariants(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, mlir::Type eleTy);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"boxproc"};
  }

  static ::mlir::Type parse(::mlir::AsmParser &odsParser);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  mlir::Type getEleTy() const;
};
namespace detail {

struct BoxTypeStorage;

} // namespace detail
class BoxType : public ::mlir::Type::TypeBase<BoxType, BaseBoxType, detail::BoxTypeStorage> {
public:
  using Base::Base;
  mlir::Type getElementType() const { return getEleTy(); }
  bool isVolatile() const { return getIsVolatile(); }
  static constexpr ::llvm::StringLiteral name = "fir.box";
  static constexpr ::llvm::StringLiteral dialectName = "fir";
  using Base::getChecked;
  static BoxType get(mlir::Type eleTy, bool isVolatile = false);
  static BoxType getChecked(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, mlir::Type eleTy, bool isVolatile = false);
  static ::llvm::LogicalResult verify(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, mlir::Type eleTy, bool isVolatile);
  static ::llvm::LogicalResult verifyInvariants(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, mlir::Type eleTy, bool isVolatile);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"box"};
  }

  static ::mlir::Type parse(::mlir::AsmParser &odsParser);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  mlir::Type getEleTy() const;
  bool getIsVolatile() const;
};
namespace detail {

struct CharacterTypeStorage;

} // namespace detail
class CharacterType : public ::mlir::Type::TypeBase<CharacterType, ::mlir::Type, detail::CharacterTypeStorage> {
public:
  using Base::Base;
  using KindTy = unsigned;
  using LenType = std::int64_t;

  /// Return unknown length Character type. e.g., CHARACTER(LEN=n).
  static CharacterType getUnknownLen(mlir::MLIRContext *ctxt, KindTy kind) {
    return get(ctxt, kind, unknownLen());
  }

  /// Return length 1 Character type. e.g., CHARACTER(LEN=1).
  static CharacterType getSingleton(mlir::MLIRContext *ctxt, KindTy kind) {
    return get(ctxt, kind, singleton());
  }

  /// Character is a singleton and has a LEN of 1.
  static constexpr LenType singleton() { return 1; }

  /// Character has a LEN value which is not a compile-time known constant.
  static constexpr LenType unknownLen() { return mlir::ShapedType::kDynamic; }

  /// Character LEN is a runtime value.
  bool hasDynamicLen() { return getLen() == unknownLen(); }

  /// Character LEN is a compile-time constant value.
  bool hasConstantLen() { return !hasDynamicLen(); }
  static constexpr ::llvm::StringLiteral name = "fir.char";
  static constexpr ::llvm::StringLiteral dialectName = "fir";
  static CharacterType get(::mlir::MLIRContext *context, KindTy FKind, CharacterType::LenType len);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"char"};
  }

  static ::mlir::Type parse(::mlir::AsmParser &odsParser);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  KindTy getFKind() const;
  CharacterType::LenType getLen() const;
};
namespace detail {

struct ClassTypeStorage;

} // namespace detail
class ClassType : public ::mlir::Type::TypeBase<ClassType, BaseBoxType, detail::ClassTypeStorage> {
public:
  using Base::Base;
  bool isVolatile() const { return getIsVolatile(); }
  static constexpr ::llvm::StringLiteral name = "fir.class";
  static constexpr ::llvm::StringLiteral dialectName = "fir";
  using Base::getChecked;
  static ClassType get(::mlir::MLIRContext *context, mlir::Type eleTy, bool isVolatile);
  static ClassType getChecked(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, ::mlir::MLIRContext *context, mlir::Type eleTy, bool isVolatile);
  static ClassType get(mlir::Type eleTy, bool isVolatile = false);
  static ClassType getChecked(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, mlir::Type eleTy, bool isVolatile = false);
  static ::llvm::LogicalResult verify(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, mlir::Type eleTy, bool isVolatile);
  static ::llvm::LogicalResult verifyInvariants(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, mlir::Type eleTy, bool isVolatile);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"class"};
  }

  static ::mlir::Type parse(::mlir::AsmParser &odsParser);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  mlir::Type getEleTy() const;
  bool getIsVolatile() const;
};
class FieldType : public ::mlir::Type::TypeBase<FieldType, ::mlir::Type, ::mlir::TypeStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "fir.field";
  static constexpr ::llvm::StringLiteral dialectName = "fir";
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"field"};
  }

};
namespace detail {

struct HeapTypeStorage;

} // namespace detail
class HeapType : public ::mlir::Type::TypeBase<HeapType, ::mlir::Type, detail::HeapTypeStorage> {
public:
  using Base::Base;
  mlir::Type getElementType() const { return getEleTy(); }
  static constexpr ::llvm::StringLiteral name = "fir.heap";
  static constexpr ::llvm::StringLiteral dialectName = "fir";
  using Base::getChecked;
  static HeapType get(mlir::Type elementType);
  static HeapType getChecked(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, mlir::Type elementType);
  static ::llvm::LogicalResult verify(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, mlir::Type eleTy);
  static ::llvm::LogicalResult verifyInvariants(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, mlir::Type eleTy);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"heap"};
  }

  static ::mlir::Type parse(::mlir::AsmParser &odsParser);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  mlir::Type getEleTy() const;
};
namespace detail {

struct IntegerTypeStorage;

} // namespace detail
class IntegerType : public ::mlir::Type::TypeBase<IntegerType, ::mlir::Type, detail::IntegerTypeStorage> {
public:
  using Base::Base;
  using KindTy = unsigned;
  static constexpr ::llvm::StringLiteral name = "fir.int";
  static constexpr ::llvm::StringLiteral dialectName = "fir";
  static IntegerType get(::mlir::MLIRContext *context, KindTy fKind);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"int"};
  }

  static ::mlir::Type parse(::mlir::AsmParser &odsParser);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  KindTy getFKind() const;
};
namespace detail {

struct UnsignedTypeStorage;

} // namespace detail
class UnsignedType : public ::mlir::Type::TypeBase<UnsignedType, ::mlir::Type, detail::UnsignedTypeStorage> {
public:
  using Base::Base;
  using KindTy = unsigned;
  static constexpr ::llvm::StringLiteral name = "fir.unsigned";
  static constexpr ::llvm::StringLiteral dialectName = "fir";
  static UnsignedType get(::mlir::MLIRContext *context, KindTy fKind);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"unsigned"};
  }

  static ::mlir::Type parse(::mlir::AsmParser &odsParser);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  KindTy getFKind() const;
};
class LenType : public ::mlir::Type::TypeBase<LenType, ::mlir::Type, ::mlir::TypeStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "fir.len";
  static constexpr ::llvm::StringLiteral dialectName = "fir";
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"len"};
  }

};
namespace detail {

struct LogicalTypeStorage;

} // namespace detail
class LogicalType : public ::mlir::Type::TypeBase<LogicalType, ::mlir::Type, detail::LogicalTypeStorage> {
public:
  using Base::Base;
  using KindTy = unsigned;
  static constexpr ::llvm::StringLiteral name = "fir.logical";
  static constexpr ::llvm::StringLiteral dialectName = "fir";
  static LogicalType get(::mlir::MLIRContext *context, KindTy fKind);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"logical"};
  }

  static ::mlir::Type parse(::mlir::AsmParser &odsParser);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  KindTy getFKind() const;
};
namespace detail {

struct LLVMPointerTypeStorage;

} // namespace detail
class LLVMPointerType : public ::mlir::Type::TypeBase<LLVMPointerType, ::mlir::Type, detail::LLVMPointerTypeStorage> {
public:
  using Base::Base;
  mlir::Type getElementType() const { return getEleTy(); }
  static constexpr ::llvm::StringLiteral name = "fir.llvm_ptr";
  static constexpr ::llvm::StringLiteral dialectName = "fir";
  static LLVMPointerType get(::mlir::MLIRContext *context, mlir::Type eleTy);
  static LLVMPointerType get(mlir::Type elementType);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"llvm_ptr"};
  }

  static ::mlir::Type parse(::mlir::AsmParser &odsParser);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  mlir::Type getEleTy() const;
};
namespace detail {

struct PointerTypeStorage;

} // namespace detail
class PointerType : public ::mlir::Type::TypeBase<PointerType, ::mlir::Type, detail::PointerTypeStorage> {
public:
  using Base::Base;
  mlir::Type getElementType() const { return getEleTy(); }
  static constexpr ::llvm::StringLiteral name = "fir.ptr";
  static constexpr ::llvm::StringLiteral dialectName = "fir";
  using Base::getChecked;
  static PointerType get(mlir::Type elementType);
  static PointerType getChecked(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, mlir::Type elementType);
  static ::llvm::LogicalResult verify(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, mlir::Type eleTy);
  static ::llvm::LogicalResult verifyInvariants(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, mlir::Type eleTy);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"ptr"};
  }

  static ::mlir::Type parse(::mlir::AsmParser &odsParser);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  mlir::Type getEleTy() const;
};
class RecordType : public ::mlir::Type::TypeBase<RecordType, ::mlir::Type, detail::RecordTypeStorage> {
public:
  using Base::Base;
  using TypePair = std::pair<std::string, mlir::Type>;
  using TypeList = llvm::ArrayRef<TypePair>;
  using TypeVector = llvm::SmallVector<TypePair>;
  TypeList getTypeList() const;
  TypeList getLenParamList() const;

  mlir::Type getType(llvm::StringRef ident);
  // Returns the index of the field \p ident in the type list.
  // Returns maximum unsigned if ident is not a field of this RecordType.
  unsigned getFieldIndex(llvm::StringRef ident);
  mlir::Type getType(unsigned index) {
    assert(index < getNumFields());
    return getTypeList()[index].second;
  }
  unsigned getNumFields() { return getTypeList().size(); }
  unsigned getNumLenParams() { return getLenParamList().size(); }
  bool isDependentType() { return getNumLenParams(); }

  bool isFinalized() const;
  void finalize(llvm::ArrayRef<TypePair> lenPList,
                llvm::ArrayRef<TypePair> typeList);

  // fir.type is unpacked by default. If the flag is set, the packed fir.type
  // is generated and the alignment is enforced by explicit padding by i8
  // array fields.
  bool isPacked() const;
  void pack(bool);

  detail::RecordTypeStorage const *uniqueKey() const;
  static constexpr ::llvm::StringLiteral name = "fir.type";
  static constexpr ::llvm::StringLiteral dialectName = "fir";
  using Base::getChecked;
  static RecordType get(::mlir::MLIRContext *context, ::llvm::StringRef name);
  static RecordType getChecked(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, ::mlir::MLIRContext *context, ::llvm::StringRef name);
  static ::llvm::LogicalResult verify(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, ::llvm::StringRef name);
  static ::llvm::LogicalResult verifyInvariants(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, ::llvm::StringRef name);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"type"};
  }

  static ::mlir::Type parse(::mlir::AsmParser &odsParser);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  ::llvm::StringRef getName() const;
};
namespace detail {

struct ReferenceTypeStorage;

} // namespace detail
class ReferenceType : public ::mlir::Type::TypeBase<ReferenceType, ::mlir::Type, detail::ReferenceTypeStorage> {
public:
  using Base::Base;
  mlir::Type getElementType() const { return getEleTy(); }
  bool isVolatile() const { return getIsVolatile(); }
  static constexpr ::llvm::StringLiteral name = "fir.ref";
  static constexpr ::llvm::StringLiteral dialectName = "fir";
  using Base::getChecked;
  static ReferenceType get(mlir::Type elementType, bool isVolatile = false);
  static ReferenceType getChecked(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, mlir::Type elementType, bool isVolatile = false);
  static ::llvm::LogicalResult verify(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, mlir::Type eleTy, bool isVolatile);
  static ::llvm::LogicalResult verifyInvariants(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, mlir::Type eleTy, bool isVolatile);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"ref"};
  }

  static ::mlir::Type parse(::mlir::AsmParser &odsParser);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  mlir::Type getEleTy() const;
  bool getIsVolatile() const;
};
namespace detail {

struct ShapeTypeStorage;

} // namespace detail
class ShapeType : public ::mlir::Type::TypeBase<ShapeType, ::mlir::Type, detail::ShapeTypeStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "fir.shape";
  static constexpr ::llvm::StringLiteral dialectName = "fir";
  static ShapeType get(::mlir::MLIRContext *context, unsigned rank);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"shape"};
  }

  static ::mlir::Type parse(::mlir::AsmParser &odsParser);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  unsigned getRank() const;
};
namespace detail {

struct ShapeShiftTypeStorage;

} // namespace detail
class ShapeShiftType : public ::mlir::Type::TypeBase<ShapeShiftType, ::mlir::Type, detail::ShapeShiftTypeStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "fir.shapeshift";
  static constexpr ::llvm::StringLiteral dialectName = "fir";
  static ShapeShiftType get(::mlir::MLIRContext *context, unsigned rank);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"shapeshift"};
  }

  static ::mlir::Type parse(::mlir::AsmParser &odsParser);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  unsigned getRank() const;
};
namespace detail {

struct ShiftTypeStorage;

} // namespace detail
class ShiftType : public ::mlir::Type::TypeBase<ShiftType, ::mlir::Type, detail::ShiftTypeStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "fir.shift";
  static constexpr ::llvm::StringLiteral dialectName = "fir";
  static ShiftType get(::mlir::MLIRContext *context, unsigned rank);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"shift"};
  }

  static ::mlir::Type parse(::mlir::AsmParser &odsParser);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  unsigned getRank() const;
};
namespace detail {

struct SequenceTypeStorage;

} // namespace detail
class SequenceType : public ::mlir::Type::TypeBase<SequenceType, ::mlir::Type, detail::SequenceTypeStorage> {
public:
  using Base::Base;
  using Extent = int64_t;
  using Shape = llvm::SmallVector<Extent>;
  using ShapeRef = llvm::ArrayRef<int64_t>;
  unsigned getConstantRows() const;

  // The number of dimensions of the sequence
  unsigned getDimension() const { return getShape().size(); }

  // Is the shape of the sequence dynamic?
  bool hasDynamicExtents() const {
    for(const auto d : getShape())
      if (d == getUnknownExtent())
        return true;
    return false;
  }

  // Does the sequence have unknown shape? (`array<* x T>`)
  bool hasUnknownShape() const { return getShape().empty(); }

  // The value `kDynamic` represents an unknown extent for a dimension
  static constexpr Extent getUnknownExtent() {
    return mlir::ShapedType::kDynamic;
  }

  std::uint64_t getConstantArraySize() {
    assert(!hasDynamicExtents() && "array type must have constant shape");
    std::uint64_t size = 1;
    for (Extent extent : getShape())
      size = size * static_cast<std::uint64_t>(extent);
    return size;
  }

  mlir::Type getElementType() const { return getEleTy(); }
  static constexpr ::llvm::StringLiteral name = "fir.array";
  static constexpr ::llvm::StringLiteral dialectName = "fir";
  using Base::getChecked;
  static SequenceType get(::mlir::MLIRContext *context, ::llvm::ArrayRef<int64_t> shape, mlir::Type eleTy, mlir::AffineMapAttr layoutMap);
  static SequenceType getChecked(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, ::mlir::MLIRContext *context, ::llvm::ArrayRef<int64_t> shape, mlir::Type eleTy, mlir::AffineMapAttr layoutMap);
  static SequenceType get(llvm::ArrayRef<int64_t> shape, mlir::Type eleTy);
  static SequenceType getChecked(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, llvm::ArrayRef<int64_t> shape, mlir::Type eleTy);
  static SequenceType get(mlir::Type eleTy, size_t dimensions);
  static SequenceType getChecked(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, mlir::Type eleTy, size_t dimensions);
  static ::llvm::LogicalResult verify(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, ::llvm::ArrayRef<int64_t> shape, mlir::Type eleTy, mlir::AffineMapAttr layoutMap);
  static ::llvm::LogicalResult verifyInvariants(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, ::llvm::ArrayRef<int64_t> shape, mlir::Type eleTy, mlir::AffineMapAttr layoutMap);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"array"};
  }

  static ::mlir::Type parse(::mlir::AsmParser &odsParser);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  ::llvm::ArrayRef<int64_t> getShape() const;
  mlir::Type getEleTy() const;
  mlir::AffineMapAttr getLayoutMap() const;
};
namespace detail {

struct SliceTypeStorage;

} // namespace detail
class SliceType : public ::mlir::Type::TypeBase<SliceType, ::mlir::Type, detail::SliceTypeStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "fir.slice";
  static constexpr ::llvm::StringLiteral dialectName = "fir";
  static SliceType get(::mlir::MLIRContext *context, unsigned rank);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"slice"};
  }

  static ::mlir::Type parse(::mlir::AsmParser &odsParser);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  unsigned getRank() const;
};
namespace detail {

struct TypeDescTypeStorage;

} // namespace detail
class TypeDescType : public ::mlir::Type::TypeBase<TypeDescType, ::mlir::Type, detail::TypeDescTypeStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "fir.tdesc";
  static constexpr ::llvm::StringLiteral dialectName = "fir";
  using Base::getChecked;
  static TypeDescType get(mlir::Type elementType);
  static TypeDescType getChecked(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, mlir::Type elementType);
  static ::llvm::LogicalResult verify(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, mlir::Type ofTy);
  static ::llvm::LogicalResult verifyInvariants(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, mlir::Type ofTy);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"tdesc"};
  }

  static ::mlir::Type parse(::mlir::AsmParser &odsParser);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  mlir::Type getOfTy() const;
};
namespace detail {

struct VectorTypeStorage;

} // namespace detail
class VectorType : public ::mlir::Type::TypeBase<VectorType, ::mlir::Type, detail::VectorTypeStorage> {
public:
  using Base::Base;
  static bool isValidElementType(mlir::Type t);

  mlir::Type getElementType() const { return getEleTy(); }
  static constexpr ::llvm::StringLiteral name = "fir.vector";
  static constexpr ::llvm::StringLiteral dialectName = "fir";
  using Base::getChecked;
  static VectorType get(uint64_t len, mlir::Type eleTy);
  static VectorType getChecked(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, uint64_t len, mlir::Type eleTy);
  static ::llvm::LogicalResult verify(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, uint64_t len, mlir::Type eleTy);
  static ::llvm::LogicalResult verifyInvariants(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, uint64_t len, mlir::Type eleTy);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"vector"};
  }

  static ::mlir::Type parse(::mlir::AsmParser &odsParser);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  uint64_t getLen() const;
  mlir::Type getEleTy() const;
};
class VoidType : public ::mlir::Type::TypeBase<VoidType, ::mlir::Type, ::mlir::TypeStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "fir.void";
  static constexpr ::llvm::StringLiteral dialectName = "fir";
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"void"};
  }

};
class DummyScopeType : public ::mlir::Type::TypeBase<DummyScopeType, ::mlir::Type, ::mlir::TypeStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "fir.dscope";
  static constexpr ::llvm::StringLiteral dialectName = "fir";
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"dscope"};
  }

};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::BoxCharType)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::BoxProcType)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::BoxType)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::CharacterType)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::ClassType)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::FieldType)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::HeapType)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::IntegerType)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::UnsignedType)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::LenType)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::LogicalType)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::LLVMPointerType)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::PointerType)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::RecordType)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::ReferenceType)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::ShapeType)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::ShapeShiftType)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::ShiftType)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::SequenceType)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::SliceType)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::TypeDescType)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::VectorType)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::VoidType)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::DummyScopeType)

#endif // GET_TYPEDEF_CLASSES

