// generated by Fast Light User Interface Designer (fluid) version 1.0404

#ifndef terminal_h
#define terminal_h
#include <FL/Fl.H>
#include <stdio.h>
#include <errno.h>
#include <FL/Fl_Window.H>
#include <FL/Fl_Terminal.H>
#include <FL/Fl_Scheme_Choice.H>
#include <FL/fl_ask.H>
#include <fcntl.h>
#ifdef _WIN32
#include <io.h> // _read()
#else
#include <unistd.h> // read()
#endif

/**
 Fl_Terminal derived class that can access ring buffer internals for debugging
*/
class MyTerminal : public Fl_Terminal {
  Fl_Double_Window *ring_debug_win;
  Fl_Terminal *debug_tty;
  bool interactivecursor;
public:
  MyTerminal(int X,int Y,int W,int H, const char *L=0);
  void show_ring_debug_window();
  void interactive_cursor(bool val);
  void debug_winquit_callback2();
  static void debug_winquit_callback(Fl_Widget*,void *userdata);
  void horiz_bracket(int w);
  void update_ring();
  void ring_debug_timer_callback2();
  static void ring_debug_timer_callback(void* userdata);
  int handle(int e) FL_OVERRIDE;
};
#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Spinner.H>
#include <FL/Fl_Choice.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Input.H>
#include <FL/Fl_Check_Button.H>
#include <FL/Fl_Group.H>
#include <FL/Fl_Button.H>

class Application {
  /**
   Line counter for +50 line test
  */
  int G_lines;
public:
  Application();
  void show(int argc=0, char **argv=0);
  void AppendTty(const char *s);
  static void NextEscapeTest(int dir);
  static int show_test(const char **test, int &index);
  static int test_firstpage(bool reset);
  static int test_esc_attr(bool reset);
  static int test_esc_rgbcolors(bool reset);
  static int test_esc_fgbg_colors(bool reset);
  static int test_esc_curpos(bool reset);
  static int test_esc_tabstops(bool reset);
  static int test_esc_insert_char(bool reset);
  static int test_esc_clear_test(bool reset);
  static int test_esc_delete_row(bool reset);
  static int test_esc_insert_row(bool reset);
  static int test_esc_scrolling(bool reset);
  void show_file(const char *filename);
  void speed_test();
  void show_colorbars();
  void unicode_alignment();
  void add_lines(int count);
  void do_command(const char *cmd);
  int parse_color(const char *val_str, Fl_Color &col);
  void update_inputs();
  void handle_output_translate(void);
  Fl_Double_Window* make_window();
  Fl_Double_Window *win;
private:
  inline void cb_win_i(Fl_Double_Window*, void*);
  static void cb_win(Fl_Double_Window*, void*);
public:
  Fl_Spinner *scrollhistory_input;
private:
  inline void cb_scrollhistory_input_i(Fl_Spinner*, void*);
  static void cb_scrollhistory_input(Fl_Spinner*, void*);
public:
  Fl_Spinner *fontsize_input;
private:
  inline void cb_fontsize_input_i(Fl_Spinner*, void*);
  static void cb_fontsize_input(Fl_Spinner*, void*);
public:
  Fl_Spinner *scrollbarsize_input;
private:
  inline void cb_scrollbarsize_input_i(Fl_Spinner*, void*);
  static void cb_scrollbarsize_input(Fl_Spinner*, void*);
public:
  Fl_Spinner *redraw_rate_spinner;
private:
  inline void cb_redraw_rate_spinner_i(Fl_Spinner*, void*);
  static void cb_redraw_rate_spinner(Fl_Spinner*, void*);
public:
  Fl_Scheme_Choice *scheme_widget;
  Fl_Choice *box_choice;
  static Fl_Menu_Item menu_box_choice[];
private:
  inline void cb_FL_UP_FRAME_i(Fl_Menu_*, long);
  static void cb_FL_UP_FRAME(Fl_Menu_*, long);
  inline void cb_FL_DOWN_FRAME_i(Fl_Menu_*, long);
  static void cb_FL_DOWN_FRAME(Fl_Menu_*, long);
  inline void cb_FL_THIN_UP_FRAME_i(Fl_Menu_*, long);
  static void cb_FL_THIN_UP_FRAME(Fl_Menu_*, long);
  inline void cb_FL_THIN_DOWN_FRAME_i(Fl_Menu_*, long);
  static void cb_FL_THIN_DOWN_FRAME(Fl_Menu_*, long);
  inline void cb_FL_ENGRAVED_FRAME_i(Fl_Menu_*, long);
  static void cb_FL_ENGRAVED_FRAME(Fl_Menu_*, long);
  inline void cb_FL_EMBOSSED_FRAME_i(Fl_Menu_*, long);
  static void cb_FL_EMBOSSED_FRAME(Fl_Menu_*, long);
  inline void cb_FL_BORDER_FRAME_i(Fl_Menu_*, long);
  static void cb_FL_BORDER_FRAME(Fl_Menu_*, long);
  inline void cb_FL_UP_BOX_i(Fl_Menu_*, long);
  static void cb_FL_UP_BOX(Fl_Menu_*, long);
  inline void cb_FL_DOWN_BOX_i(Fl_Menu_*, void*);
  static void cb_FL_DOWN_BOX(Fl_Menu_*, void*);
  inline void cb_FL_FLAT_BOX_i(Fl_Menu_*, void*);
  static void cb_FL_FLAT_BOX(Fl_Menu_*, void*);
  inline void cb_FL_THIN_UP_BOX_i(Fl_Menu_*, void*);
  static void cb_FL_THIN_UP_BOX(Fl_Menu_*, void*);
  inline void cb_FL_THIN_DOWN_BOX_i(Fl_Menu_*, void*);
  static void cb_FL_THIN_DOWN_BOX(Fl_Menu_*, void*);
  inline void cb_FL_BORDER_BOX_i(Fl_Menu_*, void*);
  static void cb_FL_BORDER_BOX(Fl_Menu_*, void*);
  inline void cb_FL_NO_BOX_i(Fl_Menu_*, void*);
  static void cb_FL_NO_BOX(Fl_Menu_*, void*);
public:
  Fl_Input *margins_input;
private:
  inline void cb_margins_input_i(Fl_Input*, void*);
  static void cb_margins_input(Fl_Input*, void*);
public:
  Fl_Check_Button *outflags_lf_to_crlf;
private:
  inline void cb_outflags_lf_to_crlf_i(Fl_Check_Button*, void*);
  static void cb_outflags_lf_to_crlf(Fl_Check_Button*, void*);
public:
  Fl_Check_Button *outflags_lf_to_cr;
private:
  inline void cb_outflags_lf_to_cr_i(Fl_Check_Button*, void*);
  static void cb_outflags_lf_to_cr(Fl_Check_Button*, void*);
public:
  Fl_Check_Button *outflags_cr_to_lf;
private:
  inline void cb_outflags_cr_to_lf_i(Fl_Check_Button*, void*);
  static void cb_outflags_cr_to_lf(Fl_Check_Button*, void*);
public:
  Fl_Check_Button *showunknown_radio;
private:
  inline void cb_showunknown_radio_i(Fl_Check_Button*, void*);
  static void cb_showunknown_radio(Fl_Check_Button*, void*);
public:
  Fl_Check_Button *interactivecursor_radio;
private:
  inline void cb_interactivecursor_radio_i(Fl_Check_Button*, void*);
  static void cb_interactivecursor_radio(Fl_Check_Button*, void*);
public:
  Fl_Check_Button *ansi_radio;
private:
  inline void cb_ansi_radio_i(Fl_Check_Button*, void*);
  static void cb_ansi_radio(Fl_Check_Button*, void*);
public:
  Fl_Check_Button *stdout_radio;
  Fl_Input *textcolor_input;
private:
  inline void cb_textcolor_input_i(Fl_Input*, void*);
  static void cb_textcolor_input(Fl_Input*, void*);
public:
  Fl_Input *textfgcolor_input;
private:
  inline void cb_textfgcolor_input_i(Fl_Input*, void*);
  static void cb_textfgcolor_input(Fl_Input*, void*);
public:
  Fl_Input *textfgcolor_default_input;
private:
  inline void cb_textfgcolor_default_input_i(Fl_Input*, void*);
  static void cb_textfgcolor_default_input(Fl_Input*, void*);
public:
  Fl_Input *cursorfgcolor_input;
private:
  inline void cb_cursorfgcolor_input_i(Fl_Input*, void*);
  static void cb_cursorfgcolor_input(Fl_Input*, void*);
public:
  Fl_Input *selectionfgcolor_input;
private:
  inline void cb_selectionfgcolor_input_i(Fl_Input*, void*);
  static void cb_selectionfgcolor_input(Fl_Input*, void*);
public:
  Fl_Input *color_input;
private:
  inline void cb_color_input_i(Fl_Input*, void*);
  static void cb_color_input(Fl_Input*, void*);
public:
  Fl_Input *textbgcolor_input;
private:
  inline void cb_textbgcolor_input_i(Fl_Input*, void*);
  static void cb_textbgcolor_input(Fl_Input*, void*);
public:
  Fl_Input *textbgcolor_default_input;
private:
  inline void cb_textbgcolor_default_input_i(Fl_Input*, void*);
  static void cb_textbgcolor_default_input(Fl_Input*, void*);
public:
  Fl_Input *cursorbgcolor_input;
private:
  inline void cb_cursorbgcolor_input_i(Fl_Input*, void*);
  static void cb_cursorbgcolor_input(Fl_Input*, void*);
public:
  Fl_Input *selectionbgcolor_input;
private:
  inline void cb_selectionbgcolor_input_i(Fl_Input*, void*);
  static void cb_selectionbgcolor_input(Fl_Input*, void*);
  static Fl_Menu_Item menu_Terminal[];
  inline void cb_White_i(Fl_Menu_*, void*);
  static void cb_White(Fl_Menu_*, void*);
  inline void cb_White1_i(Fl_Menu_*, void*);
  static void cb_White1(Fl_Menu_*, void*);
  inline void cb_White2_i(Fl_Menu_*, void*);
  static void cb_White2(Fl_Menu_*, void*);
  inline void cb_White3_i(Fl_Menu_*, void*);
  static void cb_White3(Fl_Menu_*, void*);
  inline void cb_Black_i(Fl_Menu_*, void*);
  static void cb_Black(Fl_Menu_*, void*);
  inline void cb_Green_i(Fl_Menu_*, void*);
  static void cb_Green(Fl_Menu_*, void*);
  inline void cb_Orange_i(Fl_Menu_*, void*);
  static void cb_Orange(Fl_Menu_*, void*);
  inline void cb_Reset_i(Fl_Button*, void*);
  static void cb_Reset(Fl_Button*, void*);
  inline void cb_Reset1_i(Fl_Button*, void*);
  static void cb_Reset1(Fl_Button*, void*);
  inline void cb_Home_i(Fl_Button*, void*);
  static void cb_Home(Fl_Button*, void*);
  inline void cb_Home1_i(Fl_Button*, void*);
  static void cb_Home1(Fl_Button*, void*);
  inline void cb_Clear_i(Fl_Button*, void*);
  static void cb_Clear(Fl_Button*, void*);
  inline void cb_Clear1_i(Fl_Button*, void*);
  static void cb_Clear1(Fl_Button*, void*);
  inline void cb_Clear2_i(Fl_Button*, void*);
  static void cb_Clear2(Fl_Button*, void*);
  inline void cb_Clear3_i(Fl_Button*, void*);
  static void cb_Clear3(Fl_Button*, void*);
  inline void cb_Clear4_i(Fl_Button*, void*);
  static void cb_Clear4(Fl_Button*, void*);
public:
  Fl_Input *clear_color_input;
private:
  inline void cb_Speed_i(Fl_Button*, void*);
  static void cb_Speed(Fl_Button*, void*);
  inline void cb_Ring_i(Fl_Button*, void*);
  static void cb_Ring(Fl_Button*, void*);
  inline void cb_Unicode_i(Fl_Button*, void*);
  static void cb_Unicode(Fl_Button*, void*);
  inline void cb_50_i(Fl_Button*, void*);
  static void cb_50(Fl_Button*, void*);
  inline void cb_Color_i(Fl_Button*, void*);
  static void cb_Color(Fl_Button*, void*);
  inline void cb__i(Fl_Button*, void*);
  static void cb_(Fl_Button*, void*);
  inline void cb_1_i(Fl_Button*, void*);
  static void cb_1(Fl_Button*, void*);
public:
  Fl_Input *showfile_input;
private:
  inline void cb_showfile_input_i(Fl_Input*, void*);
  static void cb_showfile_input(Fl_Input*, void*);
public:
  Fl_Input *command_input;
private:
  inline void cb_command_input_i(Fl_Input*, void*);
  static void cb_command_input(Fl_Input*, void*);
public:
  MyTerminal *tty;
};
#endif
