/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.nc.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import org.flywaydb.core.api.FlywayException;

public class TemporaryFileUtils {
    public static String createTempFile(String sqlContent) {
        return TemporaryFileUtils.createTempFile(sqlContent, ".sql");
    }

    public static String createTempFile(String sqlContent, String suffix) {
        try {
            File tempFile = File.createTempFile("temp_sql_", suffix);
            tempFile.deleteOnExit();
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(tempFile));){
                writer.write(sqlContent);
            }
            return tempFile.getAbsolutePath();
        }
        catch (Exception e) {
            throw new FlywayException("Failed to write SQL file due to: " + e.getMessage(), (Throwable)e);
        }
    }
}

