/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.executor.etree.hash;

import com.databricks.client.dsi.dataengine.interfaces.IColumn;
import com.databricks.client.sqlengine.executor.etree.hash.HashAggrPartition;
import com.databricks.client.sqlengine.executor.etree.hash.HashPartitionProperties;
import com.databricks.client.sqlengine.executor.etree.relation.join.IHasher;
import com.databricks.client.sqlengine.executor.etree.temptable.IRowView;
import com.databricks.client.sqlengine.executor.etree.temptable.InMemTable;
import com.databricks.client.sqlengine.executor.etree.temptable.TemporaryFile;
import com.databricks.client.sqlengine.utilities.ExternalAlgorithmUtil;
import com.databricks.client.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class HashAggrPartitionManager {
    private List<HashAggrPartition> m_partitions;
    private IHasher m_hash;
    private HashPartitionProperties m_properties;
    private TemporaryFile m_longDataStore;
    private boolean[] m_longDataColumns;
    private IColumn[] m_scalarMetadata;

    public HashAggrPartitionManager(int n, TemporaryFile temporaryFile, boolean[] blArray, HashPartitionProperties hashPartitionProperties, boolean[] blArray2) throws ErrorException {
        assert (n >= 1);
        this.m_hash = hashPartitionProperties.getHashFactory().nextHasher(Long.MAX_VALUE);
        this.m_longDataStore = temporaryFile;
        this.m_longDataColumns = blArray;
        this.m_properties = hashPartitionProperties;
        int[] nArray = hashPartitionProperties.getOperandProjection().getScalarValueColumns();
        this.m_scalarMetadata = new IColumn[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            this.m_scalarMetadata[i] = hashPartitionProperties.getOperandProjection().getMetadata()[i];
        }
        this.createPartitions(n);
    }

    private void createPartitions(int n) throws ErrorException {
        IHasher iHasher = this.m_properties.getHashFactory().nextHasher(Long.MAX_VALUE);
        boolean[] blArray = new boolean[this.m_scalarMetadata.length];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = true;
        }
        long l = Math.max(ExternalAlgorithmUtil.calculateRowSize(Arrays.asList(this.m_scalarMetadata), blArray, this.m_properties.getMaxDataLen()), 1L);
        ExternalAlgorithmUtil.ExternalAlgorithmProperties externalAlgorithmProperties = this.m_properties.getExternalAlgorithmProperties();
        int n2 = 1 + (int)(0.1 * (double)externalAlgorithmProperties.getBlockSize() / (double)l);
        ArrayList<HashAggrPartition> arrayList = new ArrayList<HashAggrPartition>(n);
        for (int i = 0; i < n; ++i) {
            InMemTable inMemTable = new InMemTable(this.m_scalarMetadata, this.m_properties.getMaxDataLen(), n2, blArray, this.m_properties.getLogger());
            inMemTable.setMemLimit(Long.MAX_VALUE);
            arrayList.add(new HashAggrPartition(iHasher, this.m_longDataColumns, blArray, this.m_longDataStore, this.m_scalarMetadata, inMemTable, this.m_properties));
        }
        this.m_partitions = arrayList;
    }

    public int getNumPartitions() {
        return this.m_partitions.size();
    }

    public int partition(IRowView iRowView) {
        long l = this.m_hash.hash(iRowView, this.m_properties.getOperandProjection().getGroupingColumns());
        return (int)(l % (long)this.m_partitions.size());
    }

    public HashAggrPartition getPartition(IRowView iRowView) {
        return this.getPartition(this.partition(iRowView));
    }

    public HashAggrPartition getPartition(int n) {
        return this.m_partitions.get(n);
    }
}

