/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.grpc.multiendpoint;

import com.google.cloud.grpc.multiendpoint.MultiEndpoint;
import com.google.errorprone.annotations.CheckReturnValue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

@CheckReturnValue
final class Endpoint {
    private final String id;
    private EndpointState state;
    private long lastStateChangeNano;
    private int priority;
    private ScheduledFuture<?> changeStateFuture;
    private final MultiEndpoint multiEndpoint;

    Endpoint(String id, EndpointState state, int priority, MultiEndpoint multiEndpoint) {
        this.id = id;
        this.priority = priority;
        this.multiEndpoint = multiEndpoint;
        this.setAvailability(EndpointState.AVAILABLE.equals((Object)state));
    }

    public String getId() {
        return this.id;
    }

    public EndpointState getState() {
        return this.state;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(EndpointState state) {
        MultiEndpoint multiEndpoint = this.multiEndpoint;
        synchronized (multiEndpoint) {
            if (this.changeStateFuture != null) {
                this.changeStateFuture.cancel(false);
            }
            this.state = state;
            this.lastStateChangeNano = System.nanoTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAvailability(boolean available) {
        MultiEndpoint multiEndpoint = this.multiEndpoint;
        synchronized (multiEndpoint) {
            if (available) {
                this.setState(EndpointState.AVAILABLE);
                return;
            }
            if (this.state != null && !EndpointState.AVAILABLE.equals((Object)this.state)) {
                return;
            }
            if (!this.multiEndpoint.isRecoveryEnabled()) {
                this.setState(EndpointState.UNAVAILABLE);
                return;
            }
            this.setState(EndpointState.RECOVERING);
            long stateChangeNano = this.lastStateChangeNano;
            this.changeStateFuture = this.multiEndpoint.executor.schedule(() -> this.triggerRecoveryTimeout(stateChangeNano), this.multiEndpoint.getRecoveryTimeout().toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerRecoveryTimeout(long statusChangeNano) {
        MultiEndpoint multiEndpoint = this.multiEndpoint;
        synchronized (multiEndpoint) {
            if (this.lastStateChangeNano != statusChangeNano) {
                return;
            }
            this.setState(EndpointState.UNAVAILABLE);
            this.multiEndpoint.maybeUpdateCurrentEndpoint();
        }
    }

    public String toString() {
        return "Endpoint{id='" + this.id + "', state=" + (Object)((Object)this.state) + ", lastStateChangeNano=" + this.lastStateChangeNano + ", priority=" + this.priority + ", changeStateFuture=" + this.changeStateFuture + '}';
    }

    public static enum EndpointState {
        UNAVAILABLE,
        AVAILABLE,
        RECOVERING;

    }
}

