/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.sql.DataSource;
import org.firebirdsql.ds.RootCommonDataSource;
import org.firebirdsql.jca.FBConnectionRequestInfo;
import org.firebirdsql.jca.FBManagedConnectionFactory;
import org.firebirdsql.jdbc.FBSQLException;

public class FBDataSource
extends RootCommonDataSource
implements DataSource,
Serializable,
Referenceable {
    private static final long serialVersionUID = 1178461472062969634L;
    private final ConnectionManager cm;
    private final FBManagedConnectionFactory mcf;
    private Reference jndiReference;
    private int loginTimeout = 0;

    public FBDataSource(ManagedConnectionFactory mcf, ConnectionManager cm) {
        this((FBManagedConnectionFactory)mcf, cm);
    }

    public FBDataSource(FBManagedConnectionFactory mcf, ConnectionManager cm) {
        this.mcf = mcf;
        this.cm = cm;
    }

    public void setReference(Reference ref) {
        this.jndiReference = ref;
    }

    public Reference getReference() {
        return this.jndiReference;
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            return (Connection)this.cm.allocateConnection((ManagedConnectionFactory)this.mcf, (ConnectionRequestInfo)this.mcf.getDefaultConnectionRequestInfo());
        }
        catch (ResourceException re) {
            if (re.getCause() instanceof SQLException) {
                throw (SQLException)re.getCause();
            }
            if (re.getLinkedException() instanceof SQLException) {
                throw (SQLException)re.getLinkedException();
            }
            throw new FBSQLException(re);
        }
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        try {
            FBConnectionRequestInfo subjectCri = this.mcf.getDefaultConnectionRequestInfo();
            subjectCri.setUserName(username);
            subjectCri.setPassword(password);
            return (Connection)this.cm.allocateConnection((ManagedConnectionFactory)this.mcf, (ConnectionRequestInfo)subjectCri);
        }
        catch (ResourceException re) {
            if (re.getCause() instanceof SQLException) {
                throw (SQLException)re.getCause();
            }
            if (re.getLinkedException() instanceof SQLException) {
                throw (SQLException)re.getLinkedException();
            }
            throw new FBSQLException(re);
        }
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout = seconds;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new SQLException("Unable to unwrap to class " + iface.getName());
        }
        return iface.cast(this);
    }
}

