/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.rpc.UnavailableException;
import com.google.common.base.Predicate;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;

class IsChannelShutdownException
implements Predicate<Throwable> {
    IsChannelShutdownException() {
    }

    public boolean apply(Throwable input) {
        Throwable cause = input;
        do {
            if (!this.isUnavailableError(cause) || !cause.getMessage().contains("Channel shutdown invoked") && !cause.getMessage().contains("Channel shutdownNow invoked")) continue;
            return true;
        } while ((cause = cause.getCause()) != null);
        return false;
    }

    private boolean isUnavailableError(Throwable cause) {
        return cause instanceof UnavailableException || cause instanceof StatusRuntimeException && ((StatusRuntimeException)cause).getStatus().getCode() == Status.Code.UNAVAILABLE;
    }
}

