/**
 * This file was automatically generated by json-schema-to-typescript.
 * DO NOT MODIFY IT BY HAND. Instead, modify the source JSONSchema file,
 * and run json-schema-to-typescript to regenerate this file.
 */
/**
 * A discriminated union of all standard JSON-RPC and A2A-specific error types.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "A2AError".
 */
type A2AError = JSONParseError | InvalidRequestError | MethodNotFoundError | InvalidParamsError | InternalError | TaskNotFoundError | TaskNotCancelableError | PushNotificationNotSupportedError | UnsupportedOperationError | ContentTypeNotSupportedError | InvalidAgentResponseError | AuthenticatedExtendedCardNotConfiguredError;
/**
 * A discriminated union representing all possible JSON-RPC 2.0 requests supported by the A2A specification.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "A2ARequest".
 */
type A2ARequest = SendMessageRequest | SendStreamingMessageRequest | GetTaskRequest | CancelTaskRequest | SetTaskPushNotificationConfigRequest | GetTaskPushNotificationConfigRequest | TaskResubscriptionRequest | ListTaskPushNotificationConfigRequest | DeleteTaskPushNotificationConfigRequest | GetAuthenticatedExtendedCardRequest;
/**
 * A discriminated union representing a part of a message or artifact, which can
 * be text, a file, or structured data.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "Part".
 */
type Part = TextPart | FilePart | DataPart;
/**
 * Defines a security scheme that can be used to secure an agent's endpoints.
 * This is a discriminated union type based on the OpenAPI 3.0 Security Scheme Object.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "SecurityScheme".
 */
type SecurityScheme = APIKeySecurityScheme | HTTPAuthSecurityScheme | OAuth2SecurityScheme | OpenIdConnectSecurityScheme | MutualTLSSecurityScheme;
/**
 * Represents a JSON-RPC response for the `tasks/cancel` method.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "CancelTaskResponse".
 */
type CancelTaskResponse = JSONRPCErrorResponse | CancelTaskSuccessResponse;
/**
 * Represents a JSON-RPC response for the `tasks/pushNotificationConfig/delete` method.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "DeleteTaskPushNotificationConfigResponse".
 */
type DeleteTaskPushNotificationConfigResponse = JSONRPCErrorResponse | DeleteTaskPushNotificationConfigSuccessResponse;
/**
 * Represents a JSON-RPC response for the `agent/getAuthenticatedExtendedCard` method.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "GetAuthenticatedExtendedCardResponse".
 */
type GetAuthenticatedExtendedCardResponse = JSONRPCErrorResponse | GetAuthenticatedExtendedCardSuccessResponse;
/**
 * Represents a JSON-RPC response for the `tasks/pushNotificationConfig/get` method.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "GetTaskPushNotificationConfigResponse".
 */
type GetTaskPushNotificationConfigResponse = JSONRPCErrorResponse | GetTaskPushNotificationConfigSuccessResponse;
/**
 * Represents a JSON-RPC response for the `tasks/get` method.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "GetTaskResponse".
 */
type GetTaskResponse = JSONRPCErrorResponse | GetTaskSuccessResponse;
/**
 * A discriminated union representing all possible JSON-RPC 2.0 responses
 * for the A2A specification methods.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "JSONRPCResponse".
 */
type JSONRPCResponse = JSONRPCErrorResponse | SendMessageSuccessResponse | SendStreamingMessageSuccessResponse | GetTaskSuccessResponse | CancelTaskSuccessResponse | SetTaskPushNotificationConfigSuccessResponse | GetTaskPushNotificationConfigSuccessResponse | ListTaskPushNotificationConfigSuccessResponse | DeleteTaskPushNotificationConfigSuccessResponse | GetAuthenticatedExtendedCardSuccessResponse;
/**
 * Represents a JSON-RPC response for the `tasks/pushNotificationConfig/list` method.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "ListTaskPushNotificationConfigResponse".
 */
type ListTaskPushNotificationConfigResponse = JSONRPCErrorResponse | ListTaskPushNotificationConfigSuccessResponse;
/**
 * Represents a JSON-RPC response for the `message/send` method.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "SendMessageResponse".
 */
type SendMessageResponse = JSONRPCErrorResponse | SendMessageSuccessResponse;
/**
 * Represents a JSON-RPC response for the `message/stream` method.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "SendStreamingMessageResponse".
 */
type SendStreamingMessageResponse = JSONRPCErrorResponse | SendStreamingMessageSuccessResponse;
/**
 * Represents a JSON-RPC response for the `tasks/pushNotificationConfig/set` method.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "SetTaskPushNotificationConfigResponse".
 */
type SetTaskPushNotificationConfigResponse = JSONRPCErrorResponse | SetTaskPushNotificationConfigSuccessResponse;
/**
 * Defines the lifecycle states of a Task.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "TaskState".
 */
type TaskState = "submitted" | "working" | "input-required" | "completed" | "canceled" | "failed" | "rejected" | "auth-required" | "unknown";
/**
 * Supported A2A transport protocols.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "TransportProtocol".
 */
type TransportProtocol = "JSONRPC" | "GRPC" | "HTTP+JSON";
interface MySchema {
    [k: string]: unknown;
}
/**
 * An error indicating that the server received invalid JSON.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "JSONParseError".
 */
interface JSONParseError {
    /**
     * The error code for a JSON parse error.
     */
    code: -32700;
    /**
     * A primitive or structured value containing additional information about the error.
     * This may be omitted.
     */
    data?: {
        [k: string]: unknown;
    };
    /**
     * The error message.
     */
    message: string;
}
/**
 * An error indicating that the JSON sent is not a valid Request object.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "InvalidRequestError".
 */
interface InvalidRequestError {
    /**
     * The error code for an invalid request.
     */
    code: -32600;
    /**
     * A primitive or structured value containing additional information about the error.
     * This may be omitted.
     */
    data?: {
        [k: string]: unknown;
    };
    /**
     * The error message.
     */
    message: string;
}
/**
 * An error indicating that the requested method does not exist or is not available.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "MethodNotFoundError".
 */
interface MethodNotFoundError {
    /**
     * The error code for a method not found error.
     */
    code: -32601;
    /**
     * A primitive or structured value containing additional information about the error.
     * This may be omitted.
     */
    data?: {
        [k: string]: unknown;
    };
    /**
     * The error message.
     */
    message: string;
}
/**
 * An error indicating that the method parameters are invalid.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "InvalidParamsError".
 */
interface InvalidParamsError {
    /**
     * The error code for an invalid parameters error.
     */
    code: -32602;
    /**
     * A primitive or structured value containing additional information about the error.
     * This may be omitted.
     */
    data?: {
        [k: string]: unknown;
    };
    /**
     * The error message.
     */
    message: string;
}
/**
 * An error indicating an internal error on the server.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "InternalError".
 */
interface InternalError {
    /**
     * The error code for an internal server error.
     */
    code: -32603;
    /**
     * A primitive or structured value containing additional information about the error.
     * This may be omitted.
     */
    data?: {
        [k: string]: unknown;
    };
    /**
     * The error message.
     */
    message: string;
}
/**
 * An A2A-specific error indicating that the requested task ID was not found.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "TaskNotFoundError".
 */
interface TaskNotFoundError {
    /**
     * The error code for a task not found error.
     */
    code: -32001;
    /**
     * A primitive or structured value containing additional information about the error.
     * This may be omitted.
     */
    data?: {
        [k: string]: unknown;
    };
    /**
     * The error message.
     */
    message: string;
}
/**
 * An A2A-specific error indicating that the task is in a state where it cannot be canceled.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "TaskNotCancelableError".
 */
interface TaskNotCancelableError {
    /**
     * The error code for a task that cannot be canceled.
     */
    code: -32002;
    /**
     * A primitive or structured value containing additional information about the error.
     * This may be omitted.
     */
    data?: {
        [k: string]: unknown;
    };
    /**
     * The error message.
     */
    message: string;
}
/**
 * An A2A-specific error indicating that the agent does not support push notifications.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "PushNotificationNotSupportedError".
 */
interface PushNotificationNotSupportedError {
    /**
     * The error code for when push notifications are not supported.
     */
    code: -32003;
    /**
     * A primitive or structured value containing additional information about the error.
     * This may be omitted.
     */
    data?: {
        [k: string]: unknown;
    };
    /**
     * The error message.
     */
    message: string;
}
/**
 * An A2A-specific error indicating that the requested operation is not supported by the agent.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "UnsupportedOperationError".
 */
interface UnsupportedOperationError {
    /**
     * The error code for an unsupported operation.
     */
    code: -32004;
    /**
     * A primitive or structured value containing additional information about the error.
     * This may be omitted.
     */
    data?: {
        [k: string]: unknown;
    };
    /**
     * The error message.
     */
    message: string;
}
/**
 * An A2A-specific error indicating an incompatibility between the requested
 * content types and the agent's capabilities.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "ContentTypeNotSupportedError".
 */
interface ContentTypeNotSupportedError {
    /**
     * The error code for an unsupported content type.
     */
    code: -32005;
    /**
     * A primitive or structured value containing additional information about the error.
     * This may be omitted.
     */
    data?: {
        [k: string]: unknown;
    };
    /**
     * The error message.
     */
    message: string;
}
/**
 * An A2A-specific error indicating that the agent returned a response that
 * does not conform to the specification for the current method.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "InvalidAgentResponseError".
 */
interface InvalidAgentResponseError {
    /**
     * The error code for an invalid agent response.
     */
    code: -32006;
    /**
     * A primitive or structured value containing additional information about the error.
     * This may be omitted.
     */
    data?: {
        [k: string]: unknown;
    };
    /**
     * The error message.
     */
    message: string;
}
/**
 * An A2A-specific error indicating that the agent does not have an Authenticated Extended Card configured
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "AuthenticatedExtendedCardNotConfiguredError".
 */
interface AuthenticatedExtendedCardNotConfiguredError {
    /**
     * The error code for when an authenticated extended card is not configured.
     */
    code: -32007;
    /**
     * A primitive or structured value containing additional information about the error.
     * This may be omitted.
     */
    data?: {
        [k: string]: unknown;
    };
    /**
     * The error message.
     */
    message: string;
}
/**
 * Represents a JSON-RPC request for the `message/send` method.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "SendMessageRequest".
 */
interface SendMessageRequest {
    /**
     * The identifier for this request.
     */
    id: string | number;
    /**
     * The version of the JSON-RPC protocol. MUST be exactly "2.0".
     */
    jsonrpc: "2.0";
    /**
     * The method name. Must be 'message/send'.
     */
    method: "message/send";
    params: MessageSendParams;
}
/**
 * The parameters for sending a message.
 */
interface MessageSendParams {
    configuration?: MessageSendConfiguration;
    message: Message;
    /**
     * Optional metadata for extensions.
     */
    metadata?: {
        [k: string]: unknown;
    };
}
/**
 * Optional configuration for the send request.
 */
interface MessageSendConfiguration {
    /**
     * A list of output MIME types the client is prepared to accept in the response.
     */
    acceptedOutputModes?: string[];
    /**
     * If true, the client will wait for the task to complete. The server may reject this if the task is long-running.
     */
    blocking?: boolean;
    /**
     * The number of most recent messages from the task's history to retrieve in the response.
     */
    historyLength?: number;
    pushNotificationConfig?: PushNotificationConfig;
}
/**
 * Configuration for the agent to send push notifications for updates after the initial response.
 */
interface PushNotificationConfig {
    authentication?: PushNotificationAuthenticationInfo;
    /**
     * A unique ID for the push notification configuration, set by the client
     * to support multiple notification callbacks.
     */
    id?: string;
    /**
     * A unique token for this task or session to validate incoming push notifications.
     */
    token?: string;
    /**
     * The callback URL where the agent should send push notifications.
     */
    url: string;
}
/**
 * Optional authentication details for the agent to use when calling the notification URL.
 */
interface PushNotificationAuthenticationInfo {
    /**
     * Optional credentials required by the push notification endpoint.
     */
    credentials?: string;
    /**
     * A list of supported authentication schemes (e.g., 'Basic', 'Bearer').
     */
    schemes: string[];
}
/**
 * The message object being sent to the agent.
 */
interface Message {
    /**
     * The context identifier for this message, used to group related interactions.
     */
    contextId?: string;
    /**
     * The URIs of extensions that are relevant to this message.
     */
    extensions?: string[];
    /**
     * The type of this object, used as a discriminator. Always 'message' for a Message.
     */
    kind: "message";
    /**
     * A unique identifier for the message, typically a UUID, generated by the sender.
     */
    messageId: string;
    /**
     * Optional metadata for extensions. The key is an extension-specific identifier.
     */
    metadata?: {
        [k: string]: unknown;
    };
    /**
     * An array of content parts that form the message body. A message can be
     * composed of multiple parts of different types (e.g., text and files).
     */
    parts: Part[];
    /**
     * A list of other task IDs that this message references for additional context.
     */
    referenceTaskIds?: string[];
    /**
     * Identifies the sender of the message. `user` for the client, `agent` for the service.
     */
    role: "agent" | "user";
    /**
     * The identifier of the task this message is part of. Can be omitted for the first message of a new task.
     */
    taskId?: string;
}
/**
 * Represents a text segment within a message or artifact.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "TextPart".
 */
interface TextPart {
    /**
     * The type of this part, used as a discriminator. Always 'text'.
     */
    kind: "text";
    /**
     * Optional metadata associated with this part.
     */
    metadata?: {
        [k: string]: unknown;
    };
    /**
     * The string content of the text part.
     */
    text: string;
}
/**
 * Represents a file segment within a message or artifact. The file content can be
 * provided either directly as bytes or as a URI.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "FilePart".
 */
interface FilePart {
    /**
     * The file content, represented as either a URI or as base64-encoded bytes.
     */
    file: FileWithBytes | FileWithUri;
    /**
     * The type of this part, used as a discriminator. Always 'file'.
     */
    kind: "file";
    /**
     * Optional metadata associated with this part.
     */
    metadata?: {
        [k: string]: unknown;
    };
}
/**
 * Represents a file with its content provided directly as a base64-encoded string.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "FileWithBytes".
 */
interface FileWithBytes {
    /**
     * The base64-encoded content of the file.
     */
    bytes: string;
    /**
     * The MIME type of the file (e.g., "application/pdf").
     */
    mimeType?: string;
    /**
     * An optional name for the file (e.g., "document.pdf").
     */
    name?: string;
}
/**
 * Represents a file with its content located at a specific URI.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "FileWithUri".
 */
interface FileWithUri {
    /**
     * The MIME type of the file (e.g., "application/pdf").
     */
    mimeType?: string;
    /**
     * An optional name for the file (e.g., "document.pdf").
     */
    name?: string;
    /**
     * A URL pointing to the file's content.
     */
    uri: string;
}
/**
 * Represents a structured data segment (e.g., JSON) within a message or artifact.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "DataPart".
 */
interface DataPart {
    /**
     * The structured data content.
     */
    data: {
        [k: string]: unknown;
    };
    /**
     * The type of this part, used as a discriminator. Always 'data'.
     */
    kind: "data";
    /**
     * Optional metadata associated with this part.
     */
    metadata?: {
        [k: string]: unknown;
    };
}
/**
 * Represents a JSON-RPC request for the `message/stream` method.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "SendStreamingMessageRequest".
 */
interface SendStreamingMessageRequest {
    /**
     * The identifier for this request.
     */
    id: string | number;
    /**
     * The version of the JSON-RPC protocol. MUST be exactly "2.0".
     */
    jsonrpc: "2.0";
    /**
     * The method name. Must be 'message/stream'.
     */
    method: "message/stream";
    params: MessageSendParams1;
}
/**
 * The parameters for sending a message.
 */
interface MessageSendParams1 {
    configuration?: MessageSendConfiguration;
    message: Message;
    /**
     * Optional metadata for extensions.
     */
    metadata?: {
        [k: string]: unknown;
    };
}
/**
 * Represents a JSON-RPC request for the `tasks/get` method.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "GetTaskRequest".
 */
interface GetTaskRequest {
    /**
     * The identifier for this request.
     */
    id: string | number;
    /**
     * The version of the JSON-RPC protocol. MUST be exactly "2.0".
     */
    jsonrpc: "2.0";
    /**
     * The method name. Must be 'tasks/get'.
     */
    method: "tasks/get";
    params: TaskQueryParams;
}
/**
 * The parameters for querying a task.
 */
interface TaskQueryParams {
    /**
     * The number of most recent messages from the task's history to retrieve.
     */
    historyLength?: number;
    /**
     * The unique identifier of the task.
     */
    id: string;
    /**
     * Optional metadata associated with the request.
     */
    metadata?: {
        [k: string]: unknown;
    };
}
/**
 * Represents a JSON-RPC request for the `tasks/cancel` method.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "CancelTaskRequest".
 */
interface CancelTaskRequest {
    /**
     * The identifier for this request.
     */
    id: string | number;
    /**
     * The version of the JSON-RPC protocol. MUST be exactly "2.0".
     */
    jsonrpc: "2.0";
    /**
     * The method name. Must be 'tasks/cancel'.
     */
    method: "tasks/cancel";
    params: TaskIdParams;
}
/**
 * The parameters identifying the task to cancel.
 */
interface TaskIdParams {
    /**
     * The unique identifier of the task.
     */
    id: string;
    /**
     * Optional metadata associated with the request.
     */
    metadata?: {
        [k: string]: unknown;
    };
}
/**
 * Represents a JSON-RPC request for the `tasks/pushNotificationConfig/set` method.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "SetTaskPushNotificationConfigRequest".
 */
interface SetTaskPushNotificationConfigRequest {
    /**
     * The identifier for this request.
     */
    id: string | number;
    /**
     * The version of the JSON-RPC protocol. MUST be exactly "2.0".
     */
    jsonrpc: "2.0";
    /**
     * The method name. Must be 'tasks/pushNotificationConfig/set'.
     */
    method: "tasks/pushNotificationConfig/set";
    params: TaskPushNotificationConfig;
}
/**
 * The parameters for setting the push notification configuration.
 */
interface TaskPushNotificationConfig {
    pushNotificationConfig: PushNotificationConfig1;
    /**
     * The ID of the task.
     */
    taskId: string;
}
/**
 * The push notification configuration for this task.
 */
interface PushNotificationConfig1 {
    authentication?: PushNotificationAuthenticationInfo;
    /**
     * A unique ID for the push notification configuration, set by the client
     * to support multiple notification callbacks.
     */
    id?: string;
    /**
     * A unique token for this task or session to validate incoming push notifications.
     */
    token?: string;
    /**
     * The callback URL where the agent should send push notifications.
     */
    url: string;
}
/**
 * Represents a JSON-RPC request for the `tasks/pushNotificationConfig/get` method.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "GetTaskPushNotificationConfigRequest".
 */
interface GetTaskPushNotificationConfigRequest {
    /**
     * The identifier for this request.
     */
    id: string | number;
    /**
     * The version of the JSON-RPC protocol. MUST be exactly "2.0".
     */
    jsonrpc: "2.0";
    /**
     * The method name. Must be 'tasks/pushNotificationConfig/get'.
     */
    method: "tasks/pushNotificationConfig/get";
    /**
     * The parameters for getting a push notification configuration.
     */
    params: TaskIdParams1 | GetTaskPushNotificationConfigParams;
}
/**
 * Defines parameters containing a task ID, used for simple task operations.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "TaskIdParams".
 */
interface TaskIdParams1 {
    /**
     * The unique identifier of the task.
     */
    id: string;
    /**
     * Optional metadata associated with the request.
     */
    metadata?: {
        [k: string]: unknown;
    };
}
/**
 * Defines parameters for fetching a specific push notification configuration for a task.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "GetTaskPushNotificationConfigParams".
 */
interface GetTaskPushNotificationConfigParams {
    /**
     * The unique identifier of the task.
     */
    id: string;
    /**
     * Optional metadata associated with the request.
     */
    metadata?: {
        [k: string]: unknown;
    };
    /**
     * The ID of the push notification configuration to retrieve.
     */
    pushNotificationConfigId?: string;
}
/**
 * Represents a JSON-RPC request for the `tasks/resubscribe` method, used to resume a streaming connection.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "TaskResubscriptionRequest".
 */
interface TaskResubscriptionRequest {
    /**
     * The identifier for this request.
     */
    id: string | number;
    /**
     * The version of the JSON-RPC protocol. MUST be exactly "2.0".
     */
    jsonrpc: "2.0";
    /**
     * The method name. Must be 'tasks/resubscribe'.
     */
    method: "tasks/resubscribe";
    params: TaskIdParams2;
}
/**
 * Defines parameters containing a task ID, used for simple task operations.
 */
interface TaskIdParams2 {
    /**
     * The unique identifier of the task.
     */
    id: string;
    /**
     * Optional metadata associated with the request.
     */
    metadata?: {
        [k: string]: unknown;
    };
}
/**
 * Represents a JSON-RPC request for the `tasks/pushNotificationConfig/list` method.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "ListTaskPushNotificationConfigRequest".
 */
interface ListTaskPushNotificationConfigRequest {
    /**
     * The identifier for this request.
     */
    id: string | number;
    /**
     * The version of the JSON-RPC protocol. MUST be exactly "2.0".
     */
    jsonrpc: "2.0";
    /**
     * The method name. Must be 'tasks/pushNotificationConfig/list'.
     */
    method: "tasks/pushNotificationConfig/list";
    params: ListTaskPushNotificationConfigParams;
}
/**
 * The parameters identifying the task whose configurations are to be listed.
 */
interface ListTaskPushNotificationConfigParams {
    /**
     * The unique identifier of the task.
     */
    id: string;
    /**
     * Optional metadata associated with the request.
     */
    metadata?: {
        [k: string]: unknown;
    };
}
/**
 * Represents a JSON-RPC request for the `tasks/pushNotificationConfig/delete` method.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "DeleteTaskPushNotificationConfigRequest".
 */
interface DeleteTaskPushNotificationConfigRequest {
    /**
     * The identifier for this request.
     */
    id: string | number;
    /**
     * The version of the JSON-RPC protocol. MUST be exactly "2.0".
     */
    jsonrpc: "2.0";
    /**
     * The method name. Must be 'tasks/pushNotificationConfig/delete'.
     */
    method: "tasks/pushNotificationConfig/delete";
    params: DeleteTaskPushNotificationConfigParams;
}
/**
 * The parameters identifying the push notification configuration to delete.
 */
interface DeleteTaskPushNotificationConfigParams {
    /**
     * The unique identifier of the task.
     */
    id: string;
    /**
     * Optional metadata associated with the request.
     */
    metadata?: {
        [k: string]: unknown;
    };
    /**
     * The ID of the push notification configuration to delete.
     */
    pushNotificationConfigId: string;
}
/**
 * Represents a JSON-RPC request for the `agent/getAuthenticatedExtendedCard` method.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "GetAuthenticatedExtendedCardRequest".
 */
interface GetAuthenticatedExtendedCardRequest {
    /**
     * The identifier for this request.
     */
    id: string | number;
    /**
     * The version of the JSON-RPC protocol. MUST be exactly "2.0".
     */
    jsonrpc: "2.0";
    /**
     * The method name. Must be 'agent/getAuthenticatedExtendedCard'.
     */
    method: "agent/getAuthenticatedExtendedCard";
}
/**
 * Defines a security scheme using an API key.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "APIKeySecurityScheme".
 */
interface APIKeySecurityScheme {
    /**
     * An optional description for the security scheme.
     */
    description?: string;
    /**
     * The location of the API key.
     */
    in: "cookie" | "header" | "query";
    /**
     * The name of the header, query, or cookie parameter to be used.
     */
    name: string;
    /**
     * The type of the security scheme. Must be 'apiKey'.
     */
    type: "apiKey";
}
/**
 * Defines optional capabilities supported by an agent.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "AgentCapabilities".
 */
interface AgentCapabilities {
    /**
     * A list of protocol extensions supported by the agent.
     */
    extensions?: AgentExtension[];
    /**
     * Indicates if the agent supports sending push notifications for asynchronous task updates.
     */
    pushNotifications?: boolean;
    /**
     * Indicates if the agent provides a history of state transitions for a task.
     */
    stateTransitionHistory?: boolean;
    /**
     * Indicates if the agent supports Server-Sent Events (SSE) for streaming responses.
     */
    streaming?: boolean;
}
/**
 * A declaration of a protocol extension supported by an Agent.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "AgentExtension".
 */
interface AgentExtension {
    /**
     * A human-readable description of how this agent uses the extension.
     */
    description?: string;
    /**
     * Optional, extension-specific configuration parameters.
     */
    params?: {
        [k: string]: unknown;
    };
    /**
     * If true, the client must understand and comply with the extension's requirements
     * to interact with the agent.
     */
    required?: boolean;
    /**
     * The unique URI identifying the extension.
     */
    uri: string;
}
/**
 * The AgentCard is a self-describing manifest for an agent. It provides essential
 * metadata including the agent's identity, capabilities, skills, supported
 * communication methods, and security requirements.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "AgentCard".
 */
interface AgentCard {
    /**
     * A list of additional supported interfaces (transport and URL combinations).
     * This allows agents to expose multiple transports, potentially at different URLs.
     *
     * Best practices:
     * - SHOULD include all supported transports for completeness
     * - SHOULD include an entry matching the main 'url' and 'preferredTransport'
     * - MAY reuse URLs if multiple transports are available at the same endpoint
     * - MUST accurately declare the transport available at each URL
     *
     * Clients can select any interface from this list based on their transport capabilities
     * and preferences. This enables transport negotiation and fallback scenarios.
     */
    additionalInterfaces?: AgentInterface[];
    capabilities: AgentCapabilities1;
    /**
     * Default set of supported input MIME types for all skills, which can be
     * overridden on a per-skill basis.
     */
    defaultInputModes: string[];
    /**
     * Default set of supported output MIME types for all skills, which can be
     * overridden on a per-skill basis.
     */
    defaultOutputModes: string[];
    /**
     * A human-readable description of the agent, assisting users and other agents
     * in understanding its purpose.
     */
    description: string;
    /**
     * An optional URL to the agent's documentation.
     */
    documentationUrl?: string;
    /**
     * An optional URL to an icon for the agent.
     */
    iconUrl?: string;
    /**
     * A human-readable name for the agent.
     */
    name: string;
    /**
     * The transport protocol for the preferred endpoint (the main 'url' field).
     * If not specified, defaults to 'JSONRPC'.
     *
     * IMPORTANT: The transport specified here MUST be available at the main 'url'.
     * This creates a binding between the main URL and its supported transport protocol.
     * Clients should prefer this transport and URL combination when both are supported.
     */
    preferredTransport?: string;
    /**
     * The version of the A2A protocol this agent supports.
     */
    protocolVersion: string;
    provider?: AgentProvider;
    /**
     * A list of security requirement objects that apply to all agent interactions. Each object
     * lists security schemes that can be used. Follows the OpenAPI 3.0 Security Requirement Object.
     * This list can be seen as an OR of ANDs. Each object in the list describes one possible
     * set of security requirements that must be present on a request. This allows specifying,
     * for example, "callers must either use OAuth OR an API Key AND mTLS."
     */
    security?: {
        [k: string]: string[];
    }[];
    /**
     * A declaration of the security schemes available to authorize requests. The key is the
     * scheme name. Follows the OpenAPI 3.0 Security Scheme Object.
     */
    securitySchemes?: {
        [k: string]: SecurityScheme;
    };
    /**
     * JSON Web Signatures computed for this AgentCard.
     */
    signatures?: AgentCardSignature[];
    /**
     * The set of skills, or distinct capabilities, that the agent can perform.
     */
    skills: AgentSkill[];
    /**
     * If true, the agent can provide an extended agent card with additional details
     * to authenticated users. Defaults to false.
     */
    supportsAuthenticatedExtendedCard?: boolean;
    /**
     * The preferred endpoint URL for interacting with the agent.
     * This URL MUST support the transport specified by 'preferredTransport'.
     */
    url: string;
    /**
     * The agent's own version number. The format is defined by the provider.
     */
    version: string;
}
/**
 * Declares a combination of a target URL and a transport protocol for interacting with the agent.
 * This allows agents to expose the same functionality over multiple transport mechanisms.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "AgentInterface".
 */
interface AgentInterface {
    /**
     * The transport protocol supported at this URL.
     */
    transport: string;
    /**
     * The URL where this interface is available. Must be a valid absolute HTTPS URL in production.
     */
    url: string;
}
/**
 * A declaration of optional capabilities supported by the agent.
 */
interface AgentCapabilities1 {
    /**
     * A list of protocol extensions supported by the agent.
     */
    extensions?: AgentExtension[];
    /**
     * Indicates if the agent supports sending push notifications for asynchronous task updates.
     */
    pushNotifications?: boolean;
    /**
     * Indicates if the agent provides a history of state transitions for a task.
     */
    stateTransitionHistory?: boolean;
    /**
     * Indicates if the agent supports Server-Sent Events (SSE) for streaming responses.
     */
    streaming?: boolean;
}
/**
 * Information about the agent's service provider.
 */
interface AgentProvider {
    /**
     * The name of the agent provider's organization.
     */
    organization: string;
    /**
     * A URL for the agent provider's website or relevant documentation.
     */
    url: string;
}
/**
 * Defines a security scheme using HTTP authentication.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "HTTPAuthSecurityScheme".
 */
interface HTTPAuthSecurityScheme {
    /**
     * A hint to the client to identify how the bearer token is formatted (e.g., "JWT").
     * This is primarily for documentation purposes.
     */
    bearerFormat?: string;
    /**
     * An optional description for the security scheme.
     */
    description?: string;
    /**
     * The name of the HTTP Authentication scheme to be used in the Authorization header,
     * as defined in RFC7235 (e.g., "Bearer").
     * This value should be registered in the IANA Authentication Scheme registry.
     */
    scheme: string;
    /**
     * The type of the security scheme. Must be 'http'.
     */
    type: "http";
}
/**
 * Defines a security scheme using OAuth 2.0.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "OAuth2SecurityScheme".
 */
interface OAuth2SecurityScheme {
    /**
     * An optional description for the security scheme.
     */
    description?: string;
    flows: OAuthFlows;
    /**
     * URL to the oauth2 authorization server metadata
     * [RFC8414](https://datatracker.ietf.org/doc/html/rfc8414). TLS is required.
     */
    oauth2MetadataUrl?: string;
    /**
     * The type of the security scheme. Must be 'oauth2'.
     */
    type: "oauth2";
}
/**
 * An object containing configuration information for the supported OAuth 2.0 flows.
 */
interface OAuthFlows {
    authorizationCode?: AuthorizationCodeOAuthFlow;
    clientCredentials?: ClientCredentialsOAuthFlow;
    implicit?: ImplicitOAuthFlow;
    password?: PasswordOAuthFlow;
}
/**
 * Configuration for the OAuth Authorization Code flow. Previously called accessCode in OpenAPI 2.0.
 */
interface AuthorizationCodeOAuthFlow {
    /**
     * The authorization URL to be used for this flow.
     * This MUST be a URL and use TLS.
     */
    authorizationUrl: string;
    /**
     * The URL to be used for obtaining refresh tokens.
     * This MUST be a URL and use TLS.
     */
    refreshUrl?: string;
    /**
     * The available scopes for the OAuth2 security scheme. A map between the scope
     * name and a short description for it.
     */
    scopes: {
        [k: string]: string;
    };
    /**
     * The token URL to be used for this flow.
     * This MUST be a URL and use TLS.
     */
    tokenUrl: string;
}
/**
 * Configuration for the OAuth Client Credentials flow. Previously called application in OpenAPI 2.0.
 */
interface ClientCredentialsOAuthFlow {
    /**
     * The URL to be used for obtaining refresh tokens. This MUST be a URL.
     */
    refreshUrl?: string;
    /**
     * The available scopes for the OAuth2 security scheme. A map between the scope
     * name and a short description for it.
     */
    scopes: {
        [k: string]: string;
    };
    /**
     * The token URL to be used for this flow. This MUST be a URL.
     */
    tokenUrl: string;
}
/**
 * Configuration for the OAuth Implicit flow.
 */
interface ImplicitOAuthFlow {
    /**
     * The authorization URL to be used for this flow. This MUST be a URL.
     */
    authorizationUrl: string;
    /**
     * The URL to be used for obtaining refresh tokens. This MUST be a URL.
     */
    refreshUrl?: string;
    /**
     * The available scopes for the OAuth2 security scheme. A map between the scope
     * name and a short description for it.
     */
    scopes: {
        [k: string]: string;
    };
}
/**
 * Configuration for the OAuth Resource Owner Password flow.
 */
interface PasswordOAuthFlow {
    /**
     * The URL to be used for obtaining refresh tokens. This MUST be a URL.
     */
    refreshUrl?: string;
    /**
     * The available scopes for the OAuth2 security scheme. A map between the scope
     * name and a short description for it.
     */
    scopes: {
        [k: string]: string;
    };
    /**
     * The token URL to be used for this flow. This MUST be a URL.
     */
    tokenUrl: string;
}
/**
 * Defines a security scheme using OpenID Connect.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "OpenIdConnectSecurityScheme".
 */
interface OpenIdConnectSecurityScheme {
    /**
     * An optional description for the security scheme.
     */
    description?: string;
    /**
     * The OpenID Connect Discovery URL for the OIDC provider's metadata.
     */
    openIdConnectUrl: string;
    /**
     * The type of the security scheme. Must be 'openIdConnect'.
     */
    type: "openIdConnect";
}
/**
 * Defines a security scheme using mTLS authentication.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "MutualTLSSecurityScheme".
 */
interface MutualTLSSecurityScheme {
    /**
     * An optional description for the security scheme.
     */
    description?: string;
    /**
     * The type of the security scheme. Must be 'mutualTLS'.
     */
    type: "mutualTLS";
}
/**
 * AgentCardSignature represents a JWS signature of an AgentCard.
 * This follows the JSON format of an RFC 7515 JSON Web Signature (JWS).
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "AgentCardSignature".
 */
interface AgentCardSignature {
    /**
     * The unprotected JWS header values.
     */
    header?: {
        [k: string]: unknown;
    };
    /**
     * The protected JWS header for the signature. This is a Base64url-encoded
     * JSON object, as per RFC 7515.
     */
    protected: string;
    /**
     * The computed signature, Base64url-encoded.
     */
    signature: string;
}
/**
 * Represents a distinct capability or function that an agent can perform.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "AgentSkill".
 */
interface AgentSkill {
    /**
     * A detailed description of the skill, intended to help clients or users
     * understand its purpose and functionality.
     */
    description: string;
    /**
     * Example prompts or scenarios that this skill can handle. Provides a hint to
     * the client on how to use the skill.
     */
    examples?: string[];
    /**
     * A unique identifier for the agent's skill.
     */
    id: string;
    /**
     * The set of supported input MIME types for this skill, overriding the agent's defaults.
     */
    inputModes?: string[];
    /**
     * A human-readable name for the skill.
     */
    name: string;
    /**
     * The set of supported output MIME types for this skill, overriding the agent's defaults.
     */
    outputModes?: string[];
    /**
     * Security schemes necessary for the agent to leverage this skill.
     * As in the overall AgentCard.security, this list represents a logical OR of security
     * requirement objects. Each object is a set of security schemes that must be used together
     * (a logical AND).
     */
    security?: {
        [k: string]: string[];
    }[];
    /**
     * A set of keywords describing the skill's capabilities.
     */
    tags: string[];
}
/**
 * Represents the service provider of an agent.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "AgentProvider".
 */
interface AgentProvider1 {
    /**
     * The name of the agent provider's organization.
     */
    organization: string;
    /**
     * A URL for the agent provider's website or relevant documentation.
     */
    url: string;
}
/**
 * Represents a file, data structure, or other resource generated by an agent during a task.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "Artifact".
 */
interface Artifact {
    /**
     * A unique identifier for the artifact within the scope of the task.
     */
    artifactId: string;
    /**
     * An optional, human-readable description of the artifact.
     */
    description?: string;
    /**
     * The URIs of extensions that are relevant to this artifact.
     */
    extensions?: string[];
    /**
     * Optional metadata for extensions. The key is an extension-specific identifier.
     */
    metadata?: {
        [k: string]: unknown;
    };
    /**
     * An optional, human-readable name for the artifact.
     */
    name?: string;
    /**
     * An array of content parts that make up the artifact.
     */
    parts: Part[];
}
/**
 * Defines configuration details for the OAuth 2.0 Authorization Code flow.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "AuthorizationCodeOAuthFlow".
 */
interface AuthorizationCodeOAuthFlow1 {
    /**
     * The authorization URL to be used for this flow.
     * This MUST be a URL and use TLS.
     */
    authorizationUrl: string;
    /**
     * The URL to be used for obtaining refresh tokens.
     * This MUST be a URL and use TLS.
     */
    refreshUrl?: string;
    /**
     * The available scopes for the OAuth2 security scheme. A map between the scope
     * name and a short description for it.
     */
    scopes: {
        [k: string]: string;
    };
    /**
     * The token URL to be used for this flow.
     * This MUST be a URL and use TLS.
     */
    tokenUrl: string;
}
/**
 * Represents a JSON-RPC 2.0 Error Response object.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "JSONRPCErrorResponse".
 */
interface JSONRPCErrorResponse {
    /**
     * An object describing the error that occurred.
     */
    error: JSONRPCError | JSONParseError | InvalidRequestError | MethodNotFoundError | InvalidParamsError | InternalError | TaskNotFoundError | TaskNotCancelableError | PushNotificationNotSupportedError | UnsupportedOperationError | ContentTypeNotSupportedError | InvalidAgentResponseError | AuthenticatedExtendedCardNotConfiguredError;
    /**
     * The identifier established by the client.
     */
    id: string | number | null;
    /**
     * The version of the JSON-RPC protocol. MUST be exactly "2.0".
     */
    jsonrpc: "2.0";
}
/**
 * Represents a JSON-RPC 2.0 Error object, included in an error response.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "JSONRPCError".
 */
interface JSONRPCError {
    /**
     * A number that indicates the error type that occurred.
     */
    code: number;
    /**
     * A primitive or structured value containing additional information about the error.
     * This may be omitted.
     */
    data?: {
        [k: string]: unknown;
    };
    /**
     * A string providing a short description of the error.
     */
    message: string;
}
/**
 * Represents a successful JSON-RPC response for the `tasks/cancel` method.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "CancelTaskSuccessResponse".
 */
interface CancelTaskSuccessResponse {
    /**
     * The identifier established by the client.
     */
    id: string | number | null;
    /**
     * The version of the JSON-RPC protocol. MUST be exactly "2.0".
     */
    jsonrpc: "2.0";
    result: Task;
}
/**
 * The result, containing the final state of the canceled Task object.
 */
interface Task {
    /**
     * A collection of artifacts generated by the agent during the execution of the task.
     */
    artifacts?: Artifact[];
    /**
     * A server-generated identifier for maintaining context across multiple related tasks or interactions.
     */
    contextId: string;
    /**
     * An array of messages exchanged during the task, representing the conversation history.
     */
    history?: Message1[];
    /**
     * A unique identifier for the task, generated by the server for a new task.
     */
    id: string;
    /**
     * The type of this object, used as a discriminator. Always 'task' for a Task.
     */
    kind: "task";
    /**
     * Optional metadata for extensions. The key is an extension-specific identifier.
     */
    metadata?: {
        [k: string]: unknown;
    };
    status: TaskStatus;
}
/**
 * Represents a single message in the conversation between a user and an agent.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "Message".
 */
interface Message1 {
    /**
     * The context identifier for this message, used to group related interactions.
     */
    contextId?: string;
    /**
     * The URIs of extensions that are relevant to this message.
     */
    extensions?: string[];
    /**
     * The type of this object, used as a discriminator. Always 'message' for a Message.
     */
    kind: "message";
    /**
     * A unique identifier for the message, typically a UUID, generated by the sender.
     */
    messageId: string;
    /**
     * Optional metadata for extensions. The key is an extension-specific identifier.
     */
    metadata?: {
        [k: string]: unknown;
    };
    /**
     * An array of content parts that form the message body. A message can be
     * composed of multiple parts of different types (e.g., text and files).
     */
    parts: Part[];
    /**
     * A list of other task IDs that this message references for additional context.
     */
    referenceTaskIds?: string[];
    /**
     * Identifies the sender of the message. `user` for the client, `agent` for the service.
     */
    role: "agent" | "user";
    /**
     * The identifier of the task this message is part of. Can be omitted for the first message of a new task.
     */
    taskId?: string;
}
/**
 * The current status of the task, including its state and a descriptive message.
 */
interface TaskStatus {
    message?: Message2;
    /**
     * The current state of the task's lifecycle.
     */
    state: "submitted" | "working" | "input-required" | "completed" | "canceled" | "failed" | "rejected" | "auth-required" | "unknown";
    /**
     * An ISO 8601 datetime string indicating when this status was recorded.
     */
    timestamp?: string;
}
/**
 * Represents a single message in the conversation between a user and an agent.
 */
interface Message2 {
    /**
     * The context identifier for this message, used to group related interactions.
     */
    contextId?: string;
    /**
     * The URIs of extensions that are relevant to this message.
     */
    extensions?: string[];
    /**
     * The type of this object, used as a discriminator. Always 'message' for a Message.
     */
    kind: "message";
    /**
     * A unique identifier for the message, typically a UUID, generated by the sender.
     */
    messageId: string;
    /**
     * Optional metadata for extensions. The key is an extension-specific identifier.
     */
    metadata?: {
        [k: string]: unknown;
    };
    /**
     * An array of content parts that form the message body. A message can be
     * composed of multiple parts of different types (e.g., text and files).
     */
    parts: Part[];
    /**
     * A list of other task IDs that this message references for additional context.
     */
    referenceTaskIds?: string[];
    /**
     * Identifies the sender of the message. `user` for the client, `agent` for the service.
     */
    role: "agent" | "user";
    /**
     * The identifier of the task this message is part of. Can be omitted for the first message of a new task.
     */
    taskId?: string;
}
/**
 * Defines configuration details for the OAuth 2.0 Client Credentials flow.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "ClientCredentialsOAuthFlow".
 */
interface ClientCredentialsOAuthFlow1 {
    /**
     * The URL to be used for obtaining refresh tokens. This MUST be a URL.
     */
    refreshUrl?: string;
    /**
     * The available scopes for the OAuth2 security scheme. A map between the scope
     * name and a short description for it.
     */
    scopes: {
        [k: string]: string;
    };
    /**
     * The token URL to be used for this flow. This MUST be a URL.
     */
    tokenUrl: string;
}
/**
 * Defines parameters for deleting a specific push notification configuration for a task.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "DeleteTaskPushNotificationConfigParams".
 */
interface DeleteTaskPushNotificationConfigParams1 {
    /**
     * The unique identifier of the task.
     */
    id: string;
    /**
     * Optional metadata associated with the request.
     */
    metadata?: {
        [k: string]: unknown;
    };
    /**
     * The ID of the push notification configuration to delete.
     */
    pushNotificationConfigId: string;
}
/**
 * Represents a successful JSON-RPC response for the `tasks/pushNotificationConfig/delete` method.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "DeleteTaskPushNotificationConfigSuccessResponse".
 */
interface DeleteTaskPushNotificationConfigSuccessResponse {
    /**
     * The identifier established by the client.
     */
    id: string | number | null;
    /**
     * The version of the JSON-RPC protocol. MUST be exactly "2.0".
     */
    jsonrpc: "2.0";
    /**
     * The result is null on successful deletion.
     */
    result: null;
}
/**
 * Defines base properties for a file.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "FileBase".
 */
interface FileBase {
    /**
     * The MIME type of the file (e.g., "application/pdf").
     */
    mimeType?: string;
    /**
     * An optional name for the file (e.g., "document.pdf").
     */
    name?: string;
}
/**
 * Represents a successful JSON-RPC response for the `agent/getAuthenticatedExtendedCard` method.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "GetAuthenticatedExtendedCardSuccessResponse".
 */
interface GetAuthenticatedExtendedCardSuccessResponse {
    /**
     * The identifier established by the client.
     */
    id: string | number | null;
    /**
     * The version of the JSON-RPC protocol. MUST be exactly "2.0".
     */
    jsonrpc: "2.0";
    result: AgentCard1;
}
/**
 * The result is an Agent Card object.
 */
interface AgentCard1 {
    /**
     * A list of additional supported interfaces (transport and URL combinations).
     * This allows agents to expose multiple transports, potentially at different URLs.
     *
     * Best practices:
     * - SHOULD include all supported transports for completeness
     * - SHOULD include an entry matching the main 'url' and 'preferredTransport'
     * - MAY reuse URLs if multiple transports are available at the same endpoint
     * - MUST accurately declare the transport available at each URL
     *
     * Clients can select any interface from this list based on their transport capabilities
     * and preferences. This enables transport negotiation and fallback scenarios.
     */
    additionalInterfaces?: AgentInterface[];
    capabilities: AgentCapabilities1;
    /**
     * Default set of supported input MIME types for all skills, which can be
     * overridden on a per-skill basis.
     */
    defaultInputModes: string[];
    /**
     * Default set of supported output MIME types for all skills, which can be
     * overridden on a per-skill basis.
     */
    defaultOutputModes: string[];
    /**
     * A human-readable description of the agent, assisting users and other agents
     * in understanding its purpose.
     */
    description: string;
    /**
     * An optional URL to the agent's documentation.
     */
    documentationUrl?: string;
    /**
     * An optional URL to an icon for the agent.
     */
    iconUrl?: string;
    /**
     * A human-readable name for the agent.
     */
    name: string;
    /**
     * The transport protocol for the preferred endpoint (the main 'url' field).
     * If not specified, defaults to 'JSONRPC'.
     *
     * IMPORTANT: The transport specified here MUST be available at the main 'url'.
     * This creates a binding between the main URL and its supported transport protocol.
     * Clients should prefer this transport and URL combination when both are supported.
     */
    preferredTransport?: string;
    /**
     * The version of the A2A protocol this agent supports.
     */
    protocolVersion: string;
    provider?: AgentProvider;
    /**
     * A list of security requirement objects that apply to all agent interactions. Each object
     * lists security schemes that can be used. Follows the OpenAPI 3.0 Security Requirement Object.
     * This list can be seen as an OR of ANDs. Each object in the list describes one possible
     * set of security requirements that must be present on a request. This allows specifying,
     * for example, "callers must either use OAuth OR an API Key AND mTLS."
     */
    security?: {
        [k: string]: string[];
    }[];
    /**
     * A declaration of the security schemes available to authorize requests. The key is the
     * scheme name. Follows the OpenAPI 3.0 Security Scheme Object.
     */
    securitySchemes?: {
        [k: string]: SecurityScheme;
    };
    /**
     * JSON Web Signatures computed for this AgentCard.
     */
    signatures?: AgentCardSignature[];
    /**
     * The set of skills, or distinct capabilities, that the agent can perform.
     */
    skills: AgentSkill[];
    /**
     * If true, the agent can provide an extended agent card with additional details
     * to authenticated users. Defaults to false.
     */
    supportsAuthenticatedExtendedCard?: boolean;
    /**
     * The preferred endpoint URL for interacting with the agent.
     * This URL MUST support the transport specified by 'preferredTransport'.
     */
    url: string;
    /**
     * The agent's own version number. The format is defined by the provider.
     */
    version: string;
}
/**
 * Represents a successful JSON-RPC response for the `tasks/pushNotificationConfig/get` method.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "GetTaskPushNotificationConfigSuccessResponse".
 */
interface GetTaskPushNotificationConfigSuccessResponse {
    /**
     * The identifier established by the client.
     */
    id: string | number | null;
    /**
     * The version of the JSON-RPC protocol. MUST be exactly "2.0".
     */
    jsonrpc: "2.0";
    result: TaskPushNotificationConfig1;
}
/**
 * The result, containing the requested push notification configuration.
 */
interface TaskPushNotificationConfig1 {
    pushNotificationConfig: PushNotificationConfig1;
    /**
     * The ID of the task.
     */
    taskId: string;
}
/**
 * Represents a successful JSON-RPC response for the `tasks/get` method.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "GetTaskSuccessResponse".
 */
interface GetTaskSuccessResponse {
    /**
     * The identifier established by the client.
     */
    id: string | number | null;
    /**
     * The version of the JSON-RPC protocol. MUST be exactly "2.0".
     */
    jsonrpc: "2.0";
    result: Task1;
}
/**
 * The result, containing the requested Task object.
 */
interface Task1 {
    /**
     * A collection of artifacts generated by the agent during the execution of the task.
     */
    artifacts?: Artifact[];
    /**
     * A server-generated identifier for maintaining context across multiple related tasks or interactions.
     */
    contextId: string;
    /**
     * An array of messages exchanged during the task, representing the conversation history.
     */
    history?: Message1[];
    /**
     * A unique identifier for the task, generated by the server for a new task.
     */
    id: string;
    /**
     * The type of this object, used as a discriminator. Always 'task' for a Task.
     */
    kind: "task";
    /**
     * Optional metadata for extensions. The key is an extension-specific identifier.
     */
    metadata?: {
        [k: string]: unknown;
    };
    status: TaskStatus;
}
/**
 * Defines configuration details for the OAuth 2.0 Implicit flow.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "ImplicitOAuthFlow".
 */
interface ImplicitOAuthFlow1 {
    /**
     * The authorization URL to be used for this flow. This MUST be a URL.
     */
    authorizationUrl: string;
    /**
     * The URL to be used for obtaining refresh tokens. This MUST be a URL.
     */
    refreshUrl?: string;
    /**
     * The available scopes for the OAuth2 security scheme. A map between the scope
     * name and a short description for it.
     */
    scopes: {
        [k: string]: string;
    };
}
/**
 * Defines the base structure for any JSON-RPC 2.0 request, response, or notification.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "JSONRPCMessage".
 */
interface JSONRPCMessage {
    /**
     * A unique identifier established by the client. It must be a String, a Number, or null.
     * The server must reply with the same value in the response. This property is omitted for notifications.
     */
    id?: string | number | null;
    /**
     * The version of the JSON-RPC protocol. MUST be exactly "2.0".
     */
    jsonrpc: "2.0";
}
/**
 * Represents a JSON-RPC 2.0 Request object.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "JSONRPCRequest".
 */
interface JSONRPCRequest {
    /**
     * A unique identifier established by the client. It must be a String, a Number, or null.
     * The server must reply with the same value in the response. This property is omitted for notifications.
     */
    id?: string | number | null;
    /**
     * The version of the JSON-RPC protocol. MUST be exactly "2.0".
     */
    jsonrpc: "2.0";
    /**
     * A string containing the name of the method to be invoked.
     */
    method: string;
    /**
     * A structured value holding the parameter values to be used during the method invocation.
     */
    params?: {
        [k: string]: unknown;
    };
}
/**
 * Represents a successful JSON-RPC response for the `message/send` method.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "SendMessageSuccessResponse".
 */
interface SendMessageSuccessResponse {
    /**
     * The identifier established by the client.
     */
    id: string | number | null;
    /**
     * The version of the JSON-RPC protocol. MUST be exactly "2.0".
     */
    jsonrpc: "2.0";
    /**
     * The result, which can be a direct reply Message or the initial Task object.
     */
    result: Task2 | Message1;
}
/**
 * Represents a single, stateful operation or conversation between a client and an agent.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "Task".
 */
interface Task2 {
    /**
     * A collection of artifacts generated by the agent during the execution of the task.
     */
    artifacts?: Artifact[];
    /**
     * A server-generated identifier for maintaining context across multiple related tasks or interactions.
     */
    contextId: string;
    /**
     * An array of messages exchanged during the task, representing the conversation history.
     */
    history?: Message1[];
    /**
     * A unique identifier for the task, generated by the server for a new task.
     */
    id: string;
    /**
     * The type of this object, used as a discriminator. Always 'task' for a Task.
     */
    kind: "task";
    /**
     * Optional metadata for extensions. The key is an extension-specific identifier.
     */
    metadata?: {
        [k: string]: unknown;
    };
    status: TaskStatus;
}
/**
 * Represents a successful JSON-RPC response for the `message/stream` method.
 * The server may send multiple response objects for a single request.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "SendStreamingMessageSuccessResponse".
 */
interface SendStreamingMessageSuccessResponse {
    /**
     * The identifier established by the client.
     */
    id: string | number | null;
    /**
     * The version of the JSON-RPC protocol. MUST be exactly "2.0".
     */
    jsonrpc: "2.0";
    /**
     * The result, which can be a Message, Task, or a streaming update event.
     */
    result: Task2 | Message1 | TaskStatusUpdateEvent | TaskArtifactUpdateEvent;
}
/**
 * An event sent by the agent to notify the client of a change in a task's status.
 * This is typically used in streaming or subscription models.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "TaskStatusUpdateEvent".
 */
interface TaskStatusUpdateEvent {
    /**
     * The context ID associated with the task.
     */
    contextId: string;
    /**
     * If true, this is the final event in the stream for this interaction.
     */
    final: boolean;
    /**
     * The type of this event, used as a discriminator. Always 'status-update'.
     */
    kind: "status-update";
    /**
     * Optional metadata for extensions.
     */
    metadata?: {
        [k: string]: unknown;
    };
    status: TaskStatus1;
    /**
     * The ID of the task that was updated.
     */
    taskId: string;
}
/**
 * The new status of the task.
 */
interface TaskStatus1 {
    message?: Message2;
    /**
     * The current state of the task's lifecycle.
     */
    state: "submitted" | "working" | "input-required" | "completed" | "canceled" | "failed" | "rejected" | "auth-required" | "unknown";
    /**
     * An ISO 8601 datetime string indicating when this status was recorded.
     */
    timestamp?: string;
}
/**
 * An event sent by the agent to notify the client that an artifact has been
 * generated or updated. This is typically used in streaming models.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "TaskArtifactUpdateEvent".
 */
interface TaskArtifactUpdateEvent {
    /**
     * If true, the content of this artifact should be appended to a previously sent artifact with the same ID.
     */
    append?: boolean;
    artifact: Artifact1;
    /**
     * The context ID associated with the task.
     */
    contextId: string;
    /**
     * The type of this event, used as a discriminator. Always 'artifact-update'.
     */
    kind: "artifact-update";
    /**
     * If true, this is the final chunk of the artifact.
     */
    lastChunk?: boolean;
    /**
     * Optional metadata for extensions.
     */
    metadata?: {
        [k: string]: unknown;
    };
    /**
     * The ID of the task this artifact belongs to.
     */
    taskId: string;
}
/**
 * Represents a file, data structure, or other resource generated by an agent during a task.
 */
interface Artifact1 {
    /**
     * A unique identifier for the artifact within the scope of the task.
     */
    artifactId: string;
    /**
     * An optional, human-readable description of the artifact.
     */
    description?: string;
    /**
     * The URIs of extensions that are relevant to this artifact.
     */
    extensions?: string[];
    /**
     * Optional metadata for extensions. The key is an extension-specific identifier.
     */
    metadata?: {
        [k: string]: unknown;
    };
    /**
     * An optional, human-readable name for the artifact.
     */
    name?: string;
    /**
     * An array of content parts that make up the artifact.
     */
    parts: Part[];
}
/**
 * Represents a successful JSON-RPC response for the `tasks/pushNotificationConfig/set` method.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "SetTaskPushNotificationConfigSuccessResponse".
 */
interface SetTaskPushNotificationConfigSuccessResponse {
    /**
     * The identifier established by the client.
     */
    id: string | number | null;
    /**
     * The version of the JSON-RPC protocol. MUST be exactly "2.0".
     */
    jsonrpc: "2.0";
    result: TaskPushNotificationConfig2;
}
/**
 * The result, containing the configured push notification settings.
 */
interface TaskPushNotificationConfig2 {
    pushNotificationConfig: PushNotificationConfig1;
    /**
     * The ID of the task.
     */
    taskId: string;
}
/**
 * Represents a successful JSON-RPC response for the `tasks/pushNotificationConfig/list` method.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "ListTaskPushNotificationConfigSuccessResponse".
 */
interface ListTaskPushNotificationConfigSuccessResponse {
    /**
     * The identifier established by the client.
     */
    id: string | number | null;
    /**
     * The version of the JSON-RPC protocol. MUST be exactly "2.0".
     */
    jsonrpc: "2.0";
    /**
     * The result, containing an array of all push notification configurations for the task.
     */
    result: TaskPushNotificationConfig3[];
}
/**
 * A container associating a push notification configuration with a specific task.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "TaskPushNotificationConfig".
 */
interface TaskPushNotificationConfig3 {
    pushNotificationConfig: PushNotificationConfig1;
    /**
     * The ID of the task.
     */
    taskId: string;
}
/**
 * Represents a successful JSON-RPC 2.0 Response object.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "JSONRPCSuccessResponse".
 */
interface JSONRPCSuccessResponse {
    /**
     * The identifier established by the client.
     */
    id: string | number | null;
    /**
     * The version of the JSON-RPC protocol. MUST be exactly "2.0".
     */
    jsonrpc: "2.0";
    /**
     * The value of this member is determined by the method invoked on the Server.
     */
    result: {
        [k: string]: unknown;
    };
}
/**
 * Defines parameters for listing all push notification configurations associated with a task.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "ListTaskPushNotificationConfigParams".
 */
interface ListTaskPushNotificationConfigParams1 {
    /**
     * The unique identifier of the task.
     */
    id: string;
    /**
     * Optional metadata associated with the request.
     */
    metadata?: {
        [k: string]: unknown;
    };
}
/**
 * Defines configuration options for a `message/send` or `message/stream` request.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "MessageSendConfiguration".
 */
interface MessageSendConfiguration1 {
    /**
     * A list of output MIME types the client is prepared to accept in the response.
     */
    acceptedOutputModes?: string[];
    /**
     * If true, the client will wait for the task to complete. The server may reject this if the task is long-running.
     */
    blocking?: boolean;
    /**
     * The number of most recent messages from the task's history to retrieve in the response.
     */
    historyLength?: number;
    pushNotificationConfig?: PushNotificationConfig;
}
/**
 * Defines the parameters for a request to send a message to an agent. This can be used
 * to create a new task, continue an existing one, or restart a task.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "MessageSendParams".
 */
interface MessageSendParams2 {
    configuration?: MessageSendConfiguration;
    message: Message;
    /**
     * Optional metadata for extensions.
     */
    metadata?: {
        [k: string]: unknown;
    };
}
/**
 * Defines the configuration for the supported OAuth 2.0 flows.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "OAuthFlows".
 */
interface OAuthFlows1 {
    authorizationCode?: AuthorizationCodeOAuthFlow;
    clientCredentials?: ClientCredentialsOAuthFlow;
    implicit?: ImplicitOAuthFlow;
    password?: PasswordOAuthFlow;
}
/**
 * Defines base properties common to all message or artifact parts.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "PartBase".
 */
interface PartBase {
    /**
     * Optional metadata associated with this part.
     */
    metadata?: {
        [k: string]: unknown;
    };
}
/**
 * Defines configuration details for the OAuth 2.0 Resource Owner Password flow.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "PasswordOAuthFlow".
 */
interface PasswordOAuthFlow1 {
    /**
     * The URL to be used for obtaining refresh tokens. This MUST be a URL.
     */
    refreshUrl?: string;
    /**
     * The available scopes for the OAuth2 security scheme. A map between the scope
     * name and a short description for it.
     */
    scopes: {
        [k: string]: string;
    };
    /**
     * The token URL to be used for this flow. This MUST be a URL.
     */
    tokenUrl: string;
}
/**
 * Defines authentication details for a push notification endpoint.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "PushNotificationAuthenticationInfo".
 */
interface PushNotificationAuthenticationInfo1 {
    /**
     * Optional credentials required by the push notification endpoint.
     */
    credentials?: string;
    /**
     * A list of supported authentication schemes (e.g., 'Basic', 'Bearer').
     */
    schemes: string[];
}
/**
 * Defines the configuration for setting up push notifications for task updates.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "PushNotificationConfig".
 */
interface PushNotificationConfig2 {
    authentication?: PushNotificationAuthenticationInfo;
    /**
     * A unique ID for the push notification configuration, set by the client
     * to support multiple notification callbacks.
     */
    id?: string;
    /**
     * A unique token for this task or session to validate incoming push notifications.
     */
    token?: string;
    /**
     * The callback URL where the agent should send push notifications.
     */
    url: string;
}
/**
 * Defines base properties shared by all security scheme objects.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "SecuritySchemeBase".
 */
interface SecuritySchemeBase {
    /**
     * An optional description for the security scheme.
     */
    description?: string;
}
/**
 * Defines parameters for querying a task, with an option to limit history length.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "TaskQueryParams".
 */
interface TaskQueryParams1 {
    /**
     * The number of most recent messages from the task's history to retrieve.
     */
    historyLength?: number;
    /**
     * The unique identifier of the task.
     */
    id: string;
    /**
     * Optional metadata associated with the request.
     */
    metadata?: {
        [k: string]: unknown;
    };
}
/**
 * Represents the status of a task at a specific point in time.
 *
 * This interface was referenced by `MySchema`'s JSON-Schema
 * via the `definition` "TaskStatus".
 */
interface TaskStatus2 {
    message?: Message2;
    /**
     * The current state of the task's lifecycle.
     */
    state: "submitted" | "working" | "input-required" | "completed" | "canceled" | "failed" | "rejected" | "auth-required" | "unknown";
    /**
     * An ISO 8601 datetime string indicating when this status was recorded.
     */
    timestamp?: string;
}

/**
 * A2A Protocol Extension URI.
 */
type ExtensionURI = string;
/**
 * A collection of {@link ExtensionURI}.
 */
type Extensions = ExtensionURI[];
declare const Extensions: {
    /**
     * Creates new {@link Extensions} from `current` and `additional`.
     * If `current` already contains `additional` it is returned unmodified.
     */
    createFrom: (current: Extensions | undefined, additional: ExtensionURI) => Extensions;
    /**
     * Creates {@link Extensions} from comma separated extensions identifiers as per
     * https://a2a-protocol.org/latest/specification/#326-service-parameters.
     * Parses the output of `toServiceParameter`.
     */
    parseServiceParameter: (value: string | undefined) => Extensions;
    /**
     * Converts {@link Extensions} to comma separated extensions identifiers as per
     * https://a2a-protocol.org/latest/specification/#326-service-parameters.
     */
    toServiceParameter: (value: Extensions) => string;
};

export { type TaskPushNotificationConfig as $, type A2AError as A, type PushNotificationAuthenticationInfo as B, type CancelTaskResponse as C, type DeleteTaskPushNotificationConfigSuccessResponse as D, Extensions as E, type Message as F, type GetTaskResponse as G, type TextPart as H, type InvalidRequestError as I, type JSONRPCErrorResponse as J, type FilePart as K, type ListTaskPushNotificationConfigSuccessResponse as L, type MySchema as M, type FileWithBytes as N, type FileWithUri as O, type Part as P, type DataPart as Q, type SendStreamingMessageRequest as R, type SendMessageResponse as S, type TaskState as T, type UnsupportedOperationError as U, type MessageSendParams1 as V, type GetTaskRequest as W, type TaskQueryParams as X, type CancelTaskRequest as Y, type TaskIdParams as Z, type SetTaskPushNotificationConfigRequest as _, type SendStreamingMessageResponse as a, type OAuthFlows1 as a$, type PushNotificationConfig1 as a0, type GetTaskPushNotificationConfigRequest as a1, type TaskIdParams1 as a2, type GetTaskPushNotificationConfigParams as a3, type TaskResubscriptionRequest as a4, type TaskIdParams2 as a5, type ListTaskPushNotificationConfigRequest as a6, type ListTaskPushNotificationConfigParams as a7, type DeleteTaskPushNotificationConfigRequest as a8, type DeleteTaskPushNotificationConfigParams as a9, type TaskStatus as aA, type Message2 as aB, type ClientCredentialsOAuthFlow1 as aC, type DeleteTaskPushNotificationConfigParams1 as aD, type FileBase as aE, type AgentCard1 as aF, type GetTaskPushNotificationConfigSuccessResponse as aG, type TaskPushNotificationConfig1 as aH, type GetTaskSuccessResponse as aI, type Task1 as aJ, type ImplicitOAuthFlow1 as aK, type JSONRPCMessage as aL, type JSONRPCRequest as aM, type SendMessageSuccessResponse as aN, type Task2 as aO, type SendStreamingMessageSuccessResponse as aP, type TaskStatusUpdateEvent as aQ, type TaskStatus1 as aR, type TaskArtifactUpdateEvent as aS, type Artifact1 as aT, type SetTaskPushNotificationConfigSuccessResponse as aU, type TaskPushNotificationConfig2 as aV, type TaskPushNotificationConfig3 as aW, type JSONRPCSuccessResponse as aX, type ListTaskPushNotificationConfigParams1 as aY, type MessageSendConfiguration1 as aZ, type MessageSendParams2 as a_, type GetAuthenticatedExtendedCardRequest as aa, type APIKeySecurityScheme as ab, type AgentCapabilities as ac, type AgentExtension as ad, type AgentCard as ae, type AgentInterface as af, type AgentCapabilities1 as ag, type AgentProvider as ah, type HTTPAuthSecurityScheme as ai, type OAuth2SecurityScheme as aj, type OAuthFlows as ak, type AuthorizationCodeOAuthFlow as al, type ClientCredentialsOAuthFlow as am, type ImplicitOAuthFlow as an, type PasswordOAuthFlow as ao, type OpenIdConnectSecurityScheme as ap, type MutualTLSSecurityScheme as aq, type AgentCardSignature as ar, type AgentSkill as as, type AgentProvider1 as at, type Artifact as au, type AuthorizationCodeOAuthFlow1 as av, type JSONRPCError as aw, type CancelTaskSuccessResponse as ax, type Task as ay, type Message1 as az, type SetTaskPushNotificationConfigResponse as b, type PartBase as b0, type PasswordOAuthFlow1 as b1, type PushNotificationAuthenticationInfo1 as b2, type PushNotificationConfig2 as b3, type SecuritySchemeBase as b4, type TaskQueryParams1 as b5, type TaskStatus2 as b6, type GetTaskPushNotificationConfigResponse as c, type GetAuthenticatedExtendedCardSuccessResponse as d, type ExtensionURI as e, type A2ARequest as f, type SecurityScheme as g, type DeleteTaskPushNotificationConfigResponse as h, type GetAuthenticatedExtendedCardResponse as i, type JSONRPCResponse as j, type ListTaskPushNotificationConfigResponse as k, type TransportProtocol as l, type JSONParseError as m, type MethodNotFoundError as n, type InvalidParamsError as o, type InternalError as p, type TaskNotFoundError as q, type TaskNotCancelableError as r, type PushNotificationNotSupportedError as s, type ContentTypeNotSupportedError as t, type InvalidAgentResponseError as u, type AuthenticatedExtendedCardNotConfiguredError as v, type SendMessageRequest as w, type MessageSendParams as x, type MessageSendConfiguration as y, type PushNotificationConfig as z };
