/**
 * Maps each element of a Set based on a provided key-generating function.
 *
 * This function takes a Set and a function that generates a key from each value.
 * It returns a new Map where the keys are generated by the key function and the values are
 * the corresponding values from the original set. If multiple elements produce the same key,
 * the last value encountered will be used.
 *
 * @template T - The type of elements in the Set.
 * @template K - The type of keys to produce in the returned Map.
 * @param {Set<T>} set - The set of elements to be mapped.
 * @param {(value: T, value2: T, set: Set<T>) => K} getKeyFromValue - A function that generates a key from a value.
 * @returns {Map<K, T>} A Map where the generated keys are mapped to each element's value.
 *
 * @example
 * const set = new Set([
 *   { type: 'fruit', name: 'apple' },
 *   { type: 'fruit', name: 'banana' },
 *   { type: 'vegetable', name: 'carrot' }
 * ]);
 * const result = keyBy(set, item => item.type);
 * // result will be:
 * // Map(2) {
 * //   'fruit' => { type: 'fruit', name: 'banana' },
 * //   'vegetable' => { type: 'vegetable', name: 'carrot' }
 * // }
 */
declare function keyBy<T, K>(set: Set<T>, getKeyFromValue: (value: T, value2: T, set: Set<T>) => K): Map<K, T>;

export { keyBy };
