/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.LocalVariableFlags;

public class LocalDeferredProcedureCallGroupSharedMsSymbol
extends AbstractMsSymbol {
    public static final int PDB_ID = 4436;
    private RecordNumber typeRecordNumber;
    private LocalVariableFlags flags;
    private int dataSlot;
    private int dataOffset;
    private String name;

    public LocalDeferredProcedureCallGroupSharedMsSymbol(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.typeRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 32);
        this.flags = new LocalVariableFlags(reader);
        this.dataSlot = reader.parseUnsignedShortVal();
        this.dataOffset = reader.parseUnsignedShortVal();
        this.name = reader.parseString(pdb, StringParseType.StringUtf8Nt);
    }

    @Override
    public int getPdbId() {
        return 4436;
    }

    @Override
    public void emit(StringBuilder builder) {
        StringBuilder myBuilder = new StringBuilder();
        myBuilder.append(this.typeRecordNumber.getNumber());
        this.flags.emit(myBuilder);
        builder.append(String.format("%s: %s base data: slot = %d offset = %d, %s", this.getSymbolTypeName(), myBuilder.toString(), this.dataSlot, this.dataOffset, this.name));
    }

    @Override
    protected String getSymbolTypeName() {
        return "LOCAL_DPC_GROUPSHARED";
    }
}

