/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.DelimiterState;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractDerivedClassListMsType
extends AbstractMsType {
    protected List<RecordNumber> recordNumbers = new ArrayList<RecordNumber>();

    public AbstractDerivedClassListMsType(AbstractPdb pdb, PdbByteReader reader, int intSize) throws PdbException {
        super(pdb, reader);
        int count = reader.parseVarSizedCount(intSize);
        for (int i = 0; i < count; ++i) {
            RecordNumber aRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, intSize);
            this.recordNumbers.add(aRecordNumber);
        }
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        DelimiterState ds = new DelimiterState("", ", ");
        for (RecordNumber aRecordNumber : this.recordNumbers) {
            AbstractMsType type = this.pdb.getTypeRecord(aRecordNumber);
            builder.append(ds.out(true, type.toString()));
        }
    }
}

