/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.impliedmatches;

import ghidra.feature.vt.api.main.AssociationHook;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.plugin.AddressCorrelatorManager;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTControllerListener;
import ghidra.feature.vt.gui.plugin.VTTaskMonitor;
import ghidra.feature.vt.gui.util.ImpliedMatchUtils;
import ghidra.feature.vt.gui.util.MatchInfo;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.listing.Function;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class ImpliedMatchAssociationHook
implements AssociationHook,
VTControllerListener {
    private VTSession session;
    private final VTController controller;
    private boolean autoCreateImpliedMatches = true;

    public ImpliedMatchAssociationHook(VTController controller) {
        this.controller = controller;
        ToolOptions options = controller.getOptions();
        this.autoCreateImpliedMatches = options.getBoolean("Accept Match Options.Auto Create Implied Matches", false);
        this.setSession(controller.getSession());
        controller.addListener(this);
    }

    @Override
    public void sessionChanged(VTSession newSession) {
        this.setSession(newSession);
    }

    private void setSession(VTSession session) {
        if (this.session != null) {
            this.session.removeAssociationHook(this);
        }
        this.session = session;
        if (this.session != null) {
            this.session.addAssociationHook(this);
        }
    }

    @Override
    public void associationAccepted(VTAssociation association) {
        Function source = ImpliedMatchUtils.getSourceFunction(this.session, association);
        Function destination = ImpliedMatchUtils.getDestinationFunction(this.session, association);
        if (source == null || destination == null) {
            return;
        }
        AddressCorrelatorManager correlator = this.controller.getCorrelator();
        if (!this.autoCreateImpliedMatches) {
            return;
        }
        try {
            TaskMonitor monitor = VTTaskMonitor.getTaskMonitor();
            ImpliedMatchUtils.updateImpliedMatchForAcceptedAssocation(source, destination, this.session, correlator, monitor);
        }
        catch (CancelledException e) {
            Msg.info((Object)this, (Object)"User cancelled finding implied matches when accepting an assocation");
        }
    }

    @Override
    public void associationCleared(VTAssociation association) {
        Function source = ImpliedMatchUtils.getSourceFunction(this.session, association);
        Function destination = ImpliedMatchUtils.getDestinationFunction(this.session, association);
        if (source == null || destination == null) {
            return;
        }
        if (!this.autoCreateImpliedMatches) {
            return;
        }
        AddressCorrelatorManager correlator = this.controller.getCorrelator();
        try {
            TaskMonitor monitor = VTTaskMonitor.getTaskMonitor();
            ImpliedMatchUtils.updateImpliedMatchForClearedAssocation(source, destination, this.session, correlator, monitor);
        }
        catch (CancelledException e) {
            Msg.info((Object)this, (Object)"User cancelled finding implied matches when clearing an assocation");
        }
    }

    @Override
    public void optionsChanged(Options options) {
        this.autoCreateImpliedMatches = options.getBoolean("Accept Match Options.Auto Create Implied Matches", false);
    }

    @Override
    public void markupItemStatusChanged(VTMarkupItem markupItem) {
    }

    @Override
    public void disposed() {
    }

    @Override
    public void markupItemSelected(VTMarkupItem markupItem) {
    }

    @Override
    public void matchSelected(MatchInfo matchInfo) {
    }

    @Override
    public void sessionUpdated(DomainObjectChangedEvent ev) {
    }
}

