/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.model.columns;

import ghidra.app.plugin.core.debug.gui.model.ObjectTableModel;
import ghidra.app.plugin.core.debug.gui.model.columns.TraceValueObjectPropertyColumn;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.trace.model.target.TraceObjectValue;

public abstract class AbstractTraceValueObjectAddressColumn
extends TraceValueObjectPropertyColumn<Address> {
    private final String attributeName;

    public AbstractTraceValueObjectAddressColumn(String attributeName) {
        super(Address.class);
        this.attributeName = attributeName;
    }

    protected abstract Address fromRange(AddressRange var1);

    @Override
    public ObjectTableModel.ValueProperty<Address> getProperty(ObjectTableModel.ValueRow row) {
        return new ObjectTableModel.ValueAddressProperty(row){

            @Override
            public Address getValue() {
                Object object;
                TraceObjectValue entry = this.row.getAttributeEntry(AbstractTraceValueObjectAddressColumn.this.attributeName);
                if (entry == null || !((object = entry.getValue()) instanceof AddressRange)) {
                    return null;
                }
                AddressRange range = (AddressRange)object;
                return AbstractTraceValueObjectAddressColumn.this.fromRange(range);
            }

            @Override
            public boolean isModified() {
                return this.row.isAttributeModified(AbstractTraceValueObjectAddressColumn.this.attributeName);
            }
        };
    }
}

