/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti.types;

import ghidra.app.util.bin.format.golang.rtti.GoRttiMapper;
import ghidra.app.util.bin.format.golang.rtti.GoTypeManager;
import ghidra.app.util.bin.format.golang.rtti.types.GoType;
import ghidra.program.model.data.DataType;
import java.io.IOException;

public class GoTypeBridge
extends GoType {
    private DataType ghidraType;
    private final GoType delegateGoType;
    private final String delegateTypeName;

    public GoTypeBridge(GoType delegateGoType, DataType ghidraType, GoRttiMapper goBinary) {
        this.ghidraType = ghidraType;
        this.delegateGoType = delegateGoType;
        this.delegateTypeName = delegateGoType.getName();
        this.programContext = goBinary;
    }

    public GoTypeBridge(String delegateGoTypeName, DataType ghidraType, GoRttiMapper goBinary) {
        this.ghidraType = ghidraType;
        this.delegateGoType = null;
        this.delegateTypeName = delegateGoTypeName;
        this.programContext = goBinary;
    }

    @Override
    public DataType recoverDataType() throws IOException {
        GoTypeManager goTypes = this.programContext.getGoTypes();
        if (this.ghidraType == null) {
            this.ghidraType = goTypes.getDataType(this.delegateGoType);
        }
        return this.ghidraType;
    }

    @Override
    public String getPackagePathString() {
        return this.delegateGoType != null ? this.delegateGoType.getPackagePathString() : "";
    }

    @Override
    public String getName() {
        return this.delegateTypeName;
    }

    @Override
    public String toString() {
        return "GoTypeBridge [ghidraType=" + String.valueOf(this.ghidraType) + ", delegateGoType=" + String.valueOf(this.delegateGoType) + "]";
    }
}

