/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.pagedump;

import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.file.formats.dump.pagedump.PhysicalMemoryRun;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class PhysicalMemoryDescriptor
implements StructConverter {
    public static final String NAME = "PAGEDUMP_PHYS_MEMORY_DESCRIPTOR";
    private int numberOfRuns;
    private long numberOfPages;
    private PhysicalMemoryRun[] runs;
    private DumpFileReader reader;
    private long index;

    PhysicalMemoryDescriptor(DumpFileReader reader, long index) throws IOException {
        this.reader = reader;
        this.index = index;
        this.parse();
    }

    private void parse() throws IOException {
        this.reader.setPointerIndex(this.index);
        int nruns = (int)this.reader.readNextPointer();
        if (nruns == 1162297680) {
            this.setNumberOfRuns(0);
            return;
        }
        this.setNumberOfRuns(nruns);
        this.setNumberOfPages(this.reader.readNextPointer());
        this.runs = new PhysicalMemoryRun[this.numberOfRuns];
        for (int i = 0; i < this.numberOfRuns; ++i) {
            this.setRuns(new PhysicalMemoryRun(this.reader, this.reader.getPointerIndex()), i);
        }
    }

    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(DWORD, 4, "NumberOfRuns", null);
        struct.add(DWORD, 4, "NumberOfPages", null);
        DataType t = this.runs[0].toDataType();
        ArrayDataType a = new ArrayDataType(t, this.numberOfRuns, t.getLength());
        struct.add((DataType)a, a.getLength(), "Runs", null);
        struct.setCategoryPath(new CategoryPath("/PDMP"));
        return struct;
    }

    public int getNumberOfRuns() {
        return this.numberOfRuns;
    }

    public void setNumberOfRuns(int numberOfRuns) {
        this.numberOfRuns = numberOfRuns;
    }

    public long getNumberOfPages() {
        return this.numberOfPages;
    }

    public void setNumberOfPages(long numberOfPages) {
        this.numberOfPages = numberOfPages;
    }

    public PhysicalMemoryRun[] getRuns() {
        return this.runs;
    }

    public void setRuns(PhysicalMemoryRun run, int index) {
        this.runs[index] = run;
    }
}

