/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.btree;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.file.formats.ios.btree.BTreeHeaderRecord;
import ghidra.file.formats.ios.btree.BTreeMapRecord;
import ghidra.file.formats.ios.btree.BTreeNodeDescriptor;
import ghidra.file.formats.ios.btree.BTreeUserDataRecord;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class BTreeRootNodeDescriptor
extends BTreeNodeDescriptor {
    private BTreeHeaderRecord headerRecord;
    private BTreeUserDataRecord userDataRecord;
    private BTreeMapRecord mapRecord;
    private List<BTreeNodeDescriptor> nodes = new ArrayList<BTreeNodeDescriptor>();

    public BTreeRootNodeDescriptor(BinaryReader reader) throws IOException {
        super(reader);
        int nodeSize;
        this.headerRecord = new BTreeHeaderRecord(reader);
        this.userDataRecord = new BTreeUserDataRecord(reader);
        this.mapRecord = new BTreeMapRecord(reader, this.headerRecord);
        this.nodes.add(this);
        int i = nodeSize = this.headerRecord.getNodeSize() & 0xFFFF;
        while ((long)i < reader.length()) {
            reader.setPointerIndex(i);
            BTreeNodeDescriptor node = new BTreeNodeDescriptor(reader);
            this.nodes.add(node);
            node.readRecordOffsets(reader, i, this.headerRecord);
            node.readRecords(reader, i);
            i += nodeSize;
        }
        this.readRecordOffsets(reader, 0L, this.headerRecord);
    }

    public BTreeHeaderRecord getHeaderRecord() {
        return this.headerRecord;
    }

    public BTreeUserDataRecord getUserDataRecord() {
        return this.userDataRecord;
    }

    public BTreeMapRecord getMapRecord() {
        return this.mapRecord;
    }

    public BTreeNodeDescriptor getNode(int index) {
        try {
            return this.nodes.get(index);
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<BTreeNodeDescriptor> getNodes() {
        return this.nodes;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        return StructConverterUtil.toDataType(BTreeNodeDescriptor.class);
    }
}

