/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.dyld;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheMappingInfo;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheSlideInfoCommon;
import ghidra.app.util.bin.format.macho.dyld.DyldFixup;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DyldCacheSlideInfo4
extends DyldCacheSlideInfoCommon {
    private static final int DYLD_CACHE_SLIDE4_PAGE_NO_REBASE = 65535;
    private static final int DYLD_CACHE_SLIDE4_PAGE_USE_EXTRA = 32768;
    private static final int HEADERSIZE4 = 40;
    private int pageSize;
    private int pageStartsOffset;
    private int pageStartsCount;
    private int pageExtrasOffset;
    private int pageExtrasCount;
    private long deltaMask;
    private long valueAdd;
    private short[] pageStarts;
    private short[] pageExtras;

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPageStartsOffset() {
        return this.pageStartsOffset;
    }

    public int getPageStartsCount() {
        return this.pageStartsCount;
    }

    public int getPageExtrasOffset() {
        return this.pageExtrasOffset;
    }

    public int getPageExtrasCount() {
        return this.pageExtrasCount;
    }

    public long getDeltaMask() {
        return this.deltaMask;
    }

    public long getValueAdd() {
        return this.valueAdd;
    }

    public short[] getPageStarts() {
        return this.pageStarts;
    }

    public short[] getPageExtras() {
        return this.pageExtras;
    }

    public DyldCacheSlideInfo4(BinaryReader reader, DyldCacheMappingInfo mappingInfo) throws IOException {
        super(reader, mappingInfo);
        this.pageSize = reader.readNextInt();
        this.pageStartsOffset = reader.readNextInt();
        this.pageStartsCount = reader.readNextInt();
        this.pageExtrasOffset = reader.readNextInt();
        this.pageExtrasCount = reader.readNextInt();
        this.deltaMask = reader.readNextLong();
        this.valueAdd = reader.readNextLong();
        reader.setPointerIndex(this.pageStartsOffset);
        this.pageStarts = reader.readNextShortArray(this.pageStartsCount);
        reader.setPointerIndex(this.pageExtrasOffset);
        this.pageExtras = reader.readNextShortArray(this.pageExtrasCount);
    }

    @Override
    public List<DyldFixup> getSlideFixups(BinaryReader reader, int pointerSize, MessageLog log, TaskMonitor monitor) throws IOException, CancelledException {
        ArrayList<DyldFixup> fixups = new ArrayList<DyldFixup>();
        monitor.initialize((long)this.pageStartsCount, "Getting DYLD Cache V4 slide fixups...");
        for (int index = 0; index < this.pageStartsCount; ++index) {
            monitor.increment();
            long segmentOffset = this.pageSize * index;
            int pageEntry = Short.toUnsignedInt(this.pageStarts[index]);
            if (pageEntry == 65535) continue;
            if ((pageEntry & 0x8000) != 0) {
                int extraIndex = pageEntry & 0x3FFF;
                do {
                    pageEntry = Short.toUnsignedInt(this.pageExtras[extraIndex]);
                    long pageOffset = (pageEntry & 0x3FFF) * 4;
                    fixups.addAll(this.processPointerChain(segmentOffset, pageOffset, reader, monitor));
                    ++extraIndex;
                } while ((pageEntry & 0x8000) == 0);
                continue;
            }
            long pageOffset = pageEntry * 4;
            fixups.addAll(this.processPointerChain(segmentOffset, pageOffset, reader, monitor));
        }
        return fixups;
    }

    private List<DyldFixup> processPointerChain(long segmentOffset, long pageOffset, BinaryReader reader, TaskMonitor monitor) throws IOException, CancelledException {
        ArrayList<DyldFixup> fixups = new ArrayList<DyldFixup>(1024);
        long valueMask = this.deltaMask ^ 0xFFFFFFFFFFFFFFFFL;
        long deltaShift = Long.numberOfTrailingZeros(this.deltaMask);
        long delta = -1L;
        while (delta != 0L) {
            monitor.checkCancelled();
            long dataOffset = segmentOffset + pageOffset;
            int chainValue = reader.readInt(dataOffset);
            delta = ((long)chainValue & this.deltaMask) >> (int)deltaShift;
            chainValue = (int)((long)chainValue & valueMask);
            if ((chainValue & Short.MIN_VALUE) != 0) {
                chainValue = (chainValue & 0x3FFF8000) == 1073709056 ? (chainValue |= 0xC0000000) : (int)((long)chainValue + this.valueAdd);
            }
            fixups.add(new DyldFixup(dataOffset, Long.valueOf(chainValue), 4, null, null));
            pageOffset += delta * 4L;
        }
        return fixups;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("dyld_cache_slide_info4", 0);
        struct.add(DWORD, "version", "currently 4");
        struct.add(DWORD, "page_size", "currently 4096 (may also be 16384)");
        struct.add(DWORD, "page_starts_offset", "");
        struct.add(DWORD, "page_starts_count", "");
        struct.add(DWORD, "page_extras_offset", "");
        struct.add(DWORD, "page_extras_count", "");
        struct.add(QWORD, "delta_mask", "which (contiguous) set of bits contains the delta to the next rebase location (0xC0000000)");
        struct.add(QWORD, "value_add", "base address of cache");
        if (this.pageStartsOffset == 40) {
            struct.add((DataType)new ArrayDataType(WORD, this.pageStartsCount, 1), "page_starts", "");
        }
        if (this.pageExtrasOffset == 40 + this.pageStartsCount * 2) {
            struct.add((DataType)new ArrayDataType(WORD, this.pageExtrasCount, 1), "page_extras", "");
        }
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }
}

