/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table;

import docking.DockingWindowManager;
import docking.action.ToggleDockingAction;
import docking.action.ToolBarData;
import ghidra.framework.options.PreferenceState;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import java.awt.Component;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import resources.Icons;

public abstract class AbstractSelectionNavigationAction
extends ToggleDockingAction {
    private static final Icon ICON = Icons.NAVIGATE_ON_OUTGOING_EVENT_ICON;
    private static final String SELECTED_STATE = "SELECTION_NAVIGATION_SELECTED_STATE";
    private SelectionListener selectionListener;
    private boolean isInitialized;
    protected final JTable table;

    protected AbstractSelectionNavigationAction(String name, String owner, JTable table) {
        super(name, owner, false);
        this.table = table;
        this.selectionListener = new SelectionListener();
        this.setToolBarData(new ToolBarData(ICON));
        this.setDescription(HTMLUtilities.toHTML((String)"Toggle <b>on</b> means to navigate to the location\nin the program that corresponds to the selected row,\n as the selection changes."));
        this.setHelpLocation(new HelpLocation("Search", "Selection_Navigation"));
        this.setSelected(true);
        this.initialize();
    }

    public abstract void navigate();

    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        boolean installListener = enable && this.isSelected();
        this.toggleSelectionListening(installListener);
    }

    public void setSelected(boolean value) {
        super.setSelected(value);
        this.toggleSelectionListening(value);
    }

    protected void toggleSelectionListening(boolean listen) {
        if (this.table == null) {
            return;
        }
        if (listen) {
            this.table.getSelectionModel().addListSelectionListener(this.selectionListener);
        } else {
            this.table.getSelectionModel().removeListSelectionListener(this.selectionListener);
        }
        this.saveState();
    }

    private void initialize() {
        if (this.table.isDisplayable()) {
            this.restoreState();
            return;
        }
        this.table.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                long changeFlags = e.getChangeFlags();
                if (2L == (changeFlags & 2L) && AbstractSelectionNavigationAction.this.table.isDisplayable()) {
                    AbstractSelectionNavigationAction.this.restoreState();
                    AbstractSelectionNavigationAction.this.table.removeHierarchyListener(this);
                }
            }
        });
    }

    protected void saveState() {
        if (!this.isInitialized) {
            return;
        }
        DockingWindowManager dockingWindowManager = DockingWindowManager.getInstance((Component)this.table);
        if (dockingWindowManager == null) {
            return;
        }
        PreferenceState preferenceState = new PreferenceState();
        preferenceState.putBoolean(SELECTED_STATE, this.isSelected());
        String key = this.getOwner() + "_" + this.getName();
        dockingWindowManager.putPreferenceState(key, preferenceState);
    }

    protected void restoreState() {
        DockingWindowManager dockingWindowManager = DockingWindowManager.getInstance((Component)this.table);
        if (dockingWindowManager == null) {
            return;
        }
        String key = this.getOwner() + "_" + this.getName();
        PreferenceState preferenceState = dockingWindowManager.getPreferenceState(key);
        if (preferenceState != null) {
            boolean selectedValue = preferenceState.getBoolean(SELECTED_STATE, true);
            this.setSelected(selectedValue);
        }
        this.isInitialized = true;
    }

    private class SelectionListener
    implements ListSelectionListener {
        private SelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (AbstractSelectionNavigationAction.this.table.getSelectedRowCount() != 1) {
                return;
            }
            AbstractSelectionNavigationAction.this.navigate();
        }
    }
}

