/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.types.hfscommon;

import java.io.PrintStream;
import java.util.Date;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.types.hfs.MasterDirectoryBlock;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogNodeID;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSForkData;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusVolumeHeader;

public abstract class CommonHFSVolumeHeader
implements StructElements {
    public abstract short getSignature();

    public abstract long getAllocationBlockStart();

    public abstract long getAllocationBlockSize();

    public abstract long getFileSystemEnd();

    public abstract long getTotalBlocks();

    public abstract long getFreeBlocks();

    public abstract Date getCreateDate();

    public abstract Date getModifyDate();

    public abstract Date getBackupDate();

    public abstract CommonHFSCatalogNodeID getNextCatalogNodeID();

    public abstract CommonHFSForkData getCatalogFile();

    public abstract CommonHFSForkData getExtentsOverflowFile();

    public abstract void print(PrintStream var1, String var2);

    public static CommonHFSVolumeHeader create(HFSPlusVolumeHeader hdr) {
        return new HFSPlusImplementation(hdr);
    }

    public static CommonHFSVolumeHeader create(MasterDirectoryBlock hdr) {
        return new HFSImplementation(hdr);
    }

    public static class HFSImplementation
    extends CommonHFSVolumeHeader {
        private final MasterDirectoryBlock hdr;

        public HFSImplementation(MasterDirectoryBlock hdr) {
            this.hdr = hdr;
        }

        public short getSignature() {
            return this.hdr.getDrSigWord();
        }

        public long getAllocationBlockSize() {
            return Util.unsign(this.hdr.getDrAlBlkSiz());
        }

        public long getTotalBlocks() {
            return Util.unsign(this.hdr.getDrNmAlBlks());
        }

        public long getFreeBlocks() {
            return Util.unsign(this.hdr.getDrFreeBks());
        }

        public Date getCreateDate() {
            return this.hdr.getDrCrDateAsDate();
        }

        public Date getModifyDate() {
            return this.hdr.getDrLsModAsDate();
        }

        public Date getBackupDate() {
            return this.hdr.getDrVolBkUpAsDate();
        }

        public CommonHFSCatalogNodeID getNextCatalogNodeID() {
            return CommonHFSCatalogNodeID.create(this.hdr.getDrNxtCNID());
        }

        public CommonHFSForkData getCatalogFile() {
            return CommonHFSForkData.create(this.hdr.getDrCTExtRec(), Util.unsign(this.hdr.getDrCTFlSize()));
        }

        public CommonHFSForkData getExtentsOverflowFile() {
            return CommonHFSForkData.create(this.hdr.getDrXTExtRec(), Util.unsign(this.hdr.getDrXTFlSize()));
        }

        public void print(PrintStream err, String prefix) {
            this.hdr.print(err, prefix);
        }

        public long getAllocationBlockStart() {
            return Util.unsign(this.hdr.getDrAlBlSt());
        }

        public Dictionary getStructElements() {
            return this.hdr.getStructElements();
        }

        public long getFileSystemEnd() {
            return this.getAllocationBlockStart() * 512L + this.getTotalBlocks() * this.getAllocationBlockSize() + 1024L;
        }
    }

    public static class HFSPlusImplementation
    extends CommonHFSVolumeHeader {
        private final HFSPlusVolumeHeader hdr;

        public HFSPlusImplementation(HFSPlusVolumeHeader hdr) {
            this.hdr = hdr;
        }

        @Deprecated
        public HFSPlusVolumeHeader getUnderlying() {
            return this.hdr;
        }

        public short getSignature() {
            return this.hdr.getSignature();
        }

        public long getAllocationBlockSize() {
            return Util.unsign(this.hdr.getBlockSize());
        }

        public long getTotalBlocks() {
            return Util.unsign(this.hdr.getTotalBlocks());
        }

        public long getFreeBlocks() {
            return Util.unsign(this.hdr.getFreeBlocks());
        }

        public Date getCreateDate() {
            return this.hdr.getCreateDateAsDate();
        }

        public Date getModifyDate() {
            return this.hdr.getModifyDateAsDate();
        }

        public Date getBackupDate() {
            return this.hdr.getBackupDateAsDate();
        }

        public CommonHFSCatalogNodeID getNextCatalogNodeID() {
            return CommonHFSCatalogNodeID.create(this.hdr.getNextCatalogID());
        }

        public CommonHFSForkData getCatalogFile() {
            return CommonHFSForkData.create(this.hdr.getCatalogFile());
        }

        public CommonHFSForkData getExtentsOverflowFile() {
            return CommonHFSForkData.create(this.hdr.getExtentsFile());
        }

        public void print(PrintStream err, String prefix) {
            this.hdr.print(err, prefix);
        }

        public long getAllocationBlockStart() {
            return 0L;
        }

        public Dictionary getStructElements() {
            return this.hdr.getStructElements();
        }

        public long getFileSystemEnd() {
            return this.getTotalBlocks() * this.getAllocationBlockSize();
        }
    }
}

