/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.jparted.lib.ps.container;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.catacombae.jparted.lib.ps.container.ContainerHandlerFactory;
import org.catacombae.jparted.lib.ps.container.hfs.HFSContainerHandlerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ContainerType {
    NT_OS2_IFS,
    APPLE_HFS(HFSContainerHandlerFactory.class),
    APPLE_UNIX_SVR2,
    LINUX_NATIVE;

    private LinkedList<Class<? extends ContainerHandlerFactory>> factoryClasses = new LinkedList();

    private ContainerType() {
    }

    private ContainerType(Class<? extends ContainerHandlerFactory> defaultFactoryClass) {
        this.factoryClasses.addLast(defaultFactoryClass);
    }

    public void addFactoryClass(Class<? extends ContainerHandlerFactory> factoryClass) {
        this.factoryClasses.addLast(factoryClass);
    }

    public List<Class<? extends ContainerHandlerFactory>> getFactoryClasses() {
        return new ArrayList<Class<? extends ContainerHandlerFactory>>(this.factoryClasses);
    }

    public ContainerHandlerFactory createDefaultHandlerFactory() {
        if (this.factoryClasses.size() == 0) {
            return null;
        }
        Class<? extends ContainerHandlerFactory> factoryClass = this.factoryClasses.getFirst();
        return ContainerType.createHandlerFactory(factoryClass);
    }

    public static ContainerHandlerFactory createHandlerFactory(Class<? extends ContainerHandlerFactory> factoryClass) {
        try {
            Constructor<? extends ContainerHandlerFactory> c = factoryClass.getConstructor(new Class[0]);
            return c.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }
}

