/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractParsableItem;
import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.LocalVariableFlags;

public class LocalVariableAttributes
extends AbstractParsableItem {
    private long offset;
    private int segment;
    private LocalVariableFlags flags;

    public LocalVariableAttributes(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        this.offset = reader.parseUnsignedIntVal();
        this.segment = pdb.parseSegment(reader);
        this.flags = new LocalVariableFlags(reader);
    }

    @Override
    public void emit(StringBuilder builder) {
        this.flags.emit(builder);
        builder.insert(0, String.format("[%04X:%08X]: ", this.segment, this.offset));
    }
}

