/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.label;

import ghidra.framework.cmd.Command;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SymbolTable;

public class ExternalEntryCmd
implements Command<Program> {
    private Address addr;
    private boolean isEntry;

    public ExternalEntryCmd(Address addr, boolean isEntry) {
        this.addr = addr;
        this.isEntry = isEntry;
    }

    public boolean applyTo(Program program) {
        SymbolTable st = program.getSymbolTable();
        if (this.isEntry) {
            st.addExternalEntryPoint(this.addr);
        } else {
            st.removeExternalEntryPoint(this.addr);
        }
        return true;
    }

    public String getName() {
        return "Set External" + this.isEntry;
    }

    public String getStatusMsg() {
        return "";
    }
}

