/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.dwarf.DWARFCompilationUnit;
import ghidra.app.util.bin.format.dwarf.DWARFLocation;
import ghidra.app.util.bin.format.dwarf.DWARFProgram;
import ghidra.app.util.bin.format.dwarf.DWARFRange;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFForm;
import ghidra.program.model.data.LEB128;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DWARFLocationList {
    public static final DWARFLocationList EMPTY = new DWARFLocationList(List.of());
    private List<DWARFLocation> list;

    public static DWARFLocationList withWildcardRange(byte[] expr) {
        return new DWARFLocationList(List.of(new DWARFLocation(null, expr)));
    }

    public static DWARFLocationList readV4(BinaryReader reader, DWARFCompilationUnit cu) throws IOException {
        long maxAddrVal;
        ArrayList<DWARFLocation> results = new ArrayList<DWARFLocation>();
        byte pointerSize = cu.getPointerSize();
        long baseAddress = cu.getPCRange().getFrom();
        long l = maxAddrVal = pointerSize == 4 ? 0xFFFFFFFFL : -1L;
        while (reader.hasNext()) {
            long beginning = reader.readNextUnsignedValue(pointerSize);
            long ending = reader.readNextUnsignedValue(pointerSize);
            if (beginning == 0L && ending == 0L) break;
            if (beginning == maxAddrVal) {
                baseAddress = ending;
                continue;
            }
            int size = reader.readNextUnsignedShort();
            byte[] expr = reader.readNextByteArray(size);
            if (beginning == ending) continue;
            DWARFRange range = new DWARFRange(baseAddress + beginning, baseAddress + ending);
            results.add(new DWARFLocation(range, expr));
        }
        return new DWARFLocationList(results);
    }

    public static DWARFLocationList readV5(BinaryReader reader, DWARFCompilationUnit cu) throws IOException {
        int lleId;
        long baseAddr = cu.getPCRange().getFrom();
        DWARFProgram dprog = cu.getProgram();
        ArrayList<DWARFLocation> list = new ArrayList<DWARFLocation>();
        block10: while (reader.hasNext() && (lleId = reader.readNextUnsignedByte()) != 0) {
            switch (lleId) {
                case 1: {
                    int addrIndex = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
                    baseAddr = dprog.getAddress(DWARFForm.DW_FORM_addrx, addrIndex, cu);
                    continue block10;
                }
                case 2: {
                    int startAddrIndex = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
                    int endAddrIndex = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
                    byte[] expr = reader.readNext(DWARFLocationList::uleb128SizedByteArray);
                    long start = dprog.getAddress(DWARFForm.DW_FORM_addrx, startAddrIndex, cu);
                    long end = dprog.getAddress(DWARFForm.DW_FORM_addrx, endAddrIndex, cu);
                    list.add(new DWARFLocation(start, end, expr));
                    continue block10;
                }
                case 3: {
                    int startAddrIndex = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
                    int len = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
                    byte[] expr = reader.readNext(DWARFLocationList::uleb128SizedByteArray);
                    long start = dprog.getAddress(DWARFForm.DW_FORM_addrx, startAddrIndex, cu);
                    list.add(new DWARFLocation(start, start + (long)len, expr));
                    continue block10;
                }
                case 4: {
                    int startOfs = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
                    int endOfs = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
                    byte[] expr = reader.readNext(DWARFLocationList::uleb128SizedByteArray);
                    list.add(new DWARFLocation(baseAddr + (long)startOfs, baseAddr + (long)endOfs, expr));
                    continue block10;
                }
                case 5: {
                    byte[] expr = reader.readNext(DWARFLocationList::uleb128SizedByteArray);
                    list.add(new DWARFLocation(DWARFRange.EMPTY, expr));
                    continue block10;
                }
                case 6: {
                    baseAddr = reader.readNextUnsignedValue(cu.getPointerSize());
                    continue block10;
                }
                case 7: {
                    long startAddr = reader.readNextUnsignedValue(cu.getPointerSize());
                    long endAddr = reader.readNextUnsignedValue(cu.getPointerSize());
                    byte[] expr = reader.readNext(DWARFLocationList::uleb128SizedByteArray);
                    list.add(new DWARFLocation(startAddr, endAddr, expr));
                    continue block10;
                }
                case 8: {
                    long startAddr = reader.readNextUnsignedValue(cu.getPointerSize());
                    int len = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
                    byte[] expr = reader.readNext(DWARFLocationList::uleb128SizedByteArray);
                    list.add(new DWARFLocation(startAddr, startAddr + (long)len, expr));
                    continue block10;
                }
            }
            throw new IOException("Unsupported DWARF Location List Entry type: %d".formatted(lleId));
        }
        return new DWARFLocationList(list);
    }

    public DWARFLocationList(List<DWARFLocation> list) {
        this.list = list;
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public DWARFLocation getLocationContaining(long pc) {
        for (DWARFLocation loc : this.list) {
            if (!loc.contains(pc)) continue;
            return loc;
        }
        return null;
    }

    public DWARFLocation getFirstLocation() {
        return !this.list.isEmpty() ? this.list.get(0) : null;
    }

    public String toString() {
        return "DWARFLocationList: " + String.valueOf(this.list);
    }

    private static byte[] uleb128SizedByteArray(BinaryReader reader) throws IOException {
        int len = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
        if (len > 256) {
            throw new IOException("Invalid DWARF exprloc size: %d".formatted(len));
        }
        return reader.readNextByteArray(len);
    }
}

